// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This action allows you to create an immutable snapshot of a specific resource,
//
// such as an opportunity, within the context of an engagement. The snapshot
// captures a subset of the resource's data based on the schema defined by the
// provided template.
func (c *Client) CreateResourceSnapshot(ctx context.Context, params *CreateResourceSnapshotInput, optFns ...func(*Options)) (*CreateResourceSnapshotOutput, error) {
	if params == nil {
		params = &CreateResourceSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateResourceSnapshot", params, optFns, c.addOperationCreateResourceSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateResourceSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateResourceSnapshotInput struct {

	//  Specifies the catalog where the snapshot is created. Valid values are AWS and
	// Sandbox .
	//
	// This member is required.
	Catalog *string

	//  Specifies a unique, client-generated UUID to ensure that the request is
	// handled exactly once. This token helps prevent duplicate snapshot creations.
	//
	// This member is required.
	ClientToken *string

	//  The unique identifier of the engagement associated with this snapshot. This
	// field links the snapshot to a specific engagement context.
	//
	// This member is required.
	EngagementIdentifier *string

	//  The unique identifier of the specific resource to be snapshotted. The format
	// and constraints of this identifier depend on the ResourceType specified. For
	// example: For Opportunity type, it will be an opportunity ID.
	//
	// This member is required.
	ResourceIdentifier *string

	//  The name of the template that defines the schema for the snapshot. This
	// template determines which subset of the resource data will be included in the
	// snapshot. Must correspond to an existing and valid template for the specified
	// ResourceType .
	//
	// This member is required.
	ResourceSnapshotTemplateIdentifier *string

	//  Specifies the type of resource for which the snapshot is being created. This
	// field determines the structure and content of the snapshot. Must be one of the
	// supported resource types, such as: Opportunity .
	//
	// This member is required.
	ResourceType types.ResourceType

	noSmithyDocumentSerde
}

type CreateResourceSnapshotOutput struct {

	//  Specifies the Amazon Resource Name (ARN) that uniquely identifies the snapshot
	// created.
	Arn *string

	//  Specifies the revision number of the created snapshot. This field provides
	// important information about the snapshot's place in the sequence of snapshots
	// for the given resource.
	Revision *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateResourceSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateResourceSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateResourceSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateResourceSnapshot"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateResourceSnapshotMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateResourceSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateResourceSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateResourceSnapshot struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateResourceSnapshot) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateResourceSnapshot) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateResourceSnapshotInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateResourceSnapshotInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateResourceSnapshotMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateResourceSnapshot{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateResourceSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateResourceSnapshot",
	}
}
