// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows you to remove an existing association between an Opportunity and related
// entities, such as a Partner Solution, Amazon Web Services product, or an Amazon
// Web Services Marketplace offer. This operation is the counterpart to
// AssociateOpportunity , and it provides flexibility to manage associations as
// business needs change.
//
// Use this operation to update the associations of an Opportunity due to changes
// in the related entities, or if an association was made in error. Ensuring
// accurate associations helps maintain clarity and accuracy to track and manage
// business opportunities. When you replace an entity, first attach the new entity
// and then disassociate the one to be removed, especially if it's the last
// remaining entity that's required.
func (c *Client) DisassociateOpportunity(ctx context.Context, params *DisassociateOpportunityInput, optFns ...func(*Options)) (*DisassociateOpportunityOutput, error) {
	if params == nil {
		params = &DisassociateOpportunityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateOpportunity", params, optFns, c.addOperationDisassociateOpportunityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateOpportunityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateOpportunityInput struct {

	// Specifies the catalog associated with the request. This field takes a string
	// value from a predefined list: AWS or Sandbox . The catalog determines which
	// environment the opportunity disassociation is made in. Use AWS to disassociate
	// opportunities in the Amazon Web Services catalog, and Sandbox for testing in
	// secure, isolated environments.
	//
	// This member is required.
	Catalog *string

	// The opportunity's unique identifier for when you want to disassociate it from
	// related entities. This identifier helps to ensure that the correct opportunity
	// is updated.
	//
	// Validation: Ensure that the provided identifier corresponds to an existing
	// opportunity in the Amazon Web Services system because incorrect identifiers
	// result in an error and no changes are made.
	//
	// This member is required.
	OpportunityIdentifier *string

	// The related entity's identifier that you want to disassociate from the
	// opportunity. Depending on the type of entity, this could be a simple identifier
	// or an Amazon Resource Name (ARN) for entities managed through Amazon Web
	// Services Marketplace.
	//
	// For Amazon Web Services Marketplace entities, use the Amazon Web Services
	// Marketplace API to obtain the necessary ARNs. For guidance on retrieving these
	// ARNs, see [Amazon Web Services MarketplaceUsing the Amazon Web Services Marketplace Catalog API].
	//
	// Validation: Ensure the identifier or ARN is valid and corresponds to an
	// existing entity. An incorrect or invalid identifier results in an error.
	//
	// [Amazon Web Services MarketplaceUsing the Amazon Web Services Marketplace Catalog API]: https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html
	//
	// This member is required.
	RelatedEntityIdentifier *string

	// The type of the entity that you're disassociating from the opportunity. When
	// you specify the entity type, it helps the system correctly process the
	// disassociation request to ensure that the right connections are removed.
	//
	// Examples of entity types include Partner Solution, Amazon Web Services product,
	// and Amazon Web Services Marketplaceoffer. Ensure that the value matches one of
	// the expected entity types.
	//
	// Validation: Provide a valid entity type to help ensure successful
	// disassociation. An invalid or incorrect entity type results in an error.
	//
	// This member is required.
	RelatedEntityType types.RelatedEntityType

	noSmithyDocumentSerde
}

type DisassociateOpportunityOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateOpportunityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDisassociateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDisassociateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateOpportunity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateOpportunityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateOpportunity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisassociateOpportunity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateOpportunity",
	}
}
