// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a summary of an AWS Opportunity. This summary includes high-level
// details about the opportunity sourced from AWS, such as lifecycle information,
// customer details, and involvement type. It is useful for tracking updates on the
// AWS opportunity corresponding to an opportunity in the partner's account.
func (c *Client) GetAwsOpportunitySummary(ctx context.Context, params *GetAwsOpportunitySummaryInput, optFns ...func(*Options)) (*GetAwsOpportunitySummaryOutput, error) {
	if params == nil {
		params = &GetAwsOpportunitySummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAwsOpportunitySummary", params, optFns, c.addOperationGetAwsOpportunitySummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAwsOpportunitySummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAwsOpportunitySummaryInput struct {

	// Specifies the catalog in which the AWS Opportunity is located. Accepted values
	// include AWS for production opportunities or Sandbox for testing purposes. The
	// catalog determines which environment the opportunity data is pulled from.
	//
	// This member is required.
	Catalog *string

	// The unique identifier for the related partner opportunity. Use this field to
	// correlate an AWS opportunity with its corresponding partner opportunity.
	//
	// This member is required.
	RelatedOpportunityIdentifier *string

	noSmithyDocumentSerde
}

type GetAwsOpportunitySummaryOutput struct {

	// Specifies the catalog in which the AWS Opportunity exists. This is the
	// environment (e.g., AWS or Sandbox ) where the opportunity is being managed.
	//
	// This member is required.
	Catalog *string

	// Provides details about the customer associated with the AWS Opportunity,
	// including account information, industry, and other customer data. These details
	// help partners understand the business context of the opportunity.
	Customer *types.AwsOpportunityCustomer

	// Provides insights into the AWS Opportunity, including engagement score and
	// recommended actions that AWS suggests for the partner.
	Insights *types.AwsOpportunityInsights

	// Specifies the type of involvement AWS has in the opportunity, such as direct
	// cosell or advisory support. This field helps partners understand the role AWS
	// plays in advancing the opportunity.
	InvolvementType types.SalesInvolvementType

	// Provides a reason for any changes in the involvement type of AWS in the
	// opportunity. This field is used to track why the level of AWS engagement has
	// changed from For Visibility Only to Co-sell offering transparency into the
	// partnership dynamics.
	InvolvementTypeChangeReason types.InvolvementTypeChangeReason

	// Contains lifecycle information for the AWS Opportunity, including review
	// status, stage, and target close date. This field is crucial for partners to
	// monitor the progression of the opportunity.
	LifeCycle *types.AwsOpportunityLifeCycle

	// Details the AWS opportunity team, including members involved. This information
	// helps partners know who from AWS is engaged and what their role is.
	OpportunityTeam []types.AwsTeamMember

	// Specifies whether the AWS Opportunity originated from AWS or the partner. This
	// helps distinguish between opportunities that were sourced by AWS and those
	// referred by the partner.
	Origin types.OpportunityOrigin

	// Provides details about the project associated with the AWS Opportunity,
	// including the customer’s business problem, expected outcomes, and project scope.
	// This information is crucial for understanding the broader context of the
	// opportunity.
	Project *types.AwsOpportunityProject

	// Lists related entity identifiers, such as AWS products or partner solutions,
	// associated with the AWS Opportunity. These identifiers provide additional
	// context and help partners understand which AWS services are involved.
	RelatedEntityIds *types.AwsOpportunityRelatedEntities

	// Provides the unique identifier of the related partner opportunity, allowing
	// partners to link the AWS Opportunity to their corresponding opportunity in their
	// CRM system.
	RelatedOpportunityId *string

	// Defines the visibility level for the AWS Opportunity. Use Full visibility for
	// most cases, while Limited visibility is reserved for special programs or
	// sensitive opportunities.
	Visibility types.Visibility

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAwsOpportunitySummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetAwsOpportunitySummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetAwsOpportunitySummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAwsOpportunitySummary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetAwsOpportunitySummaryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAwsOpportunitySummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAwsOpportunitySummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAwsOpportunitySummary",
	}
}
