// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists all in-progress, completed, or failed EngagementFromOpportunity tasks
//
// that were initiated by the caller's account.
func (c *Client) ListEngagementFromOpportunityTasks(ctx context.Context, params *ListEngagementFromOpportunityTasksInput, optFns ...func(*Options)) (*ListEngagementFromOpportunityTasksOutput, error) {
	if params == nil {
		params = &ListEngagementFromOpportunityTasksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEngagementFromOpportunityTasks", params, optFns, c.addOperationListEngagementFromOpportunityTasksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEngagementFromOpportunityTasksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEngagementFromOpportunityTasksInput struct {

	//  Specifies the catalog related to the request. Valid values are:
	//
	//   - AWS: Retrieves the request from the production AWS environment.
	//
	//   - Sandbox: Retrieves the request from a sandbox environment used for testing
	//   or development purposes.
	//
	// This member is required.
	Catalog *string

	//  Filters tasks by the identifiers of the engagements they created or are
	// associated with.
	EngagementIdentifier []string

	//  Specifies the maximum number of results to return in a single page of the
	// response.Use this parameter to control the number of items returned in each
	// request, which can be useful for performance tuning and managing large result
	// sets.
	MaxResults *int32

	//  The token for requesting the next page of results. This value is obtained from
	// the NextToken field in the response of a previous call to this API. Use this
	// parameter for pagination when the result set spans multiple pages.
	NextToken *string

	//  The identifier of the original opportunity associated with this task.
	OpportunityIdentifier []string

	//  Specifies the sorting criteria for the returned results. This allows you to
	// order the tasks based on specific attributes.
	Sort *types.ListTasksSortBase

	//  Filters tasks by their unique identifiers. Use this when you want to retrieve
	// information about specific tasks.
	TaskIdentifier []string

	//  Filters the tasks based on their current status. This allows you to focus on
	// tasks in specific states.
	TaskStatus []types.TaskStatus

	noSmithyDocumentSerde
}

type ListEngagementFromOpportunityTasksOutput struct {

	//  A token used for pagination to retrieve the next page of results. If there are
	// more results available, this field will contain a token that can be used in a
	// subsequent API call to retrieve the next page. If there are no more results,
	// this field will be null or an empty string.
	NextToken *string

	//  TaskSummaries An array of TaskSummary objects containing details about each
	// task.
	TaskSummaries []types.ListEngagementFromOpportunityTaskSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEngagementFromOpportunityTasksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEngagementFromOpportunityTasks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEngagementFromOpportunityTasks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEngagementFromOpportunityTasks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListEngagementFromOpportunityTasksValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEngagementFromOpportunityTasks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEngagementFromOpportunityTasksPaginatorOptions is the paginator options for
// ListEngagementFromOpportunityTasks
type ListEngagementFromOpportunityTasksPaginatorOptions struct {
	//  Specifies the maximum number of results to return in a single page of the
	// response.Use this parameter to control the number of items returned in each
	// request, which can be useful for performance tuning and managing large result
	// sets.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEngagementFromOpportunityTasksPaginator is a paginator for
// ListEngagementFromOpportunityTasks
type ListEngagementFromOpportunityTasksPaginator struct {
	options   ListEngagementFromOpportunityTasksPaginatorOptions
	client    ListEngagementFromOpportunityTasksAPIClient
	params    *ListEngagementFromOpportunityTasksInput
	nextToken *string
	firstPage bool
}

// NewListEngagementFromOpportunityTasksPaginator returns a new
// ListEngagementFromOpportunityTasksPaginator
func NewListEngagementFromOpportunityTasksPaginator(client ListEngagementFromOpportunityTasksAPIClient, params *ListEngagementFromOpportunityTasksInput, optFns ...func(*ListEngagementFromOpportunityTasksPaginatorOptions)) *ListEngagementFromOpportunityTasksPaginator {
	if params == nil {
		params = &ListEngagementFromOpportunityTasksInput{}
	}

	options := ListEngagementFromOpportunityTasksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEngagementFromOpportunityTasksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEngagementFromOpportunityTasksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEngagementFromOpportunityTasks page.
func (p *ListEngagementFromOpportunityTasksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEngagementFromOpportunityTasksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEngagementFromOpportunityTasks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEngagementFromOpportunityTasksAPIClient is a client that implements the
// ListEngagementFromOpportunityTasks operation.
type ListEngagementFromOpportunityTasksAPIClient interface {
	ListEngagementFromOpportunityTasks(context.Context, *ListEngagementFromOpportunityTasksInput, ...func(*Options)) (*ListEngagementFromOpportunityTasksOutput, error)
}

var _ ListEngagementFromOpportunityTasksAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEngagementFromOpportunityTasks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEngagementFromOpportunityTasks",
	}
}
