// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of engagement invitations sent to the partner. This allows
// partners to view all pending or past engagement invitations, helping them track
// opportunities shared by AWS.
func (c *Client) ListEngagementInvitations(ctx context.Context, params *ListEngagementInvitationsInput, optFns ...func(*Options)) (*ListEngagementInvitationsOutput, error) {
	if params == nil {
		params = &ListEngagementInvitationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEngagementInvitations", params, optFns, c.addOperationListEngagementInvitationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEngagementInvitationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEngagementInvitationsInput struct {

	// Specifies the catalog from which to list the engagement invitations. Use AWS
	// for production invitations or Sandbox for testing environments.
	//
	// This member is required.
	Catalog *string

	// Specifies the type of participant for which to list engagement invitations.
	// Identifies the role of the participant.
	//
	// This member is required.
	ParticipantType types.ParticipantType

	//  Retrieves a list of engagement invitation summaries based on specified
	// filters. The ListEngagementInvitations operation allows you to view all
	// invitations that you have sent or received. You must specify the ParticipantType
	// to filter invitations where you are either the SENDER or the RECEIVER.
	// Invitations will automatically expire if not accepted within 15 days.
	EngagementIdentifier []string

	// Specifies the maximum number of engagement invitations to return in the
	// response. If more results are available, a pagination token will be provided.
	MaxResults *int32

	// A pagination token used to retrieve additional pages of results when the
	// response to a previous request was truncated. Pass this token to continue
	// listing invitations from where the previous call left off.
	NextToken *string

	// Defines the type of payload associated with the engagement invitations to be
	// listed. The attributes in this payload help decide on acceptance or rejection of
	// the invitation.
	PayloadType []types.EngagementInvitationPayloadType

	//  List of sender AWS account IDs to filter the invitations.
	SenderAwsAccountId []string

	// Specifies the sorting options for listing engagement invitations. Invitations
	// can be sorted by fields such as InvitationDate or Status to help partners view
	// results in their preferred order.
	Sort *types.OpportunityEngagementInvitationSort

	//  Status values to filter the invitations.
	Status []types.InvitationStatus

	noSmithyDocumentSerde
}

type ListEngagementInvitationsOutput struct {

	// An array containing summaries of engagement invitations. Each summary includes
	// information such as the invitation title, invitation date, and the current
	// status of the invitation.
	EngagementInvitationSummaries []types.EngagementInvitationSummary

	// A pagination token returned when there are more results available than can be
	// returned in a single call. Use this token to retrieve additional pages of
	// engagement invitation summaries.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEngagementInvitationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEngagementInvitations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEngagementInvitations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEngagementInvitations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListEngagementInvitationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEngagementInvitations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEngagementInvitationsPaginatorOptions is the paginator options for
// ListEngagementInvitations
type ListEngagementInvitationsPaginatorOptions struct {
	// Specifies the maximum number of engagement invitations to return in the
	// response. If more results are available, a pagination token will be provided.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEngagementInvitationsPaginator is a paginator for ListEngagementInvitations
type ListEngagementInvitationsPaginator struct {
	options   ListEngagementInvitationsPaginatorOptions
	client    ListEngagementInvitationsAPIClient
	params    *ListEngagementInvitationsInput
	nextToken *string
	firstPage bool
}

// NewListEngagementInvitationsPaginator returns a new
// ListEngagementInvitationsPaginator
func NewListEngagementInvitationsPaginator(client ListEngagementInvitationsAPIClient, params *ListEngagementInvitationsInput, optFns ...func(*ListEngagementInvitationsPaginatorOptions)) *ListEngagementInvitationsPaginator {
	if params == nil {
		params = &ListEngagementInvitationsInput{}
	}

	options := ListEngagementInvitationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEngagementInvitationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEngagementInvitationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEngagementInvitations page.
func (p *ListEngagementInvitationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEngagementInvitationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEngagementInvitations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEngagementInvitationsAPIClient is a client that implements the
// ListEngagementInvitations operation.
type ListEngagementInvitationsAPIClient interface {
	ListEngagementInvitations(context.Context, *ListEngagementInvitationsInput, ...func(*Options)) (*ListEngagementInvitationsOutput, error)
}

var _ ListEngagementInvitationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEngagementInvitations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEngagementInvitations",
	}
}
