// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the associations between resources and engagements where the caller is a
// member and has at least one snapshot in the engagement.
func (c *Client) ListEngagementResourceAssociations(ctx context.Context, params *ListEngagementResourceAssociationsInput, optFns ...func(*Options)) (*ListEngagementResourceAssociationsOutput, error) {
	if params == nil {
		params = &ListEngagementResourceAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEngagementResourceAssociations", params, optFns, c.addOperationListEngagementResourceAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEngagementResourceAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEngagementResourceAssociationsInput struct {

	// Specifies the catalog in which to search for engagement-resource associations.
	// Valid Values: "AWS" or "Sandbox"
	//
	//   - AWS for production environments.
	//
	//   - Sandbox for testing and development purposes.
	//
	// This member is required.
	Catalog *string

	// Filters the response to include only snapshots of resources owned by the
	// specified AWS account ID. Use this when you want to find associations related to
	// resources owned by a particular account.
	CreatedBy *string

	// Filters the results to include only associations related to the specified
	// engagement. Use this when you want to find all resources associated with a
	// specific engagement.
	EngagementIdentifier *string

	// Limits the number of results returned in a single call. Use this to control the
	// number of results returned, especially useful for pagination.
	MaxResults *int32

	// A token used for pagination of results. Include this token in subsequent
	// requests to retrieve the next set of results.
	NextToken *string

	// Filters the results to include only associations with the specified resource.
	// Varies depending on the resource type. Use this when you want to find all
	// engagements associated with a specific resource.
	ResourceIdentifier *string

	//  Filters the results to include only associations with resources of the
	// specified type.
	ResourceType types.ResourceType

	noSmithyDocumentSerde
}

type ListEngagementResourceAssociationsOutput struct {

	//  A list of engagement-resource association summaries.
	//
	// This member is required.
	EngagementResourceAssociationSummaries []types.EngagementResourceAssociationSummary

	//  A token to retrieve the next set of results. Use this token in a subsequent
	// request to retrieve additional results if the response was truncated.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEngagementResourceAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEngagementResourceAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEngagementResourceAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEngagementResourceAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListEngagementResourceAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEngagementResourceAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEngagementResourceAssociationsPaginatorOptions is the paginator options for
// ListEngagementResourceAssociations
type ListEngagementResourceAssociationsPaginatorOptions struct {
	// Limits the number of results returned in a single call. Use this to control the
	// number of results returned, especially useful for pagination.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEngagementResourceAssociationsPaginator is a paginator for
// ListEngagementResourceAssociations
type ListEngagementResourceAssociationsPaginator struct {
	options   ListEngagementResourceAssociationsPaginatorOptions
	client    ListEngagementResourceAssociationsAPIClient
	params    *ListEngagementResourceAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListEngagementResourceAssociationsPaginator returns a new
// ListEngagementResourceAssociationsPaginator
func NewListEngagementResourceAssociationsPaginator(client ListEngagementResourceAssociationsAPIClient, params *ListEngagementResourceAssociationsInput, optFns ...func(*ListEngagementResourceAssociationsPaginatorOptions)) *ListEngagementResourceAssociationsPaginator {
	if params == nil {
		params = &ListEngagementResourceAssociationsInput{}
	}

	options := ListEngagementResourceAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEngagementResourceAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEngagementResourceAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEngagementResourceAssociations page.
func (p *ListEngagementResourceAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEngagementResourceAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEngagementResourceAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEngagementResourceAssociationsAPIClient is a client that implements the
// ListEngagementResourceAssociations operation.
type ListEngagementResourceAssociationsAPIClient interface {
	ListEngagementResourceAssociations(context.Context, *ListEngagementResourceAssociationsInput, ...func(*Options)) (*ListEngagementResourceAssociationsOutput, error)
}

var _ ListEngagementResourceAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEngagementResourceAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEngagementResourceAssociations",
	}
}
