// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use this action to submit an Opportunity that was previously created by partner
// for AWS review. After you perform this action, the Opportunity becomes
// non-editable until it is reviewed by AWS and has LifeCycle.ReviewStatus  as
// either Approved or Action Required .
func (c *Client) SubmitOpportunity(ctx context.Context, params *SubmitOpportunityInput, optFns ...func(*Options)) (*SubmitOpportunityOutput, error) {
	if params == nil {
		params = &SubmitOpportunityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SubmitOpportunity", params, optFns, c.addOperationSubmitOpportunityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SubmitOpportunityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SubmitOpportunityInput struct {

	// Specifies the catalog related to the request. Valid values are:
	//
	//   - AWS: Submits the opportunity request from the production AWS environment.
	//
	//   - Sandbox: Submits the opportunity request from a sandbox environment used
	//   for testing or development purposes.
	//
	// This member is required.
	Catalog *string

	// The identifier of the Opportunity previously created by partner and needs to be
	// submitted.
	//
	// This member is required.
	Identifier *string

	// Specifies the level of AWS sellers' involvement on the opportunity. Valid
	// values:
	//
	//   - Co-sell : Indicates the user wants to co-sell with AWS. Share the
	//   opportunity with AWS to receive deal assistance and support.
	//
	//   - For Visibility Only : Indicates that the user does not need support from AWS
	//   Sales Rep. Share this opportunity with AWS for visibility only, you will not
	//   receive deal assistance and support.
	//
	// This member is required.
	InvolvementType types.SalesInvolvementType

	// Determines whether to restrict visibility of the opportunity from AWS sales.
	// Default value is Full. Valid values:
	//
	//   - Full : The opportunity is fully visible to AWS sales.
	//
	//   - Limited : The opportunity has restricted visibility to AWS sales.
	Visibility types.Visibility

	noSmithyDocumentSerde
}

type SubmitOpportunityOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSubmitOpportunityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpSubmitOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpSubmitOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SubmitOpportunity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpSubmitOpportunityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSubmitOpportunity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSubmitOpportunity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SubmitOpportunity",
	}
}
