// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the Opportunity record identified by a given Identifier . This operation
// allows you to modify the details of an existing opportunity to reflect the
// latest information and progress. Use this action to keep the opportunity record
// up-to-date and accurate.
//
// When you perform updates, include the entire payload with each request. If any
// field is omitted, the API assumes that the field is set to null . The best
// practice is to always perform a GetOpportunity to retrieve the latest values,
// then send the complete payload with the updated values to be changed.
func (c *Client) UpdateOpportunity(ctx context.Context, params *UpdateOpportunityInput, optFns ...func(*Options)) (*UpdateOpportunityOutput, error) {
	if params == nil {
		params = &UpdateOpportunityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateOpportunity", params, optFns, c.addOperationUpdateOpportunityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateOpportunityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateOpportunityInput struct {

	// Specifies the catalog associated with the request. This field takes a string
	// value from a predefined list: AWS or Sandbox . The catalog determines which
	// environment the opportunity is updated in. Use AWS to update real opportunities
	// in the production environment, and Sandbox for testing in secure, isolated
	// environments. When you use the Sandbox catalog, it allows you to simulate and
	// validate your interactions with Amazon Web Services services without affecting
	// live data or operations.
	//
	// This member is required.
	Catalog *string

	// Read-only, system generated Opportunity unique identifier.
	//
	// This member is required.
	Identifier *string

	// DateTime when the opportunity was last modified.
	//
	// This member is required.
	LastModifiedDate *time.Time

	// Specifies details of the customer associated with the Opportunity .
	Customer *types.Customer

	// An object that contains lifecycle details for the Opportunity .
	LifeCycle *types.LifeCycle

	// An object that contains marketing details for the Opportunity .
	Marketing *types.Marketing

	// Specifies if the opportunity is associated with national security concerns.
	// This flag is only applicable when the industry is Government . For
	// national-security-related opportunities, validation and compliance rules may
	// apply, impacting the opportunity's visibility and processing.
	NationalSecurity types.NationalSecurity

	// Specifies the opportunity type as a renewal, new, or expansion.
	//
	// Opportunity types:
	//
	//   - New opportunity: Represents a new business opportunity with a potential
	//   customer that's not previously engaged with your solutions or services.
	//
	//   - Renewal opportunity: Represents an opportunity to renew an existing
	//   contract or subscription with a current customer, ensuring continuity of
	//   service.
	//
	//   - Expansion opportunity: Represents an opportunity to expand the scope of an
	//   existing contract or subscription, either by adding new services or increasing
	//   the volume of existing services for a current customer.
	OpportunityType types.OpportunityType

	// Specifies the opportunity's unique identifier in the partner's CRM system. This
	// value is essential to track and reconcile because it's included in the outbound
	// payload sent back to the partner.
	PartnerOpportunityIdentifier *string

	// Identifies the type of support the partner needs from Amazon Web Services.
	//
	// Valid values:
	//
	//   - Cosell—Architectural Validation: Confirmation from Amazon Web Services that
	//   the partner's proposed solution architecture is aligned with Amazon Web Services
	//   best practices and poses minimal architectural risks.
	//
	//   - Cosell—Business Presentation: Request Amazon Web Services seller's
	//   participation in a joint customer presentation.
	//
	//   - Cosell—Competitive Information: Access to Amazon Web Services competitive
	//   resources and support for the partner's proposed solution.
	//
	//   - Cosell—Pricing Assistance: Connect with an AWS seller for support
	//   situations where a partner may be receiving an upfront discount on a service
	//   (for example: EDP deals).
	//
	//   - Cosell—Technical Consultation: Connection with an Amazon Web Services
	//   Solutions Architect to address the partner's questions about the proposed
	//   solution.
	//
	//   - Cosell—Total Cost of Ownership Evaluation: Assistance with quoting
	//   different cost savings of proposed solutions on Amazon Web Services versus
	//   on-premises or a traditional hosting environment.
	//
	//   - Cosell—Deal Support: Request Amazon Web Services seller's support to
	//   progress the opportunity (for example: joint customer call, strategic
	//   positioning).
	//
	//   - Cosell—Support for Public Tender/RFx: Opportunity related to the public
	//   sector where the partner needs RFx support from Amazon Web Services.
	PrimaryNeedsFromAws []types.PrimaryNeedFromAws

	// An object that contains project details summary for the Opportunity .
	Project *types.Project

	// Specifies details of a customer's procurement terms. Required only for partners
	// in eligible programs.
	SoftwareRevenue *types.SoftwareRevenue

	noSmithyDocumentSerde
}

type UpdateOpportunityOutput struct {

	// Read-only, system generated Opportunity unique identifier.
	//
	// This member is required.
	Id *string

	// DateTime when the opportunity was last modified.
	//
	// This member is required.
	LastModifiedDate *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateOpportunityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateOpportunity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateOpportunityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateOpportunity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateOpportunity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateOpportunity",
	}
}
