// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptography/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Exports a key from Amazon Web Services Payment Cryptography.
//
// Amazon Web Services Payment Cryptography simplifies key exchange by replacing
// the existing paper-based approach with a modern electronic approach. With
// ExportKey you can export symmetric keys using either symmetric and asymmetric
// key exchange mechanisms. Using this operation, you can share your Amazon Web
// Services Payment Cryptography generated keys with other service partners to
// perform cryptographic operations outside of Amazon Web Services Payment
// Cryptography
//
// For symmetric key exchange, Amazon Web Services Payment Cryptography uses the
// ANSI X9 TR-31 norm in accordance with PCI PIN guidelines. And for asymmetric key
// exchange, Amazon Web Services Payment Cryptography supports ANSI X9 TR-34 norm
// and RSA wrap and unwrap key exchange mechanism. Asymmetric key exchange methods
// are typically used to establish bi-directional trust between the two parties
// exhanging keys and are used for initial key exchange such as Key Encryption Key
// (KEK). After which you can export working keys using symmetric method to perform
// various cryptographic operations within Amazon Web Services Payment
// Cryptography.
//
// The TR-34 norm is intended for exchanging 3DES keys only and keys are imported
// in a WrappedKeyBlock format. Key attributes (such as KeyUsage, KeyAlgorithm,
// KeyModesOfUse, Exportability) are contained within the key block. With RSA wrap
// and unwrap, you can exchange both 3DES and AES-128 keys. The keys are imported
// in a WrappedKeyCryptogram format and you will need to specify the key attributes
// during import.
//
// You can also use ExportKey functionality to generate and export an IPEK
// (Initial Pin Encryption Key) from Amazon Web Services Payment Cryptography using
// either TR-31 or TR-34 export key exchange. IPEK is generated from BDK (Base
// Derivation Key) and ExportDukptInitialKey attribute KSN ( KeySerialNumber ). The
// generated IPEK does not persist within Amazon Web Services Payment Cryptography
// and has to be re-generated each time during export.
//
// For key exchange using TR-31 or TR-34 key blocks, you can also export optional
// blocks within the key block header which contain additional attribute
// information about the key. The KeyVersion within KeyBlockHeaders indicates the
// version of the key within the key block. Furthermore, KeyExportability within
// KeyBlockHeaders can be used to further restrict exportability of the key after
// export from Amazon Web Services Payment Cryptography.
//
// The OptionalBlocks contain the additional data related to the key. For
// information on data type that can be included within optional blocks, refer to [ASC X9.143-2022].
//
// Data included in key block headers is signed but transmitted in clear text.
// Sensitive or confidential information should not be included in optional blocks.
// Refer to ASC X9.143-2022 standard for information on allowed data type.
//
// # To export initial keys (KEK) or IPEK using TR-34
//
// Using this operation, you can export initial key using TR-34 asymmetric key
// exchange. You can only export KEK generated within Amazon Web Services Payment
// Cryptography. In TR-34 terminology, the sending party of the key is called Key
// Distribution Host (KDH) and the receiving party of the key is called Key
// Receiving Device (KRD). During key export process, KDH is Amazon Web Services
// Payment Cryptography which initiates key export and KRD is the user receiving
// the key.
//
// To initiate TR-34 key export, the KRD must obtain an export token by calling [GetParametersForExport].
// This operation also generates a key pair for the purpose of key export, signs
// the key and returns back the signing public key certificate (also known as KDH
// signing certificate) and root certificate chain. The KDH uses the private key to
// sign the the export payload and the signing public key certificate is provided
// to KRD to verify the signature. The KRD can import the root certificate into its
// Hardware Security Module (HSM), as required. The export token and the associated
// KDH signing certificate expires after 7 days.
//
// Next the KRD generates a key pair for the the purpose of encrypting the KDH key
// and provides the public key cerificate (also known as KRD wrapping certificate)
// back to KDH. The KRD will also import the root cerificate chain into Amazon Web
// Services Payment Cryptography by calling [ImportKey]for RootCertificatePublicKey . The KDH,
// Amazon Web Services Payment Cryptography, will use the KRD wrapping cerificate
// to encrypt (wrap) the key under export and signs it with signing private key to
// generate a TR-34 WrappedKeyBlock. For more information on TR-34 key export, see
// section [Exporting symmetric keys]in the Amazon Web Services Payment Cryptography User Guide.
//
// Set the following parameters:
//
//   - ExportAttributes : Specify export attributes in case of IPEK export. This
//     parameter is optional for KEK export.
//
//   - ExportKeyIdentifier : The KeyARN of the KEK or BDK (in case of IPEK) under
//     export.
//
//   - KeyMaterial : Use Tr34KeyBlock parameters.
//
//   - CertificateAuthorityPublicKeyIdentifier : The KeyARN of the certificate
//     chain that signed the KRD wrapping key certificate.
//
//   - ExportToken : Obtained from KDH by calling [GetParametersForImport].
//
//   - WrappingKeyCertificate : The public key certificate in PEM format (base64
//     encoded) of the KRD wrapping key Amazon Web Services Payment Cryptography uses
//     for encryption of the TR-34 export payload. This certificate must be signed by
//     the root certificate (CertificateAuthorityPublicKeyIdentifier) imported into
//     Amazon Web Services Payment Cryptography.
//
// When this operation is successful, Amazon Web Services Payment Cryptography
// returns the KEK or IPEK as a TR-34 WrappedKeyBlock.
//
// # To export initial keys (KEK) or IPEK using RSA Wrap and Unwrap
//
// Using this operation, you can export initial key using asymmetric RSA wrap and
// unwrap key exchange method. To initiate export, generate an asymmetric key pair
// on the receiving HSM and obtain the public key certificate in PEM format (base64
// encoded) for the purpose of wrapping and the root certifiate chain. Import the
// root certificate into Amazon Web Services Payment Cryptography by calling [ImportKey]for
// RootCertificatePublicKey .
//
// Next call ExportKey and set the following parameters:
//
//   - CertificateAuthorityPublicKeyIdentifier : The KeyARN of the certificate
//     chain that signed wrapping key certificate.
//
//   - KeyMaterial : Set to KeyCryptogram .
//
//   - WrappingKeyCertificate : The public key certificate in PEM format (base64
//     encoded) obtained by the receiving HSM and signed by the root certificate
//     (CertificateAuthorityPublicKeyIdentifier) imported into Amazon Web Services
//     Payment Cryptography. The receiving HSM uses its private key component to unwrap
//     the WrappedKeyCryptogram.
//
// When this operation is successful, Amazon Web Services Payment Cryptography
// returns the WrappedKeyCryptogram.
//
// # To export working keys or IPEK using TR-31
//
// Using this operation, you can export working keys or IPEK using TR-31 symmetric
// key exchange. In TR-31, you must use an initial key such as KEK to encrypt or
// wrap the key under export. To establish a KEK, you can use [CreateKey]or [ImportKey].
//
// Set the following parameters:
//
//   - ExportAttributes : Specify export attributes in case of IPEK export. This
//     parameter is optional for KEK export.
//
//   - ExportKeyIdentifier : The KeyARN of the KEK or BDK (in case of IPEK) under
//     export.
//
//   - KeyMaterial : Use Tr31KeyBlock parameters.
//
// When this operation is successful, Amazon Web Services Payment Cryptography
// returns the working key or IPEK as a TR-31 WrappedKeyBlock.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// [GetParametersForExport]
//
// [ImportKey]
//
// [Exporting symmetric keys]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-export.html
// [GetParametersForExport]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForExport.html
// [ImportKey]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html
// [ASC X9.143-2022]: https://webstore.ansi.org/standards/ascx9/ansix91432022
// [GetParametersForImport]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetParametersForImport.html
// [CreateKey]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html
func (c *Client) ExportKey(ctx context.Context, params *ExportKeyInput, optFns ...func(*Options)) (*ExportKeyOutput, error) {
	if params == nil {
		params = &ExportKeyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ExportKey", params, optFns, c.addOperationExportKeyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ExportKeyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ExportKeyInput struct {

	// The KeyARN of the key under export from Amazon Web Services Payment
	// Cryptography.
	//
	// This member is required.
	ExportKeyIdentifier *string

	// The key block format type, for example, TR-34 or TR-31, to use during key
	// material export.
	//
	// This member is required.
	KeyMaterial types.ExportKeyMaterial

	// The attributes for IPEK generation during export.
	ExportAttributes *types.ExportAttributes

	noSmithyDocumentSerde
}

type ExportKeyOutput struct {

	// The key material under export as a TR-34 WrappedKeyBlock or a TR-31
	// WrappedKeyBlock. or a RSA WrappedKeyCryptogram.
	WrappedKey *types.WrappedKey

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationExportKeyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpExportKey{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpExportKey{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ExportKey"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpExportKeyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opExportKey(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opExportKey(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ExportKey",
	}
}
