// Code generated by smithy-go-codegen DO NOT EDIT.

package pcaconnectorad

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pcaconnectorad/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateConnector struct {
}

func (*awsRestjson1_serializeOpCreateConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/connectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConnectorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConnectorInput(v *CreateConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConnectorInput(v *CreateConnectorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.DirectoryId != nil {
		ok := object.Key("DirectoryId")
		ok.String(*v.DirectoryId)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VpcInformation != nil {
		ok := object.Key("VpcInformation")
		if err := awsRestjson1_serializeDocumentVpcInformation(v.VpcInformation, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDirectoryRegistration struct {
}

func (*awsRestjson1_serializeOpCreateDirectoryRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDirectoryRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDirectoryRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDirectoryRegistrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDirectoryRegistrationInput(v *CreateDirectoryRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDirectoryRegistrationInput(v *CreateDirectoryRegistrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.DirectoryId != nil {
		ok := object.Key("DirectoryId")
		ok.String(*v.DirectoryId)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateServicePrincipalName struct {
}

func (*awsRestjson1_serializeOpCreateServicePrincipalName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateServicePrincipalName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateServicePrincipalNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateServicePrincipalNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateServicePrincipalNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateServicePrincipalNameInput(v *CreateServicePrincipalNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConnectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("ConnectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	if v.DirectoryRegistrationArn == nil || len(*v.DirectoryRegistrationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DirectoryRegistrationArn must not be empty")}
	}
	if v.DirectoryRegistrationArn != nil {
		if err := encoder.SetURI("DirectoryRegistrationArn").String(*v.DirectoryRegistrationArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateServicePrincipalNameInput(v *CreateServicePrincipalNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTemplate struct {
}

func (*awsRestjson1_serializeOpCreateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTemplateInput(v *CreateTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTemplateInput(v *CreateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ConnectorArn != nil {
		ok := object.Key("ConnectorArn")
		ok.String(*v.ConnectorArn)
	}

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentTemplateDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTemplateGroupAccessControlEntry struct {
}

func (*awsRestjson1_serializeOpCreateTemplateGroupAccessControlEntry) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTemplateGroupAccessControlEntry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTemplateGroupAccessControlEntryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}/accessControlEntries")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTemplateGroupAccessControlEntryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTemplateGroupAccessControlEntryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTemplateGroupAccessControlEntryInput(v *CreateTemplateGroupAccessControlEntryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTemplateGroupAccessControlEntryInput(v *CreateTemplateGroupAccessControlEntryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessRights != nil {
		ok := object.Key("AccessRights")
		if err := awsRestjson1_serializeDocumentAccessRights(v.AccessRights, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.GroupDisplayName != nil {
		ok := object.Key("GroupDisplayName")
		ok.String(*v.GroupDisplayName)
	}

	if v.GroupSecurityIdentifier != nil {
		ok := object.Key("GroupSecurityIdentifier")
		ok.String(*v.GroupSecurityIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConnector struct {
}

func (*awsRestjson1_serializeOpDeleteConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/connectors/{ConnectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConnectorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConnectorInput(v *DeleteConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConnectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("ConnectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDirectoryRegistration struct {
}

func (*awsRestjson1_serializeOpDeleteDirectoryRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDirectoryRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDirectoryRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations/{DirectoryRegistrationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDirectoryRegistrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDirectoryRegistrationInput(v *DeleteDirectoryRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryRegistrationArn == nil || len(*v.DirectoryRegistrationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DirectoryRegistrationArn must not be empty")}
	}
	if v.DirectoryRegistrationArn != nil {
		if err := encoder.SetURI("DirectoryRegistrationArn").String(*v.DirectoryRegistrationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteServicePrincipalName struct {
}

func (*awsRestjson1_serializeOpDeleteServicePrincipalName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteServicePrincipalName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteServicePrincipalNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteServicePrincipalNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteServicePrincipalNameInput(v *DeleteServicePrincipalNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConnectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("ConnectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	if v.DirectoryRegistrationArn == nil || len(*v.DirectoryRegistrationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DirectoryRegistrationArn must not be empty")}
	}
	if v.DirectoryRegistrationArn != nil {
		if err := encoder.SetURI("DirectoryRegistrationArn").String(*v.DirectoryRegistrationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTemplateInput(v *DeleteTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTemplateGroupAccessControlEntry struct {
}

func (*awsRestjson1_serializeOpDeleteTemplateGroupAccessControlEntry) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTemplateGroupAccessControlEntry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTemplateGroupAccessControlEntryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTemplateGroupAccessControlEntryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTemplateGroupAccessControlEntryInput(v *DeleteTemplateGroupAccessControlEntryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GroupSecurityIdentifier == nil || len(*v.GroupSecurityIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupSecurityIdentifier must not be empty")}
	}
	if v.GroupSecurityIdentifier != nil {
		if err := encoder.SetURI("GroupSecurityIdentifier").String(*v.GroupSecurityIdentifier); err != nil {
			return err
		}
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConnector struct {
}

func (*awsRestjson1_serializeOpGetConnector) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConnector) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConnectorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/connectors/{ConnectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConnectorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConnectorInput(v *GetConnectorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConnectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("ConnectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDirectoryRegistration struct {
}

func (*awsRestjson1_serializeOpGetDirectoryRegistration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDirectoryRegistration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDirectoryRegistrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations/{DirectoryRegistrationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDirectoryRegistrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDirectoryRegistrationInput(v *GetDirectoryRegistrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryRegistrationArn == nil || len(*v.DirectoryRegistrationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DirectoryRegistrationArn must not be empty")}
	}
	if v.DirectoryRegistrationArn != nil {
		if err := encoder.SetURI("DirectoryRegistrationArn").String(*v.DirectoryRegistrationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetServicePrincipalName struct {
}

func (*awsRestjson1_serializeOpGetServicePrincipalName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetServicePrincipalName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetServicePrincipalNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames/{ConnectorArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetServicePrincipalNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetServicePrincipalNameInput(v *GetServicePrincipalNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn == nil || len(*v.ConnectorArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConnectorArn must not be empty")}
	}
	if v.ConnectorArn != nil {
		if err := encoder.SetURI("ConnectorArn").String(*v.ConnectorArn); err != nil {
			return err
		}
	}

	if v.DirectoryRegistrationArn == nil || len(*v.DirectoryRegistrationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DirectoryRegistrationArn must not be empty")}
	}
	if v.DirectoryRegistrationArn != nil {
		if err := encoder.SetURI("DirectoryRegistrationArn").String(*v.DirectoryRegistrationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTemplate struct {
}

func (*awsRestjson1_serializeOpGetTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTemplateInput(v *GetTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTemplateGroupAccessControlEntry struct {
}

func (*awsRestjson1_serializeOpGetTemplateGroupAccessControlEntry) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTemplateGroupAccessControlEntry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTemplateGroupAccessControlEntryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTemplateGroupAccessControlEntryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTemplateGroupAccessControlEntryInput(v *GetTemplateGroupAccessControlEntryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GroupSecurityIdentifier == nil || len(*v.GroupSecurityIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupSecurityIdentifier must not be empty")}
	}
	if v.GroupSecurityIdentifier != nil {
		if err := encoder.SetURI("GroupSecurityIdentifier").String(*v.GroupSecurityIdentifier); err != nil {
			return err
		}
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListConnectors struct {
}

func (*awsRestjson1_serializeOpListConnectors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConnectors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConnectorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/connectors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConnectorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConnectorsInput(v *ListConnectorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDirectoryRegistrations struct {
}

func (*awsRestjson1_serializeOpListDirectoryRegistrations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDirectoryRegistrations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDirectoryRegistrationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDirectoryRegistrationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDirectoryRegistrationsInput(v *ListDirectoryRegistrationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListServicePrincipalNames struct {
}

func (*awsRestjson1_serializeOpListServicePrincipalNames) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListServicePrincipalNames) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListServicePrincipalNamesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/directoryRegistrations/{DirectoryRegistrationArn}/servicePrincipalNames")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListServicePrincipalNamesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListServicePrincipalNamesInput(v *ListServicePrincipalNamesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DirectoryRegistrationArn == nil || len(*v.DirectoryRegistrationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DirectoryRegistrationArn must not be empty")}
	}
	if v.DirectoryRegistrationArn != nil {
		if err := encoder.SetURI("DirectoryRegistrationArn").String(*v.DirectoryRegistrationArn); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTemplateGroupAccessControlEntries struct {
}

func (*awsRestjson1_serializeOpListTemplateGroupAccessControlEntries) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplateGroupAccessControlEntries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplateGroupAccessControlEntriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}/accessControlEntries")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplateGroupAccessControlEntriesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplateGroupAccessControlEntriesInput(v *ListTemplateGroupAccessControlEntriesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTemplates struct {
}

func (*awsRestjson1_serializeOpListTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplatesInput(v *ListTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConnectorArn != nil {
		encoder.SetQuery("ConnectorArn").String(*v.ConnectorArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplateInput(v *UpdateTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplateInput(v *UpdateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsRestjson1_serializeDocumentTemplateDefinition(v.Definition, ok); err != nil {
			return err
		}
	}

	if v.ReenrollAllCertificateHolders != nil {
		ok := object.Key("ReenrollAllCertificateHolders")
		ok.Boolean(*v.ReenrollAllCertificateHolders)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplateGroupAccessControlEntry struct {
}

func (*awsRestjson1_serializeOpUpdateTemplateGroupAccessControlEntry) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplateGroupAccessControlEntry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateGroupAccessControlEntryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateArn}/accessControlEntries/{GroupSecurityIdentifier}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplateGroupAccessControlEntryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplateGroupAccessControlEntryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplateGroupAccessControlEntryInput(v *UpdateTemplateGroupAccessControlEntryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.GroupSecurityIdentifier == nil || len(*v.GroupSecurityIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupSecurityIdentifier must not be empty")}
	}
	if v.GroupSecurityIdentifier != nil {
		if err := encoder.SetURI("GroupSecurityIdentifier").String(*v.GroupSecurityIdentifier); err != nil {
			return err
		}
	}

	if v.TemplateArn == nil || len(*v.TemplateArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateArn must not be empty")}
	}
	if v.TemplateArn != nil {
		if err := encoder.SetURI("TemplateArn").String(*v.TemplateArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplateGroupAccessControlEntryInput(v *UpdateTemplateGroupAccessControlEntryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessRights != nil {
		ok := object.Key("AccessRights")
		if err := awsRestjson1_serializeDocumentAccessRights(v.AccessRights, ok); err != nil {
			return err
		}
	}

	if v.GroupDisplayName != nil {
		ok := object.Key("GroupDisplayName")
		ok.String(*v.GroupDisplayName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessRights(v *types.AccessRights, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AutoEnroll) > 0 {
		ok := object.Key("AutoEnroll")
		ok.String(string(v.AutoEnroll))
	}

	if len(v.Enroll) > 0 {
		ok := object.Key("Enroll")
		ok.String(string(v.Enroll))
	}

	return nil
}

func awsRestjson1_serializeDocumentApplicationPolicies(v *types.ApplicationPolicies, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Critical != nil {
		ok := object.Key("Critical")
		ok.Boolean(*v.Critical)
	}

	if v.Policies != nil {
		ok := object.Key("Policies")
		if err := awsRestjson1_serializeDocumentApplicationPolicyList(v.Policies, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentApplicationPolicy(v types.ApplicationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ApplicationPolicyMemberPolicyObjectIdentifier:
		av := object.Key("PolicyObjectIdentifier")
		av.String(uv.Value)

	case *types.ApplicationPolicyMemberPolicyType:
		av := object.Key("PolicyType")
		av.String(string(uv.Value))

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentApplicationPolicyList(v []types.ApplicationPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentApplicationPolicy(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCertificateValidity(v *types.CertificateValidity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RenewalPeriod != nil {
		ok := object.Key("RenewalPeriod")
		if err := awsRestjson1_serializeDocumentValidityPeriod(v.RenewalPeriod, ok); err != nil {
			return err
		}
	}

	if v.ValidityPeriod != nil {
		ok := object.Key("ValidityPeriod")
		if err := awsRestjson1_serializeDocumentValidityPeriod(v.ValidityPeriod, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCryptoProvidersList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentEnrollmentFlagsV2(v *types.EnrollmentFlagsV2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableKeyReuseOnNtTokenKeysetStorageFull != nil {
		ok := object.Key("EnableKeyReuseOnNtTokenKeysetStorageFull")
		ok.Boolean(*v.EnableKeyReuseOnNtTokenKeysetStorageFull)
	}

	if v.IncludeSymmetricAlgorithms != nil {
		ok := object.Key("IncludeSymmetricAlgorithms")
		ok.Boolean(*v.IncludeSymmetricAlgorithms)
	}

	if v.NoSecurityExtension != nil {
		ok := object.Key("NoSecurityExtension")
		ok.Boolean(*v.NoSecurityExtension)
	}

	if v.RemoveInvalidCertificateFromPersonalStore != nil {
		ok := object.Key("RemoveInvalidCertificateFromPersonalStore")
		ok.Boolean(*v.RemoveInvalidCertificateFromPersonalStore)
	}

	if v.UserInteractionRequired != nil {
		ok := object.Key("UserInteractionRequired")
		ok.Boolean(*v.UserInteractionRequired)
	}

	return nil
}

func awsRestjson1_serializeDocumentEnrollmentFlagsV3(v *types.EnrollmentFlagsV3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableKeyReuseOnNtTokenKeysetStorageFull != nil {
		ok := object.Key("EnableKeyReuseOnNtTokenKeysetStorageFull")
		ok.Boolean(*v.EnableKeyReuseOnNtTokenKeysetStorageFull)
	}

	if v.IncludeSymmetricAlgorithms != nil {
		ok := object.Key("IncludeSymmetricAlgorithms")
		ok.Boolean(*v.IncludeSymmetricAlgorithms)
	}

	if v.NoSecurityExtension != nil {
		ok := object.Key("NoSecurityExtension")
		ok.Boolean(*v.NoSecurityExtension)
	}

	if v.RemoveInvalidCertificateFromPersonalStore != nil {
		ok := object.Key("RemoveInvalidCertificateFromPersonalStore")
		ok.Boolean(*v.RemoveInvalidCertificateFromPersonalStore)
	}

	if v.UserInteractionRequired != nil {
		ok := object.Key("UserInteractionRequired")
		ok.Boolean(*v.UserInteractionRequired)
	}

	return nil
}

func awsRestjson1_serializeDocumentEnrollmentFlagsV4(v *types.EnrollmentFlagsV4, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableKeyReuseOnNtTokenKeysetStorageFull != nil {
		ok := object.Key("EnableKeyReuseOnNtTokenKeysetStorageFull")
		ok.Boolean(*v.EnableKeyReuseOnNtTokenKeysetStorageFull)
	}

	if v.IncludeSymmetricAlgorithms != nil {
		ok := object.Key("IncludeSymmetricAlgorithms")
		ok.Boolean(*v.IncludeSymmetricAlgorithms)
	}

	if v.NoSecurityExtension != nil {
		ok := object.Key("NoSecurityExtension")
		ok.Boolean(*v.NoSecurityExtension)
	}

	if v.RemoveInvalidCertificateFromPersonalStore != nil {
		ok := object.Key("RemoveInvalidCertificateFromPersonalStore")
		ok.Boolean(*v.RemoveInvalidCertificateFromPersonalStore)
	}

	if v.UserInteractionRequired != nil {
		ok := object.Key("UserInteractionRequired")
		ok.Boolean(*v.UserInteractionRequired)
	}

	return nil
}

func awsRestjson1_serializeDocumentExtensionsV2(v *types.ExtensionsV2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationPolicies != nil {
		ok := object.Key("ApplicationPolicies")
		if err := awsRestjson1_serializeDocumentApplicationPolicies(v.ApplicationPolicies, ok); err != nil {
			return err
		}
	}

	if v.KeyUsage != nil {
		ok := object.Key("KeyUsage")
		if err := awsRestjson1_serializeDocumentKeyUsage(v.KeyUsage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExtensionsV3(v *types.ExtensionsV3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationPolicies != nil {
		ok := object.Key("ApplicationPolicies")
		if err := awsRestjson1_serializeDocumentApplicationPolicies(v.ApplicationPolicies, ok); err != nil {
			return err
		}
	}

	if v.KeyUsage != nil {
		ok := object.Key("KeyUsage")
		if err := awsRestjson1_serializeDocumentKeyUsage(v.KeyUsage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExtensionsV4(v *types.ExtensionsV4, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationPolicies != nil {
		ok := object.Key("ApplicationPolicies")
		if err := awsRestjson1_serializeDocumentApplicationPolicies(v.ApplicationPolicies, ok); err != nil {
			return err
		}
	}

	if v.KeyUsage != nil {
		ok := object.Key("KeyUsage")
		if err := awsRestjson1_serializeDocumentKeyUsage(v.KeyUsage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeneralFlagsV2(v *types.GeneralFlagsV2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoEnrollment != nil {
		ok := object.Key("AutoEnrollment")
		ok.Boolean(*v.AutoEnrollment)
	}

	if v.MachineType != nil {
		ok := object.Key("MachineType")
		ok.Boolean(*v.MachineType)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeneralFlagsV3(v *types.GeneralFlagsV3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoEnrollment != nil {
		ok := object.Key("AutoEnrollment")
		ok.Boolean(*v.AutoEnrollment)
	}

	if v.MachineType != nil {
		ok := object.Key("MachineType")
		ok.Boolean(*v.MachineType)
	}

	return nil
}

func awsRestjson1_serializeDocumentGeneralFlagsV4(v *types.GeneralFlagsV4, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoEnrollment != nil {
		ok := object.Key("AutoEnrollment")
		ok.Boolean(*v.AutoEnrollment)
	}

	if v.MachineType != nil {
		ok := object.Key("MachineType")
		ok.Boolean(*v.MachineType)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyUsage(v *types.KeyUsage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Critical != nil {
		ok := object.Key("Critical")
		ok.Boolean(*v.Critical)
	}

	if v.UsageFlags != nil {
		ok := object.Key("UsageFlags")
		if err := awsRestjson1_serializeDocumentKeyUsageFlags(v.UsageFlags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyUsageFlags(v *types.KeyUsageFlags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataEncipherment != nil {
		ok := object.Key("DataEncipherment")
		ok.Boolean(*v.DataEncipherment)
	}

	if v.DigitalSignature != nil {
		ok := object.Key("DigitalSignature")
		ok.Boolean(*v.DigitalSignature)
	}

	if v.KeyAgreement != nil {
		ok := object.Key("KeyAgreement")
		ok.Boolean(*v.KeyAgreement)
	}

	if v.KeyEncipherment != nil {
		ok := object.Key("KeyEncipherment")
		ok.Boolean(*v.KeyEncipherment)
	}

	if v.NonRepudiation != nil {
		ok := object.Key("NonRepudiation")
		ok.Boolean(*v.NonRepudiation)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyUsageProperty(v types.KeyUsageProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.KeyUsagePropertyMemberPropertyFlags:
		av := object.Key("PropertyFlags")
		if err := awsRestjson1_serializeDocumentKeyUsagePropertyFlags(&uv.Value, av); err != nil {
			return err
		}

	case *types.KeyUsagePropertyMemberPropertyType:
		av := object.Key("PropertyType")
		av.String(string(uv.Value))

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentKeyUsagePropertyFlags(v *types.KeyUsagePropertyFlags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Decrypt != nil {
		ok := object.Key("Decrypt")
		ok.Boolean(*v.Decrypt)
	}

	if v.KeyAgreement != nil {
		ok := object.Key("KeyAgreement")
		ok.Boolean(*v.KeyAgreement)
	}

	if v.Sign != nil {
		ok := object.Key("Sign")
		ok.Boolean(*v.Sign)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrivateKeyAttributesV2(v *types.PrivateKeyAttributesV2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CryptoProviders != nil {
		ok := object.Key("CryptoProviders")
		if err := awsRestjson1_serializeDocumentCryptoProvidersList(v.CryptoProviders, ok); err != nil {
			return err
		}
	}

	if len(v.KeySpec) > 0 {
		ok := object.Key("KeySpec")
		ok.String(string(v.KeySpec))
	}

	if v.MinimalKeyLength != nil {
		ok := object.Key("MinimalKeyLength")
		ok.Integer(*v.MinimalKeyLength)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrivateKeyAttributesV3(v *types.PrivateKeyAttributesV3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("Algorithm")
		ok.String(string(v.Algorithm))
	}

	if v.CryptoProviders != nil {
		ok := object.Key("CryptoProviders")
		if err := awsRestjson1_serializeDocumentCryptoProvidersList(v.CryptoProviders, ok); err != nil {
			return err
		}
	}

	if len(v.KeySpec) > 0 {
		ok := object.Key("KeySpec")
		ok.String(string(v.KeySpec))
	}

	if v.KeyUsageProperty != nil {
		ok := object.Key("KeyUsageProperty")
		if err := awsRestjson1_serializeDocumentKeyUsageProperty(v.KeyUsageProperty, ok); err != nil {
			return err
		}
	}

	if v.MinimalKeyLength != nil {
		ok := object.Key("MinimalKeyLength")
		ok.Integer(*v.MinimalKeyLength)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrivateKeyAttributesV4(v *types.PrivateKeyAttributesV4, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("Algorithm")
		ok.String(string(v.Algorithm))
	}

	if v.CryptoProviders != nil {
		ok := object.Key("CryptoProviders")
		if err := awsRestjson1_serializeDocumentCryptoProvidersList(v.CryptoProviders, ok); err != nil {
			return err
		}
	}

	if len(v.KeySpec) > 0 {
		ok := object.Key("KeySpec")
		ok.String(string(v.KeySpec))
	}

	if v.KeyUsageProperty != nil {
		ok := object.Key("KeyUsageProperty")
		if err := awsRestjson1_serializeDocumentKeyUsageProperty(v.KeyUsageProperty, ok); err != nil {
			return err
		}
	}

	if v.MinimalKeyLength != nil {
		ok := object.Key("MinimalKeyLength")
		ok.Integer(*v.MinimalKeyLength)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrivateKeyFlagsV2(v *types.PrivateKeyFlagsV2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ClientVersion) > 0 {
		ok := object.Key("ClientVersion")
		ok.String(string(v.ClientVersion))
	}

	if v.ExportableKey != nil {
		ok := object.Key("ExportableKey")
		ok.Boolean(*v.ExportableKey)
	}

	if v.StrongKeyProtectionRequired != nil {
		ok := object.Key("StrongKeyProtectionRequired")
		ok.Boolean(*v.StrongKeyProtectionRequired)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrivateKeyFlagsV3(v *types.PrivateKeyFlagsV3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ClientVersion) > 0 {
		ok := object.Key("ClientVersion")
		ok.String(string(v.ClientVersion))
	}

	if v.ExportableKey != nil {
		ok := object.Key("ExportableKey")
		ok.Boolean(*v.ExportableKey)
	}

	if v.RequireAlternateSignatureAlgorithm != nil {
		ok := object.Key("RequireAlternateSignatureAlgorithm")
		ok.Boolean(*v.RequireAlternateSignatureAlgorithm)
	}

	if v.StrongKeyProtectionRequired != nil {
		ok := object.Key("StrongKeyProtectionRequired")
		ok.Boolean(*v.StrongKeyProtectionRequired)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrivateKeyFlagsV4(v *types.PrivateKeyFlagsV4, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ClientVersion) > 0 {
		ok := object.Key("ClientVersion")
		ok.String(string(v.ClientVersion))
	}

	if v.ExportableKey != nil {
		ok := object.Key("ExportableKey")
		ok.Boolean(*v.ExportableKey)
	}

	if v.RequireAlternateSignatureAlgorithm != nil {
		ok := object.Key("RequireAlternateSignatureAlgorithm")
		ok.Boolean(*v.RequireAlternateSignatureAlgorithm)
	}

	if v.RequireSameKeyRenewal != nil {
		ok := object.Key("RequireSameKeyRenewal")
		ok.Boolean(*v.RequireSameKeyRenewal)
	}

	if v.StrongKeyProtectionRequired != nil {
		ok := object.Key("StrongKeyProtectionRequired")
		ok.Boolean(*v.StrongKeyProtectionRequired)
	}

	if v.UseLegacyProvider != nil {
		ok := object.Key("UseLegacyProvider")
		ok.Boolean(*v.UseLegacyProvider)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubjectNameFlagsV2(v *types.SubjectNameFlagsV2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RequireCommonName != nil {
		ok := object.Key("RequireCommonName")
		ok.Boolean(*v.RequireCommonName)
	}

	if v.RequireDirectoryPath != nil {
		ok := object.Key("RequireDirectoryPath")
		ok.Boolean(*v.RequireDirectoryPath)
	}

	if v.RequireDnsAsCn != nil {
		ok := object.Key("RequireDnsAsCn")
		ok.Boolean(*v.RequireDnsAsCn)
	}

	if v.RequireEmail != nil {
		ok := object.Key("RequireEmail")
		ok.Boolean(*v.RequireEmail)
	}

	if v.SanRequireDirectoryGuid != nil {
		ok := object.Key("SanRequireDirectoryGuid")
		ok.Boolean(*v.SanRequireDirectoryGuid)
	}

	if v.SanRequireDns != nil {
		ok := object.Key("SanRequireDns")
		ok.Boolean(*v.SanRequireDns)
	}

	if v.SanRequireDomainDns != nil {
		ok := object.Key("SanRequireDomainDns")
		ok.Boolean(*v.SanRequireDomainDns)
	}

	if v.SanRequireEmail != nil {
		ok := object.Key("SanRequireEmail")
		ok.Boolean(*v.SanRequireEmail)
	}

	if v.SanRequireSpn != nil {
		ok := object.Key("SanRequireSpn")
		ok.Boolean(*v.SanRequireSpn)
	}

	if v.SanRequireUpn != nil {
		ok := object.Key("SanRequireUpn")
		ok.Boolean(*v.SanRequireUpn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSubjectNameFlagsV3(v *types.SubjectNameFlagsV3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RequireCommonName != nil {
		ok := object.Key("RequireCommonName")
		ok.Boolean(*v.RequireCommonName)
	}

	if v.RequireDirectoryPath != nil {
		ok := object.Key("RequireDirectoryPath")
		ok.Boolean(*v.RequireDirectoryPath)
	}

	if v.RequireDnsAsCn != nil {
		ok := object.Key("RequireDnsAsCn")
		ok.Boolean(*v.RequireDnsAsCn)
	}

	if v.RequireEmail != nil {
		ok := object.Key("RequireEmail")
		ok.Boolean(*v.RequireEmail)
	}

	if v.SanRequireDirectoryGuid != nil {
		ok := object.Key("SanRequireDirectoryGuid")
		ok.Boolean(*v.SanRequireDirectoryGuid)
	}

	if v.SanRequireDns != nil {
		ok := object.Key("SanRequireDns")
		ok.Boolean(*v.SanRequireDns)
	}

	if v.SanRequireDomainDns != nil {
		ok := object.Key("SanRequireDomainDns")
		ok.Boolean(*v.SanRequireDomainDns)
	}

	if v.SanRequireEmail != nil {
		ok := object.Key("SanRequireEmail")
		ok.Boolean(*v.SanRequireEmail)
	}

	if v.SanRequireSpn != nil {
		ok := object.Key("SanRequireSpn")
		ok.Boolean(*v.SanRequireSpn)
	}

	if v.SanRequireUpn != nil {
		ok := object.Key("SanRequireUpn")
		ok.Boolean(*v.SanRequireUpn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSubjectNameFlagsV4(v *types.SubjectNameFlagsV4, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RequireCommonName != nil {
		ok := object.Key("RequireCommonName")
		ok.Boolean(*v.RequireCommonName)
	}

	if v.RequireDirectoryPath != nil {
		ok := object.Key("RequireDirectoryPath")
		ok.Boolean(*v.RequireDirectoryPath)
	}

	if v.RequireDnsAsCn != nil {
		ok := object.Key("RequireDnsAsCn")
		ok.Boolean(*v.RequireDnsAsCn)
	}

	if v.RequireEmail != nil {
		ok := object.Key("RequireEmail")
		ok.Boolean(*v.RequireEmail)
	}

	if v.SanRequireDirectoryGuid != nil {
		ok := object.Key("SanRequireDirectoryGuid")
		ok.Boolean(*v.SanRequireDirectoryGuid)
	}

	if v.SanRequireDns != nil {
		ok := object.Key("SanRequireDns")
		ok.Boolean(*v.SanRequireDns)
	}

	if v.SanRequireDomainDns != nil {
		ok := object.Key("SanRequireDomainDns")
		ok.Boolean(*v.SanRequireDomainDns)
	}

	if v.SanRequireEmail != nil {
		ok := object.Key("SanRequireEmail")
		ok.Boolean(*v.SanRequireEmail)
	}

	if v.SanRequireSpn != nil {
		ok := object.Key("SanRequireSpn")
		ok.Boolean(*v.SanRequireSpn)
	}

	if v.SanRequireUpn != nil {
		ok := object.Key("SanRequireUpn")
		ok.Boolean(*v.SanRequireUpn)
	}

	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTemplateDefinition(v types.TemplateDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.TemplateDefinitionMemberTemplateV2:
		av := object.Key("TemplateV2")
		if err := awsRestjson1_serializeDocumentTemplateV2(&uv.Value, av); err != nil {
			return err
		}

	case *types.TemplateDefinitionMemberTemplateV3:
		av := object.Key("TemplateV3")
		if err := awsRestjson1_serializeDocumentTemplateV3(&uv.Value, av); err != nil {
			return err
		}

	case *types.TemplateDefinitionMemberTemplateV4:
		av := object.Key("TemplateV4")
		if err := awsRestjson1_serializeDocumentTemplateV4(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentTemplateNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTemplateV2(v *types.TemplateV2, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateValidity != nil {
		ok := object.Key("CertificateValidity")
		if err := awsRestjson1_serializeDocumentCertificateValidity(v.CertificateValidity, ok); err != nil {
			return err
		}
	}

	if v.EnrollmentFlags != nil {
		ok := object.Key("EnrollmentFlags")
		if err := awsRestjson1_serializeDocumentEnrollmentFlagsV2(v.EnrollmentFlags, ok); err != nil {
			return err
		}
	}

	if v.Extensions != nil {
		ok := object.Key("Extensions")
		if err := awsRestjson1_serializeDocumentExtensionsV2(v.Extensions, ok); err != nil {
			return err
		}
	}

	if v.GeneralFlags != nil {
		ok := object.Key("GeneralFlags")
		if err := awsRestjson1_serializeDocumentGeneralFlagsV2(v.GeneralFlags, ok); err != nil {
			return err
		}
	}

	if v.PrivateKeyAttributes != nil {
		ok := object.Key("PrivateKeyAttributes")
		if err := awsRestjson1_serializeDocumentPrivateKeyAttributesV2(v.PrivateKeyAttributes, ok); err != nil {
			return err
		}
	}

	if v.PrivateKeyFlags != nil {
		ok := object.Key("PrivateKeyFlags")
		if err := awsRestjson1_serializeDocumentPrivateKeyFlagsV2(v.PrivateKeyFlags, ok); err != nil {
			return err
		}
	}

	if v.SubjectNameFlags != nil {
		ok := object.Key("SubjectNameFlags")
		if err := awsRestjson1_serializeDocumentSubjectNameFlagsV2(v.SubjectNameFlags, ok); err != nil {
			return err
		}
	}

	if v.SupersededTemplates != nil {
		ok := object.Key("SupersededTemplates")
		if err := awsRestjson1_serializeDocumentTemplateNameList(v.SupersededTemplates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTemplateV3(v *types.TemplateV3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateValidity != nil {
		ok := object.Key("CertificateValidity")
		if err := awsRestjson1_serializeDocumentCertificateValidity(v.CertificateValidity, ok); err != nil {
			return err
		}
	}

	if v.EnrollmentFlags != nil {
		ok := object.Key("EnrollmentFlags")
		if err := awsRestjson1_serializeDocumentEnrollmentFlagsV3(v.EnrollmentFlags, ok); err != nil {
			return err
		}
	}

	if v.Extensions != nil {
		ok := object.Key("Extensions")
		if err := awsRestjson1_serializeDocumentExtensionsV3(v.Extensions, ok); err != nil {
			return err
		}
	}

	if v.GeneralFlags != nil {
		ok := object.Key("GeneralFlags")
		if err := awsRestjson1_serializeDocumentGeneralFlagsV3(v.GeneralFlags, ok); err != nil {
			return err
		}
	}

	if len(v.HashAlgorithm) > 0 {
		ok := object.Key("HashAlgorithm")
		ok.String(string(v.HashAlgorithm))
	}

	if v.PrivateKeyAttributes != nil {
		ok := object.Key("PrivateKeyAttributes")
		if err := awsRestjson1_serializeDocumentPrivateKeyAttributesV3(v.PrivateKeyAttributes, ok); err != nil {
			return err
		}
	}

	if v.PrivateKeyFlags != nil {
		ok := object.Key("PrivateKeyFlags")
		if err := awsRestjson1_serializeDocumentPrivateKeyFlagsV3(v.PrivateKeyFlags, ok); err != nil {
			return err
		}
	}

	if v.SubjectNameFlags != nil {
		ok := object.Key("SubjectNameFlags")
		if err := awsRestjson1_serializeDocumentSubjectNameFlagsV3(v.SubjectNameFlags, ok); err != nil {
			return err
		}
	}

	if v.SupersededTemplates != nil {
		ok := object.Key("SupersededTemplates")
		if err := awsRestjson1_serializeDocumentTemplateNameList(v.SupersededTemplates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTemplateV4(v *types.TemplateV4, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateValidity != nil {
		ok := object.Key("CertificateValidity")
		if err := awsRestjson1_serializeDocumentCertificateValidity(v.CertificateValidity, ok); err != nil {
			return err
		}
	}

	if v.EnrollmentFlags != nil {
		ok := object.Key("EnrollmentFlags")
		if err := awsRestjson1_serializeDocumentEnrollmentFlagsV4(v.EnrollmentFlags, ok); err != nil {
			return err
		}
	}

	if v.Extensions != nil {
		ok := object.Key("Extensions")
		if err := awsRestjson1_serializeDocumentExtensionsV4(v.Extensions, ok); err != nil {
			return err
		}
	}

	if v.GeneralFlags != nil {
		ok := object.Key("GeneralFlags")
		if err := awsRestjson1_serializeDocumentGeneralFlagsV4(v.GeneralFlags, ok); err != nil {
			return err
		}
	}

	if len(v.HashAlgorithm) > 0 {
		ok := object.Key("HashAlgorithm")
		ok.String(string(v.HashAlgorithm))
	}

	if v.PrivateKeyAttributes != nil {
		ok := object.Key("PrivateKeyAttributes")
		if err := awsRestjson1_serializeDocumentPrivateKeyAttributesV4(v.PrivateKeyAttributes, ok); err != nil {
			return err
		}
	}

	if v.PrivateKeyFlags != nil {
		ok := object.Key("PrivateKeyFlags")
		if err := awsRestjson1_serializeDocumentPrivateKeyFlagsV4(v.PrivateKeyFlags, ok); err != nil {
			return err
		}
	}

	if v.SubjectNameFlags != nil {
		ok := object.Key("SubjectNameFlags")
		if err := awsRestjson1_serializeDocumentSubjectNameFlagsV4(v.SubjectNameFlags, ok); err != nil {
			return err
		}
	}

	if v.SupersededTemplates != nil {
		ok := object.Key("SupersededTemplates")
		if err := awsRestjson1_serializeDocumentTemplateNameList(v.SupersededTemplates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentValidityPeriod(v *types.ValidityPeriod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Period != nil {
		ok := object.Key("Period")
		ok.Long(*v.Period)
	}

	if len(v.PeriodType) > 0 {
		ok := object.Key("PeriodType")
		ok.String(string(v.PeriodType))
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcInformation(v *types.VpcInformation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIdList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	return nil
}
