// Code generated by smithy-go-codegen DO NOT EDIT.

package pcs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pcs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a managed set of compute nodes. You associate a compute node group with
// a cluster through 1 or more Amazon Web Services PCS queues or as part of the
// login fleet. A compute node group includes the definition of the compute
// properties and lifecycle management. Amazon Web Services PCS uses the
// information you provide to this API action to launch compute nodes in your
// account. You can only specify subnets in the same Amazon VPC as your cluster.
// You receive billing charges for the compute nodes that Amazon Web Services PCS
// launches in your account. You must already have a launch template before you
// call this API. For more information, see [Launch an instance from a launch template]in the Amazon Elastic Compute Cloud
// User Guide for Linux Instances.
//
// [Launch an instance from a launch template]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
func (c *Client) CreateComputeNodeGroup(ctx context.Context, params *CreateComputeNodeGroupInput, optFns ...func(*Options)) (*CreateComputeNodeGroupOutput, error) {
	if params == nil {
		params = &CreateComputeNodeGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateComputeNodeGroup", params, optFns, c.addOperationCreateComputeNodeGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateComputeNodeGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateComputeNodeGroupInput struct {

	// The name or ID of the cluster to create a compute node group in.
	//
	// This member is required.
	ClusterIdentifier *string

	// A name to identify the cluster. Example: MyCluster
	//
	// This member is required.
	ComputeNodeGroupName *string

	// An Amazon EC2 launch template Amazon Web Services PCS uses to launch compute
	// nodes.
	//
	// This member is required.
	CustomLaunchTemplate *types.CustomLaunchTemplate

	// The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM
	// role when launching EC2 instances. The role contained in your instance profile
	// must have the pcs:RegisterComputeNodeGroupInstance permission. The resource
	// identifier of the ARN must start with AWSPCS or it must have /aws-pcs/ in its
	// path.
	//
	// Examples
	//
	//   - arn:aws:iam::111122223333:instance-profile/AWSPCS-example-role-1
	//
	//   - arn:aws:iam::111122223333:instance-profile/aws-pcs/example-role-2
	//
	// This member is required.
	IamInstanceProfileArn *string

	// A list of EC2 instance configurations that Amazon Web Services PCS can
	// provision in the compute node group.
	//
	// This member is required.
	InstanceConfigs []types.InstanceConfig

	// Specifies the boundaries of the compute node group auto scaling.
	//
	// This member is required.
	ScalingConfiguration *types.ScalingConfigurationRequest

	// The list of subnet IDs where the compute node group launches instances. Subnets
	// must be in the same VPC as the cluster.
	//
	// This member is required.
	SubnetIds []string

	//  The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to
	// launch compute nodes (Amazon EC2 instances). If you don't provide this value,
	// Amazon Web Services PCS uses the AMI ID specified in the custom launch template.
	AmiId *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully, the
	// subsequent retries with the same client token return the result from the
	// original successful request and they have no additional effect. If you don't
	// specify a client token, the CLI and SDK automatically generate 1 for you.
	ClientToken *string

	// Specifies how EC2 instances are purchased on your behalf. Amazon Web Services
	// PCS supports On-Demand and Spot instances. For more information, see [Instance purchasing options]in the
	// Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it
	// defaults to On-Demand.
	//
	// [Instance purchasing options]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html
	PurchaseOption types.PurchaseOption

	// Additional options related to the Slurm scheduler.
	SlurmConfiguration *types.ComputeNodeGroupSlurmConfigurationRequest

	// Additional configuration when you specify SPOT as the purchaseOption for the
	// CreateComputeNodeGroup API action.
	SpotOptions *types.SpotOptions

	// 1 or more tags added to the resource. Each tag consists of a tag key and tag
	// value. The tag value is optional and can be an empty string.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateComputeNodeGroupOutput struct {

	// A compute node group associated with a cluster.
	ComputeNodeGroup *types.ComputeNodeGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateComputeNodeGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateComputeNodeGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateComputeNodeGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateComputeNodeGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateComputeNodeGroupMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateComputeNodeGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateComputeNodeGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateComputeNodeGroup struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateComputeNodeGroup) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateComputeNodeGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateComputeNodeGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateComputeNodeGroupInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateComputeNodeGroupMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateComputeNodeGroup{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateComputeNodeGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateComputeNodeGroup",
	}
}
