// Code generated by smithy-go-codegen DO NOT EDIT.

package pcs

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pcs/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateCluster struct {
}

func (*validateOpCreateCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateComputeNodeGroup struct {
}

func (*validateOpCreateComputeNodeGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateComputeNodeGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateComputeNodeGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateComputeNodeGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateQueue struct {
}

func (*validateOpCreateQueue) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateQueue) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateQueueInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateQueueInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteCluster struct {
}

func (*validateOpDeleteCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteComputeNodeGroup struct {
}

func (*validateOpDeleteComputeNodeGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteComputeNodeGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteComputeNodeGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteComputeNodeGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteQueue struct {
}

func (*validateOpDeleteQueue) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteQueue) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteQueueInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteQueueInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetCluster struct {
}

func (*validateOpGetCluster) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetClusterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetComputeNodeGroup struct {
}

func (*validateOpGetComputeNodeGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetComputeNodeGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetComputeNodeGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetComputeNodeGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetQueue struct {
}

func (*validateOpGetQueue) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetQueue) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetQueueInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetQueueInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListComputeNodeGroups struct {
}

func (*validateOpListComputeNodeGroups) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListComputeNodeGroups) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListComputeNodeGroupsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListComputeNodeGroupsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListQueues struct {
}

func (*validateOpListQueues) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListQueues) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListQueuesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListQueuesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRegisterComputeNodeGroupInstance struct {
}

func (*validateOpRegisterComputeNodeGroupInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRegisterComputeNodeGroupInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RegisterComputeNodeGroupInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRegisterComputeNodeGroupInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateComputeNodeGroup struct {
}

func (*validateOpUpdateComputeNodeGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateComputeNodeGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateComputeNodeGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateComputeNodeGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateQueue struct {
}

func (*validateOpUpdateQueue) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateQueue) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateQueueInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateQueueInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateCluster{}, middleware.After)
}

func addOpCreateComputeNodeGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateComputeNodeGroup{}, middleware.After)
}

func addOpCreateQueueValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateQueue{}, middleware.After)
}

func addOpDeleteClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteCluster{}, middleware.After)
}

func addOpDeleteComputeNodeGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteComputeNodeGroup{}, middleware.After)
}

func addOpDeleteQueueValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteQueue{}, middleware.After)
}

func addOpGetClusterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetCluster{}, middleware.After)
}

func addOpGetComputeNodeGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetComputeNodeGroup{}, middleware.After)
}

func addOpGetQueueValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetQueue{}, middleware.After)
}

func addOpListComputeNodeGroupsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListComputeNodeGroups{}, middleware.After)
}

func addOpListQueuesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListQueues{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRegisterComputeNodeGroupInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRegisterComputeNodeGroupInstance{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateComputeNodeGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateComputeNodeGroup{}, middleware.After)
}

func addOpUpdateQueueValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateQueue{}, middleware.After)
}

func validateClusterSlurmConfigurationRequest(v *types.ClusterSlurmConfigurationRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClusterSlurmConfigurationRequest"}
	if v.SlurmCustomSettings != nil {
		if err := validateSlurmCustomSettings(v.SlurmCustomSettings); err != nil {
			invalidParams.AddNested("SlurmCustomSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateComputeNodeGroupSlurmConfigurationRequest(v *types.ComputeNodeGroupSlurmConfigurationRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ComputeNodeGroupSlurmConfigurationRequest"}
	if v.SlurmCustomSettings != nil {
		if err := validateSlurmCustomSettings(v.SlurmCustomSettings); err != nil {
			invalidParams.AddNested("SlurmCustomSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCustomLaunchTemplate(v *types.CustomLaunchTemplate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CustomLaunchTemplate"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScalingConfigurationRequest(v *types.ScalingConfigurationRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScalingConfigurationRequest"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchedulerRequest(v *types.SchedulerRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchedulerRequest"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSlurmCustomSetting(v *types.SlurmCustomSetting) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SlurmCustomSetting"}
	if v.ParameterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParameterName"))
	}
	if v.ParameterValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParameterValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSlurmCustomSettings(v []types.SlurmCustomSetting) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SlurmCustomSettings"}
	for i := range v {
		if err := validateSlurmCustomSetting(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateComputeNodeGroupSlurmConfigurationRequest(v *types.UpdateComputeNodeGroupSlurmConfigurationRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateComputeNodeGroupSlurmConfigurationRequest"}
	if v.SlurmCustomSettings != nil {
		if err := validateSlurmCustomSettings(v.SlurmCustomSettings); err != nil {
			invalidParams.AddNested("SlurmCustomSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateClusterInput(v *CreateClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateClusterInput"}
	if v.ClusterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterName"))
	}
	if v.Scheduler == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Scheduler"))
	} else if v.Scheduler != nil {
		if err := validateSchedulerRequest(v.Scheduler); err != nil {
			invalidParams.AddNested("Scheduler", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Size) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Size"))
	}
	if v.Networking == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Networking"))
	}
	if v.SlurmConfiguration != nil {
		if err := validateClusterSlurmConfigurationRequest(v.SlurmConfiguration); err != nil {
			invalidParams.AddNested("SlurmConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateComputeNodeGroupInput(v *CreateComputeNodeGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateComputeNodeGroupInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.ComputeNodeGroupName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeNodeGroupName"))
	}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if v.CustomLaunchTemplate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CustomLaunchTemplate"))
	} else if v.CustomLaunchTemplate != nil {
		if err := validateCustomLaunchTemplate(v.CustomLaunchTemplate); err != nil {
			invalidParams.AddNested("CustomLaunchTemplate", err.(smithy.InvalidParamsError))
		}
	}
	if v.IamInstanceProfileArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IamInstanceProfileArn"))
	}
	if v.ScalingConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScalingConfiguration"))
	} else if v.ScalingConfiguration != nil {
		if err := validateScalingConfigurationRequest(v.ScalingConfiguration); err != nil {
			invalidParams.AddNested("ScalingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.InstanceConfigs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceConfigs"))
	}
	if v.SlurmConfiguration != nil {
		if err := validateComputeNodeGroupSlurmConfigurationRequest(v.SlurmConfiguration); err != nil {
			invalidParams.AddNested("SlurmConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateQueueInput(v *CreateQueueInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateQueueInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.QueueName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueueName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteClusterInput(v *DeleteClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteClusterInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteComputeNodeGroupInput(v *DeleteComputeNodeGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteComputeNodeGroupInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.ComputeNodeGroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeNodeGroupIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteQueueInput(v *DeleteQueueInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteQueueInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.QueueIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueueIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetClusterInput(v *GetClusterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetClusterInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetComputeNodeGroupInput(v *GetComputeNodeGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetComputeNodeGroupInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.ComputeNodeGroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeNodeGroupIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetQueueInput(v *GetQueueInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetQueueInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.QueueIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueueIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListComputeNodeGroupsInput(v *ListComputeNodeGroupsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListComputeNodeGroupsInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListQueuesInput(v *ListQueuesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListQueuesInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRegisterComputeNodeGroupInstanceInput(v *RegisterComputeNodeGroupInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegisterComputeNodeGroupInstanceInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.BootstrapId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BootstrapId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateComputeNodeGroupInput(v *UpdateComputeNodeGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateComputeNodeGroupInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.ComputeNodeGroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ComputeNodeGroupIdentifier"))
	}
	if v.CustomLaunchTemplate != nil {
		if err := validateCustomLaunchTemplate(v.CustomLaunchTemplate); err != nil {
			invalidParams.AddNested("CustomLaunchTemplate", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScalingConfiguration != nil {
		if err := validateScalingConfigurationRequest(v.ScalingConfiguration); err != nil {
			invalidParams.AddNested("ScalingConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.SlurmConfiguration != nil {
		if err := validateUpdateComputeNodeGroupSlurmConfigurationRequest(v.SlurmConfiguration); err != nil {
			invalidParams.AddNested("SlurmConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateQueueInput(v *UpdateQueueInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateQueueInput"}
	if v.ClusterIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterIdentifier"))
	}
	if v.QueueIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueueIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
