// Code generated by smithy-go-codegen DO NOT EDIT.

package personalize

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/personalize/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an empty dataset group. A dataset group is a container for Amazon
// Personalize resources. A dataset group can contain at most three datasets, one
// for each type of dataset:
//
//   - Item interactions
//
//   - Items
//
//   - Users
//
//   - Actions
//
//   - Action interactions
//
// A dataset group can be a Domain dataset group, where you specify a domain and
// use pre-configured resources like recommenders, or a Custom dataset group, where
// you use custom resources, such as a solution with a solution version, that you
// deploy with a campaign. If you start with a Domain dataset group, you can still
// add custom resources such as solutions and solution versions trained with
// recipes for custom use cases and deployed with campaigns.
//
// A dataset group can be in one of the following states:
//
//   - CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//   - DELETE PENDING
//
// To get the status of the dataset group, call [DescribeDatasetGroup]. If the status shows as CREATE
// FAILED, the response includes a failureReason key, which describes why the
// creation failed.
//
// You must wait until the status of the dataset group is ACTIVE before adding a
// dataset to the group.
//
// You can specify an Key Management Service (KMS) key to encrypt the datasets in
// the group. If you specify a KMS key, you must also include an Identity and
// Access Management (IAM) role that has permission to access the key.
//
// # APIs that require a dataset group ARN in the request
//
// [CreateDataset]
//
// [CreateEventTracker]
//
// [CreateSolution]
//
// # Related APIs
//
// [ListDatasetGroups]
//
// [DescribeDatasetGroup]
//
// [DeleteDatasetGroup]
//
// [CreateDataset]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html
// [ListDatasetGroups]: https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html
// [CreateSolution]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html
// [DescribeDatasetGroup]: https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html
// [CreateEventTracker]: https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html
// [DeleteDatasetGroup]: https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html
func (c *Client) CreateDatasetGroup(ctx context.Context, params *CreateDatasetGroupInput, optFns ...func(*Options)) (*CreateDatasetGroupOutput, error) {
	if params == nil {
		params = &CreateDatasetGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDatasetGroup", params, optFns, c.addOperationCreateDatasetGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDatasetGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDatasetGroupInput struct {

	// The name for the new dataset group.
	//
	// This member is required.
	Name *string

	// The domain of the dataset group. Specify a domain to create a Domain dataset
	// group. The domain you specify determines the default schemas for datasets and
	// the use cases available for recommenders. If you don't specify a domain, you
	// create a Custom dataset group with solution versions that you deploy with a
	// campaign.
	Domain types.Domain

	// The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to
	// encrypt the datasets.
	KmsKeyArn *string

	// The ARN of the Identity and Access Management (IAM) role that has permissions
	// to access the Key Management Service (KMS) key. Supplying an IAM role is only
	// valid when also specifying a KMS key.
	RoleArn *string

	// A list of [tags] to apply to the dataset group.
	//
	// [tags]: https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateDatasetGroupOutput struct {

	// The Amazon Resource Name (ARN) of the new dataset group.
	DatasetGroupArn *string

	// The domain for the new Domain dataset group.
	Domain types.Domain

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDatasetGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDatasetGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDatasetGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDatasetGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDatasetGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDatasetGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDatasetGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDatasetGroup",
	}
}
