// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified opted out destination numbers or all opted out
// destination numbers in an opt-out list.
//
// If you specify opted out numbers, the output includes information for only the
// specified opted out numbers. If you specify filters, the output includes
// information for only those opted out numbers that meet the filter criteria. If
// you don't specify opted out numbers or filters, the output includes information
// for all opted out destination numbers in your opt-out list.
//
// If you specify an opted out number that isn't valid, an exception is returned.
func (c *Client) DescribeOptedOutNumbers(ctx context.Context, params *DescribeOptedOutNumbersInput, optFns ...func(*Options)) (*DescribeOptedOutNumbersOutput, error) {
	if params == nil {
		params = &DescribeOptedOutNumbersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeOptedOutNumbers", params, optFns, c.addOperationDescribeOptedOutNumbersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeOptedOutNumbersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeOptedOutNumbersInput struct {

	// The OptOutListName or OptOutListArn of the OptOutList. You can use DescribeOptOutLists to find the
	// values for OptOutListName and OptOutListArn.
	//
	// If you are using a shared AWS End User Messaging SMS and Voice resource then
	// you must use the full Amazon Resource Name(ARN).
	//
	// This member is required.
	OptOutListName *string

	// An array of OptedOutFilter objects to filter the results on.
	Filters []types.OptedOutFilter

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// An array of phone numbers to search for in the OptOutList.
	//
	// If you specify an opted out number that isn't valid, an exception is returned.
	OptedOutNumbers []string

	noSmithyDocumentSerde
}

type DescribeOptedOutNumbersOutput struct {

	// The token to be used for the next set of paginated results. If this field is
	// empty then there are no more results.
	NextToken *string

	// The Amazon Resource Name (ARN) of the OptOutList.
	OptOutListArn *string

	// The name of the OptOutList.
	OptOutListName *string

	// An array of OptedOutNumbersInformation objects that provide information about
	// the requested OptedOutNumbers.
	OptedOutNumbers []types.OptedOutNumberInformation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeOptedOutNumbersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeOptedOutNumbers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeOptedOutNumbers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeOptedOutNumbers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeOptedOutNumbersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeOptedOutNumbers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeOptedOutNumbersPaginatorOptions is the paginator options for
// DescribeOptedOutNumbers
type DescribeOptedOutNumbersPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeOptedOutNumbersPaginator is a paginator for DescribeOptedOutNumbers
type DescribeOptedOutNumbersPaginator struct {
	options   DescribeOptedOutNumbersPaginatorOptions
	client    DescribeOptedOutNumbersAPIClient
	params    *DescribeOptedOutNumbersInput
	nextToken *string
	firstPage bool
}

// NewDescribeOptedOutNumbersPaginator returns a new
// DescribeOptedOutNumbersPaginator
func NewDescribeOptedOutNumbersPaginator(client DescribeOptedOutNumbersAPIClient, params *DescribeOptedOutNumbersInput, optFns ...func(*DescribeOptedOutNumbersPaginatorOptions)) *DescribeOptedOutNumbersPaginator {
	if params == nil {
		params = &DescribeOptedOutNumbersInput{}
	}

	options := DescribeOptedOutNumbersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeOptedOutNumbersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeOptedOutNumbersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeOptedOutNumbers page.
func (p *DescribeOptedOutNumbersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeOptedOutNumbersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeOptedOutNumbers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeOptedOutNumbersAPIClient is a client that implements the
// DescribeOptedOutNumbers operation.
type DescribeOptedOutNumbersAPIClient interface {
	DescribeOptedOutNumbers(context.Context, *DescribeOptedOutNumbersInput, ...func(*Options)) (*DescribeOptedOutNumbersOutput, error)
}

var _ DescribeOptedOutNumbersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeOptedOutNumbers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeOptedOutNumbers",
	}
}
