// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the protect configurations that match any of filters. If a filter
// isn’t provided then all protect configurations are returned.
func (c *Client) DescribeProtectConfigurations(ctx context.Context, params *DescribeProtectConfigurationsInput, optFns ...func(*Options)) (*DescribeProtectConfigurationsOutput, error) {
	if params == nil {
		params = &DescribeProtectConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeProtectConfigurations", params, optFns, c.addOperationDescribeProtectConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeProtectConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeProtectConfigurationsInput struct {

	// An array of ProtectConfigurationFilter objects to filter the results.
	Filters []types.ProtectConfigurationFilter

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// An array of protect configuration identifiers to search for.
	ProtectConfigurationIds []string

	noSmithyDocumentSerde
}

type DescribeProtectConfigurationsOutput struct {

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// An array of ProtectConfigurationInformation objects that contain the details
	// for the request.
	ProtectConfigurations []types.ProtectConfigurationInformation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeProtectConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeProtectConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeProtectConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeProtectConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeProtectConfigurationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeProtectConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeProtectConfigurationsPaginatorOptions is the paginator options for
// DescribeProtectConfigurations
type DescribeProtectConfigurationsPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeProtectConfigurationsPaginator is a paginator for
// DescribeProtectConfigurations
type DescribeProtectConfigurationsPaginator struct {
	options   DescribeProtectConfigurationsPaginatorOptions
	client    DescribeProtectConfigurationsAPIClient
	params    *DescribeProtectConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeProtectConfigurationsPaginator returns a new
// DescribeProtectConfigurationsPaginator
func NewDescribeProtectConfigurationsPaginator(client DescribeProtectConfigurationsAPIClient, params *DescribeProtectConfigurationsInput, optFns ...func(*DescribeProtectConfigurationsPaginatorOptions)) *DescribeProtectConfigurationsPaginator {
	if params == nil {
		params = &DescribeProtectConfigurationsInput{}
	}

	options := DescribeProtectConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeProtectConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeProtectConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeProtectConfigurations page.
func (p *DescribeProtectConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeProtectConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeProtectConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeProtectConfigurationsAPIClient is a client that implements the
// DescribeProtectConfigurations operation.
type DescribeProtectConfigurationsAPIClient interface {
	DescribeProtectConfigurations(context.Context, *DescribeProtectConfigurationsInput, ...func(*Options)) (*DescribeProtectConfigurationsOutput, error)
}

var _ DescribeProtectConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeProtectConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeProtectConfigurations",
	}
}
