// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieve all of the protect configuration rule set number overrides that match
// the filters.
func (c *Client) ListProtectConfigurationRuleSetNumberOverrides(ctx context.Context, params *ListProtectConfigurationRuleSetNumberOverridesInput, optFns ...func(*Options)) (*ListProtectConfigurationRuleSetNumberOverridesOutput, error) {
	if params == nil {
		params = &ListProtectConfigurationRuleSetNumberOverridesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProtectConfigurationRuleSetNumberOverrides", params, optFns, c.addOperationListProtectConfigurationRuleSetNumberOverridesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListProtectConfigurationRuleSetNumberOverridesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListProtectConfigurationRuleSetNumberOverridesInput struct {

	// The unique identifier for the protect configuration.
	//
	// This member is required.
	ProtectConfigurationId *string

	// An array of ProtectConfigurationRuleSetNumberOverrideFilterItem objects to
	// filter the results.
	Filters []types.ProtectConfigurationRuleSetNumberOverrideFilterItem

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	noSmithyDocumentSerde
}

type ListProtectConfigurationRuleSetNumberOverridesOutput struct {

	// The Amazon Resource Name (ARN) of the protect configuration.
	//
	// This member is required.
	ProtectConfigurationArn *string

	// The unique identifier for the protect configuration.
	//
	// This member is required.
	ProtectConfigurationId *string

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// An array of RuleSetNumberOverrides objects.
	RuleSetNumberOverrides []types.ProtectConfigurationRuleSetNumberOverride

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListProtectConfigurationRuleSetNumberOverridesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListProtectConfigurationRuleSetNumberOverrides{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListProtectConfigurationRuleSetNumberOverrides{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListProtectConfigurationRuleSetNumberOverrides"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListProtectConfigurationRuleSetNumberOverridesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProtectConfigurationRuleSetNumberOverrides(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListProtectConfigurationRuleSetNumberOverridesPaginatorOptions is the paginator
// options for ListProtectConfigurationRuleSetNumberOverrides
type ListProtectConfigurationRuleSetNumberOverridesPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListProtectConfigurationRuleSetNumberOverridesPaginator is a paginator for
// ListProtectConfigurationRuleSetNumberOverrides
type ListProtectConfigurationRuleSetNumberOverridesPaginator struct {
	options   ListProtectConfigurationRuleSetNumberOverridesPaginatorOptions
	client    ListProtectConfigurationRuleSetNumberOverridesAPIClient
	params    *ListProtectConfigurationRuleSetNumberOverridesInput
	nextToken *string
	firstPage bool
}

// NewListProtectConfigurationRuleSetNumberOverridesPaginator returns a new
// ListProtectConfigurationRuleSetNumberOverridesPaginator
func NewListProtectConfigurationRuleSetNumberOverridesPaginator(client ListProtectConfigurationRuleSetNumberOverridesAPIClient, params *ListProtectConfigurationRuleSetNumberOverridesInput, optFns ...func(*ListProtectConfigurationRuleSetNumberOverridesPaginatorOptions)) *ListProtectConfigurationRuleSetNumberOverridesPaginator {
	if params == nil {
		params = &ListProtectConfigurationRuleSetNumberOverridesInput{}
	}

	options := ListProtectConfigurationRuleSetNumberOverridesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListProtectConfigurationRuleSetNumberOverridesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListProtectConfigurationRuleSetNumberOverridesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListProtectConfigurationRuleSetNumberOverrides page.
func (p *ListProtectConfigurationRuleSetNumberOverridesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListProtectConfigurationRuleSetNumberOverridesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListProtectConfigurationRuleSetNumberOverrides(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListProtectConfigurationRuleSetNumberOverridesAPIClient is a client that
// implements the ListProtectConfigurationRuleSetNumberOverrides operation.
type ListProtectConfigurationRuleSetNumberOverridesAPIClient interface {
	ListProtectConfigurationRuleSetNumberOverrides(context.Context, *ListProtectConfigurationRuleSetNumberOverridesInput, ...func(*Options)) (*ListProtectConfigurationRuleSetNumberOverridesOutput, error)
}

var _ ListProtectConfigurationRuleSetNumberOverridesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListProtectConfigurationRuleSetNumberOverrides(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListProtectConfigurationRuleSetNumberOverrides",
	}
}
