// Code generated by smithy-go-codegen DO NOT EDIT.

package qapps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qapps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a presigned URL for an S3 POST operation to upload a file. You can use
// this URL to set a default file for a FileUploadCard in a Q App definition or to
// provide a file for a single Q App run. The scope parameter determines how the
// file will be used, either at the app definition level or the app session level.
func (c *Client) CreatePresignedUrl(ctx context.Context, params *CreatePresignedUrlInput, optFns ...func(*Options)) (*CreatePresignedUrlOutput, error) {
	if params == nil {
		params = &CreatePresignedUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePresignedUrl", params, optFns, c.addOperationCreatePresignedUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePresignedUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePresignedUrlInput struct {

	// The unique identifier of the Q App the file is associated with.
	//
	// This member is required.
	AppId *string

	// The unique identifier of the card the file is associated with.
	//
	// This member is required.
	CardId *string

	// The Base64-encoded SHA-256 digest of the contents of the file to be uploaded.
	//
	// This member is required.
	FileContentsSha256 *string

	// The name of the file to be uploaded.
	//
	// This member is required.
	FileName *string

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// This member is required.
	InstanceId *string

	// Whether the file is associated with a Q App definition or a specific Q App
	// session.
	//
	// This member is required.
	Scope types.DocumentScope

	// The unique identifier of the Q App session the file is associated with, if
	// applicable.
	SessionId *string

	noSmithyDocumentSerde
}

type CreatePresignedUrlOutput struct {

	// The unique identifier assigned to the file to be uploaded.
	//
	// This member is required.
	FileId *string

	// The URL for a presigned S3 POST operation used to upload a file.
	//
	// This member is required.
	PresignedUrl *string

	// The date and time that the presigned URL will expire in ISO 8601 format.
	//
	// This member is required.
	PresignedUrlExpiration *time.Time

	// The form fields to include in the presigned S3 POST operation used to upload a
	// file.
	//
	// This member is required.
	PresignedUrlFields map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePresignedUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePresignedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePresignedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePresignedUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePresignedUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePresignedUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreatePresignedUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePresignedUrl",
	}
}
