// Code generated by smithy-go-codegen DO NOT EDIT.

package qapps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qapps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new Amazon Q App based on the provided definition. The Q App
// definition specifies the cards and flow of the Q App. This operation also
// calculates the dependencies between the cards by inspecting the references in
// the prompts.
func (c *Client) CreateQApp(ctx context.Context, params *CreateQAppInput, optFns ...func(*Options)) (*CreateQAppOutput, error) {
	if params == nil {
		params = &CreateQAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateQApp", params, optFns, c.addOperationCreateQAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateQAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateQAppInput struct {

	// The definition of the new Q App, specifying the cards and flow.
	//
	// This member is required.
	AppDefinition *types.AppDefinitionInput

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// This member is required.
	InstanceId *string

	// The title of the new Q App.
	//
	// This member is required.
	Title *string

	// The description of the new Q App.
	Description *string

	// Optional tags to associate with the new Q App.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateQAppOutput struct {

	// The Amazon Resource Name (ARN) of the new Q App.
	//
	// This member is required.
	AppArn *string

	// The unique identifier of the new Q App.
	//
	// This member is required.
	AppId *string

	// The version of the new Q App.
	//
	// This member is required.
	AppVersion *int32

	// The date and time the Q App was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user who created the Q App.
	//
	// This member is required.
	CreatedBy *string

	// The status of the new Q App, such as "Created".
	//
	// This member is required.
	Status types.AppStatus

	// The title of the new Q App.
	//
	// This member is required.
	Title *string

	// The date and time the Q App was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The user who last updated the Q App.
	//
	// This member is required.
	UpdatedBy *string

	// The description of the new Q App.
	Description *string

	// The initial prompt displayed when the Q App is started.
	InitialPrompt *string

	// The capabilities required to run the Q App, such as file upload or third-party
	// integrations.
	RequiredCapabilities []types.AppRequiredCapability

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateQAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateQApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateQApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateQApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateQAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateQApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateQApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateQApp",
	}
}
