// Code generated by smithy-go-codegen DO NOT EDIT.

package qapps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qapps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing Amazon Q App, allowing modifications to its title,
// description, and definition.
func (c *Client) UpdateQApp(ctx context.Context, params *UpdateQAppInput, optFns ...func(*Options)) (*UpdateQAppOutput, error) {
	if params == nil {
		params = &UpdateQAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateQApp", params, optFns, c.addOperationUpdateQAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateQAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateQAppInput struct {

	// The unique identifier of the Q App to update.
	//
	// This member is required.
	AppId *string

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// This member is required.
	InstanceId *string

	// The new definition specifying the cards and flow for the Q App.
	AppDefinition *types.AppDefinitionInput

	// The new description for the Q App.
	Description *string

	// The new title for the Q App.
	Title *string

	noSmithyDocumentSerde
}

type UpdateQAppOutput struct {

	// The Amazon Resource Name (ARN) of the updated Q App.
	//
	// This member is required.
	AppArn *string

	// The unique identifier of the updated Q App.
	//
	// This member is required.
	AppId *string

	// The new version of the updated Q App.
	//
	// This member is required.
	AppVersion *int32

	// The date and time the Q App was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user who originally created the Q App.
	//
	// This member is required.
	CreatedBy *string

	// The status of the updated Q App.
	//
	// This member is required.
	Status types.AppStatus

	// The new title of the updated Q App.
	//
	// This member is required.
	Title *string

	// The date and time the Q App was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The user who last updated the Q App.
	//
	// This member is required.
	UpdatedBy *string

	// The new description of the updated Q App.
	Description *string

	// The initial prompt for the updated Q App.
	InitialPrompt *string

	// The capabilities required for the updated Q App.
	RequiredCapabilities []types.AppRequiredCapability

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateQAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateQApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateQApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateQApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateQAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateQApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateQApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateQApp",
	}
}
