// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of attachments associated with an Amazon Q Business web experience
// or a list of attachements associated with a specific Amazon Q Business
// conversation.
func (c *Client) ListAttachments(ctx context.Context, params *ListAttachmentsInput, optFns ...func(*Options)) (*ListAttachmentsOutput, error) {
	if params == nil {
		params = &ListAttachmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAttachments", params, optFns, c.addOperationListAttachmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAttachmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAttachmentsInput struct {

	// The unique identifier for the Amazon Q Business application.
	//
	// This member is required.
	ApplicationId *string

	// The unique identifier of the Amazon Q Business web experience conversation.
	ConversationId *string

	// The maximum number of attachements to return.
	MaxResults *int32

	// If the number of attachments returned exceeds maxResults , Amazon Q Business
	// returns a next token as a pagination token to retrieve the next set of
	// attachments.
	NextToken *string

	// The unique identifier of the user involved in the Amazon Q Business web
	// experience conversation.
	UserId *string

	noSmithyDocumentSerde
}

type ListAttachmentsOutput struct {

	// An array of information on one or more attachments.
	Attachments []types.Attachment

	// If the response is truncated, Amazon Q Business returns this token, which you
	// can use in a later request to list the next set of attachments.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAttachmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAttachments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListAttachmentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAttachments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAttachmentsPaginatorOptions is the paginator options for ListAttachments
type ListAttachmentsPaginatorOptions struct {
	// The maximum number of attachements to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAttachmentsPaginator is a paginator for ListAttachments
type ListAttachmentsPaginator struct {
	options   ListAttachmentsPaginatorOptions
	client    ListAttachmentsAPIClient
	params    *ListAttachmentsInput
	nextToken *string
	firstPage bool
}

// NewListAttachmentsPaginator returns a new ListAttachmentsPaginator
func NewListAttachmentsPaginator(client ListAttachmentsAPIClient, params *ListAttachmentsInput, optFns ...func(*ListAttachmentsPaginatorOptions)) *ListAttachmentsPaginator {
	if params == nil {
		params = &ListAttachmentsInput{}
	}

	options := ListAttachmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAttachmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAttachmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAttachments page.
func (p *ListAttachmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAttachmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAttachments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAttachmentsAPIClient is a client that implements the ListAttachments
// operation.
type ListAttachmentsAPIClient interface {
	ListAttachments(context.Context, *ListAttachmentsInput, ...func(*Options)) (*ListAttachmentsOutput, error)
}

var _ ListAttachmentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAttachments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAttachments",
	}
}
