// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the data accessors for a Amazon Q Business application. This operation
// returns a paginated list of data accessor summaries, including the friendly
// name, unique identifier, ARN, associated IAM role, and creation/update
// timestamps for each data accessor.
func (c *Client) ListDataAccessors(ctx context.Context, params *ListDataAccessorsInput, optFns ...func(*Options)) (*ListDataAccessorsOutput, error) {
	if params == nil {
		params = &ListDataAccessorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataAccessors", params, optFns, c.addOperationListDataAccessorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataAccessorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataAccessorsInput struct {

	// The unique identifier of the Amazon Q Business application.
	//
	// This member is required.
	ApplicationId *string

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string

	noSmithyDocumentSerde
}

type ListDataAccessorsOutput struct {

	// The list of data accessors.
	DataAccessors []types.DataAccessor

	// The token to use to retrieve the next set of results, if there are any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataAccessorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataAccessors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataAccessors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataAccessors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListDataAccessorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataAccessors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataAccessorsPaginatorOptions is the paginator options for ListDataAccessors
type ListDataAccessorsPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataAccessorsPaginator is a paginator for ListDataAccessors
type ListDataAccessorsPaginator struct {
	options   ListDataAccessorsPaginatorOptions
	client    ListDataAccessorsAPIClient
	params    *ListDataAccessorsInput
	nextToken *string
	firstPage bool
}

// NewListDataAccessorsPaginator returns a new ListDataAccessorsPaginator
func NewListDataAccessorsPaginator(client ListDataAccessorsAPIClient, params *ListDataAccessorsInput, optFns ...func(*ListDataAccessorsPaginatorOptions)) *ListDataAccessorsPaginator {
	if params == nil {
		params = &ListDataAccessorsInput{}
	}

	options := ListDataAccessorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataAccessorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataAccessorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataAccessors page.
func (p *ListDataAccessorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataAccessorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataAccessors(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataAccessorsAPIClient is a client that implements the ListDataAccessors
// operation.
type ListDataAccessorsAPIClient interface {
	ListDataAccessors(context.Context, *ListDataAccessorsInput, ...func(*Options)) (*ListDataAccessorsOutput, error)
}

var _ ListDataAccessorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataAccessors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataAccessors",
	}
}
