// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an Amazon Q Business web experience.
func (c *Client) UpdateWebExperience(ctx context.Context, params *UpdateWebExperienceInput, optFns ...func(*Options)) (*UpdateWebExperienceOutput, error) {
	if params == nil {
		params = &UpdateWebExperienceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateWebExperience", params, optFns, c.addOperationUpdateWebExperienceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateWebExperienceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateWebExperienceInput struct {

	// The identifier of the Amazon Q Business application attached to the web
	// experience.
	//
	// This member is required.
	ApplicationId *string

	// The identifier of the Amazon Q Business web experience.
	//
	// This member is required.
	WebExperienceId *string

	// The authentication configuration of the Amazon Q Business web experience.
	//
	// Deprecated: Property associated with legacy SAML IdP flow. Deprecated in favor
	// of using AWS IAM Identity Center for user management.
	AuthenticationConfiguration types.WebExperienceAuthConfiguration

	// The browser extension configuration for an Amazon Q Business web experience.
	//
	// For Amazon Q Business application using external OIDC-compliant identity
	// providers (IdPs). The IdP administrator must add the browser extension sign-in
	// redirect URLs to the IdP application. For more information, see [Configure external OIDC identity provider for your browser extensions.].
	//
	// [Configure external OIDC identity provider for your browser extensions.]: https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/browser-extensions.html
	BrowserExtensionConfiguration *types.BrowserExtensionConfiguration

	// Updates the custom logo, favicon, font, and color used in the Amazon Q web
	// experience.
	CustomizationConfiguration *types.CustomizationConfiguration

	// Information about the identity provider (IdP) used to authenticate end users of
	// an Amazon Q Business web experience.
	IdentityProviderConfiguration types.IdentityProviderConfiguration

	// Updates the website domain origins that are allowed to embed the Amazon Q
	// Business web experience.
	//
	// The domain origin refers to the base URL for accessing a website including the
	// protocol ( http/https ), the domain name, and the port number (if specified).
	//
	//   - Any values except null submitted as part of this update will replace all
	//   previous values.
	//
	//   - You must only submit a base URL and not a full path. For example,
	//   https://docs.aws.amazon.com .
	Origins []string

	// The Amazon Resource Name (ARN) of the role with permission to access the Amazon
	// Q Business web experience and required resources.
	RoleArn *string

	// Determines whether sample prompts are enabled in the web experience for an end
	// user.
	SamplePromptsControlMode types.WebExperienceSamplePromptsControlMode

	// The subtitle of the Amazon Q Business web experience.
	Subtitle *string

	// The title of the Amazon Q Business web experience.
	Title *string

	// A customized welcome message for an end user in an Amazon Q Business web
	// experience.
	WelcomeMessage *string

	noSmithyDocumentSerde
}

type UpdateWebExperienceOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateWebExperienceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateWebExperience{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateWebExperience{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateWebExperience"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateWebExperienceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateWebExperience(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateWebExperience(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateWebExperience",
	}
}
