// Code generated by smithy-go-codegen DO NOT EDIT.

package qconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon Q in Connect AI Guardrail.
func (c *Client) CreateAIGuardrail(ctx context.Context, params *CreateAIGuardrailInput, optFns ...func(*Options)) (*CreateAIGuardrailOutput, error) {
	if params == nil {
		params = &CreateAIGuardrailInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAIGuardrail", params, optFns, c.addOperationCreateAIGuardrailMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAIGuardrailOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAIGuardrailInput struct {

	// The identifier of the Amazon Q in Connect assistant. Can be either the ID or
	// the ARN. URLs cannot contain the ARN.
	//
	// This member is required.
	AssistantId *string

	// The message to return when the AI Guardrail blocks a prompt.
	//
	// This member is required.
	BlockedInputMessaging *string

	// The message to return when the AI Guardrail blocks a model response.
	//
	// This member is required.
	BlockedOutputsMessaging *string

	// The name of the AI Guardrail.
	//
	// This member is required.
	Name *string

	// The visibility status of the AI Guardrail.
	//
	// This member is required.
	VisibilityStatus types.VisibilityStatus

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see [Making retries safe with idempotent APIs]..
	//
	// [Making retries safe with idempotent APIs]: http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	// The content filter policies to configure for the AI Guardrail.
	ContentPolicyConfig *types.AIGuardrailContentPolicyConfig

	// The contextual grounding policy configuration used to create an AI Guardrail.
	ContextualGroundingPolicyConfig *types.AIGuardrailContextualGroundingPolicyConfig

	// A description of the AI Guardrail.
	Description *string

	// The sensitive information policy to configure for the AI Guardrail.
	SensitiveInformationPolicyConfig *types.AIGuardrailSensitiveInformationPolicyConfig

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// The topic policies to configure for the AI Guardrail.
	TopicPolicyConfig *types.AIGuardrailTopicPolicyConfig

	// The word policy you configure for the AI Guardrail.
	WordPolicyConfig *types.AIGuardrailWordPolicyConfig

	noSmithyDocumentSerde
}

type CreateAIGuardrailOutput struct {

	// The data of the AI Guardrail.
	AiGuardrail *types.AIGuardrailData

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAIGuardrailMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAIGuardrail{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAIGuardrail{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAIGuardrail"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAIGuardrailMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAIGuardrailValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAIGuardrail(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAIGuardrail struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAIGuardrail) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAIGuardrail) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAIGuardrailInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAIGuardrailInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAIGuardrailMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAIGuardrail{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAIGuardrail(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAIGuardrail",
	}
}
