// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all folders that a resource is a member of.
func (c *Client) ListFoldersForResource(ctx context.Context, params *ListFoldersForResourceInput, optFns ...func(*Options)) (*ListFoldersForResourceOutput, error) {
	if params == nil {
		params = &ListFoldersForResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFoldersForResource", params, optFns, c.addOperationListFoldersForResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFoldersForResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFoldersForResourceInput struct {

	// The ID for the Amazon Web Services account that contains the resource.
	//
	// This member is required.
	AwsAccountId *string

	// The Amazon Resource Name (ARN) the resource whose folders you need to list.
	//
	// This member is required.
	ResourceArn *string

	// The maximum number of results to be returned per request.
	MaxResults *int32

	// The token for the next set of results, or null if there are no more results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListFoldersForResourceOutput struct {

	// A list that contains the Amazon Resource Names (ARNs) of all folders that the
	// resource is a member of.
	Folders []string

	// The token for the next set of results, or null if there are no more results.
	NextToken *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFoldersForResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListFoldersForResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListFoldersForResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFoldersForResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListFoldersForResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFoldersForResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListFoldersForResourcePaginatorOptions is the paginator options for
// ListFoldersForResource
type ListFoldersForResourcePaginatorOptions struct {
	// The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFoldersForResourcePaginator is a paginator for ListFoldersForResource
type ListFoldersForResourcePaginator struct {
	options   ListFoldersForResourcePaginatorOptions
	client    ListFoldersForResourceAPIClient
	params    *ListFoldersForResourceInput
	nextToken *string
	firstPage bool
}

// NewListFoldersForResourcePaginator returns a new ListFoldersForResourcePaginator
func NewListFoldersForResourcePaginator(client ListFoldersForResourceAPIClient, params *ListFoldersForResourceInput, optFns ...func(*ListFoldersForResourcePaginatorOptions)) *ListFoldersForResourcePaginator {
	if params == nil {
		params = &ListFoldersForResourceInput{}
	}

	options := ListFoldersForResourcePaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFoldersForResourcePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFoldersForResourcePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFoldersForResource page.
func (p *ListFoldersForResourcePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFoldersForResourceOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFoldersForResource(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFoldersForResourceAPIClient is a client that implements the
// ListFoldersForResource operation.
type ListFoldersForResourceAPIClient interface {
	ListFoldersForResource(context.Context, *ListFoldersForResourceInput, ...func(*Options)) (*ListFoldersForResourceOutput, error)
}

var _ ListFoldersForResourceAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFoldersForResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFoldersForResource",
	}
}
