// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending
// on whether the application accessing your cluster is running on the Internet or
// an Amazon EC2 instance, you can authorize inbound access to either a Classless
// Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2
// security group. You can add as many as 20 ingress rules to an Amazon Redshift
// security group.
//
// If you authorize access to an Amazon EC2 security group, specify
// EC2SecurityGroupName and EC2SecurityGroupOwnerId. The Amazon EC2 security group
// and Amazon Redshift cluster must be in the same Amazon Web Services Region.
//
// If you authorize access to a CIDR/IP address range, specify CIDRIP. For an
// overview of CIDR blocks, see the Wikipedia article on [Classless Inter-Domain Routing].
//
// You must also associate the security group with a cluster so that clients
// running on these IP addresses or the EC2 instance are authorized to connect to
// the cluster. For information about managing security groups, go to [Working with Security Groups]in the
// Amazon Redshift Cluster Management Guide.
//
// [Classless Inter-Domain Routing]: http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing
// [Working with Security Groups]: https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html
func (c *Client) AuthorizeClusterSecurityGroupIngress(ctx context.Context, params *AuthorizeClusterSecurityGroupIngressInput, optFns ...func(*Options)) (*AuthorizeClusterSecurityGroupIngressOutput, error) {
	if params == nil {
		params = &AuthorizeClusterSecurityGroupIngressInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AuthorizeClusterSecurityGroupIngress", params, optFns, c.addOperationAuthorizeClusterSecurityGroupIngressMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AuthorizeClusterSecurityGroupIngressOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AuthorizeClusterSecurityGroupIngressInput struct {

	// The name of the security group to which the ingress rule is added.
	//
	// This member is required.
	ClusterSecurityGroupName *string

	// The IP range to be added the Amazon Redshift security group.
	CIDRIP *string

	// The EC2 security group to be added the Amazon Redshift security group.
	EC2SecurityGroupName *string

	// The Amazon Web Services account number of the owner of the security group
	// specified by the EC2SecurityGroupName parameter. The Amazon Web Services Access
	// Key ID is not an acceptable value.
	//
	// Example: 111122223333
	EC2SecurityGroupOwnerId *string

	noSmithyDocumentSerde
}

type AuthorizeClusterSecurityGroupIngressOutput struct {

	// Describes a security group.
	ClusterSecurityGroup *types.ClusterSecurityGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAuthorizeClusterSecurityGroupIngressMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpAuthorizeClusterSecurityGroupIngress{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpAuthorizeClusterSecurityGroupIngress{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AuthorizeClusterSecurityGroupIngress"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpAuthorizeClusterSecurityGroupIngressValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAuthorizeClusterSecurityGroupIngress(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAuthorizeClusterSecurityGroupIngress(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AuthorizeClusterSecurityGroupIngress",
	}
}
