// Code generated by smithy-go-codegen DO NOT EDIT.

package redshiftserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshiftserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about a list of specified managed workgroups in your
// account.
func (c *Client) ListManagedWorkgroups(ctx context.Context, params *ListManagedWorkgroupsInput, optFns ...func(*Options)) (*ListManagedWorkgroupsOutput, error) {
	if params == nil {
		params = &ListManagedWorkgroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedWorkgroups", params, optFns, c.addOperationListManagedWorkgroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedWorkgroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedWorkgroupsInput struct {

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int32

	// If your initial ListManagedWorkgroups operation returns a nextToken, you can
	// include the returned nextToken in following ListManagedWorkgroups operations,
	// which returns results in the next page.
	NextToken *string

	// The Amazon Resource Name (ARN) for the managed workgroup in the AWS Glue Data
	// Catalog.
	SourceArn *string

	noSmithyDocumentSerde
}

type ListManagedWorkgroupsOutput struct {

	// The returned array of managed workgroups.
	ManagedWorkgroups []types.ManagedWorkgroupListItem

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. To retrieve the next page,
	// make the call again using the returned token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedWorkgroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListManagedWorkgroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListManagedWorkgroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedWorkgroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedWorkgroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListManagedWorkgroupsPaginatorOptions is the paginator options for
// ListManagedWorkgroups
type ListManagedWorkgroupsPaginatorOptions struct {
	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedWorkgroupsPaginator is a paginator for ListManagedWorkgroups
type ListManagedWorkgroupsPaginator struct {
	options   ListManagedWorkgroupsPaginatorOptions
	client    ListManagedWorkgroupsAPIClient
	params    *ListManagedWorkgroupsInput
	nextToken *string
	firstPage bool
}

// NewListManagedWorkgroupsPaginator returns a new ListManagedWorkgroupsPaginator
func NewListManagedWorkgroupsPaginator(client ListManagedWorkgroupsAPIClient, params *ListManagedWorkgroupsInput, optFns ...func(*ListManagedWorkgroupsPaginatorOptions)) *ListManagedWorkgroupsPaginator {
	if params == nil {
		params = &ListManagedWorkgroupsInput{}
	}

	options := ListManagedWorkgroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedWorkgroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedWorkgroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedWorkgroups page.
func (p *ListManagedWorkgroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedWorkgroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedWorkgroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedWorkgroupsAPIClient is a client that implements the
// ListManagedWorkgroups operation.
type ListManagedWorkgroupsAPIClient interface {
	ListManagedWorkgroups(context.Context, *ListManagedWorkgroupsInput, ...func(*Options)) (*ListManagedWorkgroupsOutput, error)
}

var _ ListManagedWorkgroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedWorkgroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedWorkgroups",
	}
}
