// Code generated by smithy-go-codegen DO NOT EDIT.

package resourcegroups

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new tag-sync task to onboard and sync resources tagged with a
// specific tag key-value pair to an application.
//
// # Minimum permissions
//
// To run this command, you must have the following permissions:
//
//   - resource-groups:StartTagSyncTask on the application group
//
//   - resource-groups:CreateGroup
//
//   - iam:PassRole on the role provided in the request
func (c *Client) StartTagSyncTask(ctx context.Context, params *StartTagSyncTaskInput, optFns ...func(*Options)) (*StartTagSyncTaskOutput, error) {
	if params == nil {
		params = &StartTagSyncTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartTagSyncTask", params, optFns, c.addOperationStartTagSyncTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartTagSyncTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartTagSyncTaskInput struct {

	// The Amazon resource name (ARN) or name of the application group for which you
	// want to create a tag-sync task.
	//
	// This member is required.
	Group *string

	// The Amazon resource name (ARN) of the role assumed by the service to tag and
	// untag resources on your behalf.
	//
	// This member is required.
	RoleArn *string

	// The tag key. Resources tagged with this tag key-value pair will be added to the
	// application. If a resource with this tag is later untagged, the tag-sync task
	// removes the resource from the application.
	//
	// This member is required.
	TagKey *string

	// The tag value. Resources tagged with this tag key-value pair will be added to
	// the application. If a resource with this tag is later untagged, the tag-sync
	// task removes the resource from the application.
	//
	// This member is required.
	TagValue *string

	noSmithyDocumentSerde
}

type StartTagSyncTaskOutput struct {

	// The Amazon resource name (ARN) of the application group for which you want to
	// add or remove resources.
	GroupArn *string

	// The name of the application group to onboard and sync resources.
	GroupName *string

	// The Amazon resource name (ARN) of the role assumed by the service to tag and
	// untag resources on your behalf.
	RoleArn *string

	// The tag key of the tag-sync task.
	TagKey *string

	// The tag value of the tag-sync task.
	TagValue *string

	// The Amazon resource name (ARN) of the new tag-sync task.
	TaskArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartTagSyncTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartTagSyncTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartTagSyncTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartTagSyncTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpStartTagSyncTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartTagSyncTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartTagSyncTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartTagSyncTask",
	}
}
