// Code generated by smithy-go-codegen DO NOT EDIT.

package robomaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/robomaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// End of support notice: On September 10, 2025, Amazon Web Services will
// discontinue support for Amazon Web Services RoboMaker. After September 10, 2025,
// you will no longer be able to access the Amazon Web Services RoboMaker console
// or Amazon Web Services RoboMaker resources. For more information on
// transitioning to Batch to help run containerized simulations, visit [https://aws.amazon.com/blogs/hpc/run-simulations-using-multiple-containers-in-a-single-aws-batch-job/].
//
// Returns a list of robot application. You can optionally provide filters to
// retrieve specific robot applications.
//
// [https://aws.amazon.com/blogs/hpc/run-simulations-using-multiple-containers-in-a-single-aws-batch-job/]: https://aws.amazon.com/blogs/hpc/run-simulations-using-multiple-containers-in-a-single-aws-batch-job/
func (c *Client) ListRobotApplications(ctx context.Context, params *ListRobotApplicationsInput, optFns ...func(*Options)) (*ListRobotApplicationsOutput, error) {
	if params == nil {
		params = &ListRobotApplicationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRobotApplications", params, optFns, c.addOperationListRobotApplicationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRobotApplicationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRobotApplicationsInput struct {

	// Optional filters to limit results.
	//
	// The filter name name is supported. When filtering, you must use the complete
	// value of the filtered item. You can use up to three filters.
	Filters []types.Filter

	// When this parameter is used, ListRobotApplications only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another
	// ListRobotApplications request with the returned nextToken value. This value can
	// be between 1 and 100. If this parameter is not used, then ListRobotApplications
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int32

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListRobotApplications again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string

	// The version qualifier of the robot application.
	VersionQualifier *string

	noSmithyDocumentSerde
}

type ListRobotApplicationsOutput struct {

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListRobotApplications again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string

	// A list of robot application summaries that meet the criteria of the request.
	RobotApplicationSummaries []types.RobotApplicationSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRobotApplicationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRobotApplications{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRobotApplications{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRobotApplications"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRobotApplications(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListRobotApplicationsPaginatorOptions is the paginator options for
// ListRobotApplications
type ListRobotApplicationsPaginatorOptions struct {
	// When this parameter is used, ListRobotApplications only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another
	// ListRobotApplications request with the returned nextToken value. This value can
	// be between 1 and 100. If this parameter is not used, then ListRobotApplications
	// returns up to 100 results and a nextToken value if applicable.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRobotApplicationsPaginator is a paginator for ListRobotApplications
type ListRobotApplicationsPaginator struct {
	options   ListRobotApplicationsPaginatorOptions
	client    ListRobotApplicationsAPIClient
	params    *ListRobotApplicationsInput
	nextToken *string
	firstPage bool
}

// NewListRobotApplicationsPaginator returns a new ListRobotApplicationsPaginator
func NewListRobotApplicationsPaginator(client ListRobotApplicationsAPIClient, params *ListRobotApplicationsInput, optFns ...func(*ListRobotApplicationsPaginatorOptions)) *ListRobotApplicationsPaginator {
	if params == nil {
		params = &ListRobotApplicationsInput{}
	}

	options := ListRobotApplicationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRobotApplicationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRobotApplicationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRobotApplications page.
func (p *ListRobotApplicationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRobotApplicationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRobotApplications(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRobotApplicationsAPIClient is a client that implements the
// ListRobotApplications operation.
type ListRobotApplicationsAPIClient interface {
	ListRobotApplications(context.Context, *ListRobotApplicationsInput, ...func(*Options)) (*ListRobotApplicationsOutput, error)
}

var _ ListRobotApplicationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRobotApplications(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRobotApplications",
	}
}
