// Code generated by smithy-go-codegen DO NOT EDIT.

package route53resolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53resolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes the specified firewall rule.
func (c *Client) DeleteFirewallRule(ctx context.Context, params *DeleteFirewallRuleInput, optFns ...func(*Options)) (*DeleteFirewallRuleOutput, error) {
	if params == nil {
		params = &DeleteFirewallRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteFirewallRule", params, optFns, c.addOperationDeleteFirewallRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteFirewallRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteFirewallRuleInput struct {

	// The unique identifier of the firewall rule group that you want to delete the
	// rule from.
	//
	// This member is required.
	FirewallRuleGroupId *string

	// The ID of the domain list that's used in the rule.
	FirewallDomainListId *string

	//  The ID that is created for a DNS Firewall Advanced rule.
	FirewallThreatProtectionId *string

	//  The DNS query type that the rule you are deleting evaluates. Allowed values
	// are;
	//
	//   - A: Returns an IPv4 address.
	//
	//   - AAAA: Returns an Ipv6 address.
	//
	//   - CAA: Restricts CAs that can create SSL/TLS certifications for the domain.
	//
	//   - CNAME: Returns another domain name.
	//
	//   - DS: Record that identifies the DNSSEC signing key of a delegated zone.
	//
	//   - MX: Specifies mail servers.
	//
	//   - NAPTR: Regular-expression-based rewriting of domain names.
	//
	//   - NS: Authoritative name servers.
	//
	//   - PTR: Maps an IP address to a domain name.
	//
	//   - SOA: Start of authority record for the zone.
	//
	//   - SPF: Lists the servers authorized to send emails from a domain.
	//
	//   - SRV: Application specific values that identify servers.
	//
	//   - TXT: Verifies email senders and application-specific values.
	//
	//   - A query type you define by using the DNS type ID, for example 28 for AAAA.
	//   The values must be defined as TYPENUMBER, where the NUMBER can be 1-65334, for
	//   example, TYPE28. For more information, see [List of DNS record types].
	//
	// [List of DNS record types]: https://en.wikipedia.org/wiki/List_of_DNS_record_types
	Qtype *string

	noSmithyDocumentSerde
}

type DeleteFirewallRuleOutput struct {

	// The specification for the firewall rule that you just deleted.
	FirewallRule *types.FirewallRule

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteFirewallRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDeleteFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDeleteFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteFirewallRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteFirewallRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteFirewallRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteFirewallRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteFirewallRule",
	}
}
