// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/s3control/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
	"time"
)

// Creates an access grant that gives a grantee access to your S3 data. The
// grantee can be an IAM user or role or a directory user, or group. Before you can
// create a grant, you must have an S3 Access Grants instance in the same Region as
// the S3 data. You can create an S3 Access Grants instance using the [CreateAccessGrantsInstance]. You must
// also have registered at least one S3 data location in your S3 Access Grants
// instance using [CreateAccessGrantsLocation].
//
// Permissions You must have the s3:CreateAccessGrant permission to use this
// operation.
//
// Additional Permissions For any directory identity - sso:DescribeInstance and
// sso:DescribeApplication
//
// For directory users - identitystore:DescribeUser
//
// For directory groups - identitystore:DescribeGroup
//
// [CreateAccessGrantsLocation]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsLocation.html
// [CreateAccessGrantsInstance]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsInstance.html
func (c *Client) CreateAccessGrant(ctx context.Context, params *CreateAccessGrantInput, optFns ...func(*Options)) (*CreateAccessGrantOutput, error) {
	if params == nil {
		params = &CreateAccessGrantInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAccessGrant", params, optFns, c.addOperationCreateAccessGrantMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAccessGrantOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAccessGrantInput struct {

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated ID
	// to other locations that you register.
	//
	// If you are passing the default location, you cannot create an access grant for
	// the entire default location. You must also specify a bucket or a bucket and
	// prefix in the Subprefix field.
	//
	// This member is required.
	AccessGrantsLocationId *string

	// The Amazon Web Services account ID of the S3 Access Grants instance.
	//
	// This member is required.
	AccountId *string

	// The user, group, or role to which you are granting access. You can grant access
	// to an IAM user or role. If you have added your corporate directory to Amazon Web
	// Services IAM Identity Center and associated your Identity Center instance with
	// your S3 Access Grants instance, the grantee can also be a corporate directory
	// user or group.
	//
	// This member is required.
	Grantee *types.Grantee

	// The type of access that you are granting to your S3 data, which can be set to
	// one of the following values:
	//
	//   - READ – Grant read-only access to the S3 data.
	//
	//   - WRITE – Grant write-only access to the S3 data.
	//
	//   - READWRITE – Grant both read and write access to the S3 data.
	//
	// This member is required.
	Permission types.Permission

	// The configuration options of the grant location. The grant location is the S3
	// path to the data to which you are granting access. It contains the S3SubPrefix
	// field. The grant scope is the result of appending the subprefix to the location
	// scope of the registered location.
	AccessGrantsLocationConfiguration *types.AccessGrantsLocationConfiguration

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If an application ARN
	// is included in the request to create an access grant, the grantee can only
	// access the S3 data through this application.
	ApplicationArn *string

	// The type of S3SubPrefix . The only possible value is Object . Pass this value if
	// the access grant scope is an object. Do not pass this value if the access grant
	// scope is a bucket or a bucket and a prefix.
	S3PrefixType types.S3PrefixType

	// The Amazon Web Services resource tags that you are adding to the access grant.
	// Each tag is a label consisting of a user-defined key and value. Tags can help
	// you manage, identify, organize, search for, and filter resources.
	Tags []types.Tag

	noSmithyDocumentSerde
}

func (in *CreateAccessGrantInput) bindEndpointParams(p *EndpointParameters) {

	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
}

type CreateAccessGrantOutput struct {

	// The Amazon Resource Name (ARN) of the access grant.
	AccessGrantArn *string

	// The ID of the access grant. S3 Access Grants auto-generates this ID when you
	// create the access grant.
	AccessGrantId *string

	// The configuration options of the grant location. The grant location is the S3
	// path to the data to which you are granting access.
	AccessGrantsLocationConfiguration *types.AccessGrantsLocationConfiguration

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated ID
	// to other locations that you register.
	AccessGrantsLocationId *string

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If the grant includes
	// an application ARN, the grantee can only access the S3 data through this
	// application.
	ApplicationArn *string

	// The date and time when you created the access grant.
	CreatedAt *time.Time

	// The S3 path of the data to which you are granting access. It is the result of
	// appending the Subprefix to the location scope.
	GrantScope *string

	// The user, group, or role to which you are granting access. You can grant access
	// to an IAM user or role. If you have added your corporate directory to Amazon Web
	// Services IAM Identity Center and associated your Identity Center instance with
	// your S3 Access Grants instance, the grantee can also be a corporate directory
	// user or group.
	Grantee *types.Grantee

	// The type of access that you are granting to your S3 data, which can be set to
	// one of the following values:
	//
	//   - READ – Grant read-only access to the S3 data.
	//
	//   - WRITE – Grant write-only access to the S3 data.
	//
	//   - READWRITE – Grant both read and write access to the S3 data.
	Permission types.Permission

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAccessGrantMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpCreateAccessGrant{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpCreateAccessGrant{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAccessGrant"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddContentChecksumMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateAccessGrantMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateAccessGrantValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAccessGrant(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addCreateAccessGrantUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = s3controlcust.AddDisableHostPrefixMiddleware(stack); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateAccessGrantMiddleware struct {
}

func (*endpointPrefix_opCreateAccessGrantMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateAccessGrantMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	opaqueInput := getOperationInput(ctx)
	input, ok := opaqueInput.(*CreateAccessGrantInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input type %T", opaqueInput)
	}

	var prefix strings.Builder
	if input.AccountId == nil {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so may not be nil")}
	} else if !smithyhttp.ValidHostLabel(*input.AccountId) {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so must match \"[a-zA-Z0-9-]{1,63}\", but was \"%s\"", *input.AccountId)}
	} else {
		prefix.WriteString(*input.AccountId)
	}
	prefix.WriteString(".")
	req.URL.Host = prefix.String() + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateAccessGrantMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateAccessGrantMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opCreateAccessGrant(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAccessGrant",
	}
}

func copyCreateAccessGrantInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*CreateAccessGrantInput)
	if !ok {
		return nil, fmt.Errorf("expect *CreateAccessGrantInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *CreateAccessGrantInput) copy() interface{} {
	v := *in
	return &v
}
func backFillCreateAccessGrantAccountID(input interface{}, v string) error {
	in := input.(*CreateAccessGrantInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addCreateAccessGrantUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: nopGetARNAccessor,
			BackfillAccountID: nopBackfillAccountIDAccessor,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    nopSetARNAccessor,
			CopyInput:         copyCreateAccessGrantInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
