// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new maintenance configuration or replaces an existing maintenance
// configuration for a table. For more information, see [S3 Tables maintenance]in the Amazon Simple
// Storage Service User Guide.
//
// Permissions You must have the s3tables:PutTableMaintenanceConfiguration
// permission to use this operation.
//
// [S3 Tables maintenance]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html
func (c *Client) PutTableMaintenanceConfiguration(ctx context.Context, params *PutTableMaintenanceConfigurationInput, optFns ...func(*Options)) (*PutTableMaintenanceConfigurationOutput, error) {
	if params == nil {
		params = &PutTableMaintenanceConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutTableMaintenanceConfiguration", params, optFns, c.addOperationPutTableMaintenanceConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutTableMaintenanceConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutTableMaintenanceConfigurationInput struct {

	// The name of the maintenance configuration.
	//
	// This member is required.
	Name *string

	// The namespace of the table.
	//
	// This member is required.
	Namespace *string

	// The Amazon Resource Name (ARN) of the table associated with the maintenance
	// configuration.
	//
	// This member is required.
	TableBucketARN *string

	// The type of the maintenance configuration.
	//
	// This member is required.
	Type types.TableMaintenanceType

	// Defines the values of the maintenance configuration for the table.
	//
	// This member is required.
	Value *types.TableMaintenanceConfigurationValue

	noSmithyDocumentSerde
}

type PutTableMaintenanceConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutTableMaintenanceConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutTableMaintenanceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutTableMaintenanceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutTableMaintenanceConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpPutTableMaintenanceConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutTableMaintenanceConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutTableMaintenanceConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutTableMaintenanceConfiguration",
	}
}
