// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a URL for a specified UserProfile in a Domain. When accessed in a web
// browser, the user will be automatically signed in to the domain, and granted
// access to all of the Apps and files associated with the Domain's Amazon Elastic
// File System volume. This operation can only be called when the authentication
// mode equals IAM.
//
// The IAM role or user passed to this API defines the permissions to access the
// app. Once the presigned URL is created, no additional permission is required to
// access this URL. IAM authorization policies for this API are also enforced for
// every HTTP request and WebSocket frame that attempts to connect to the app.
//
// You can restrict access to this API and to the URL that it returns to a list of
// IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more
// information, see [Connect to Amazon SageMaker AI Studio Through an Interface VPC Endpoint].
//
//   - The URL that you get from a call to CreatePresignedDomainUrl has a default
//     timeout of 5 minutes. You can configure this value using ExpiresInSeconds . If
//     you try to use the URL after the timeout limit expires, you are directed to the
//     Amazon Web Services console sign-in page.
//
//   - The JupyterLab session default expiration time is 12 hours. You can
//     configure this value using SessionExpirationDurationInSeconds.
//
// [Connect to Amazon SageMaker AI Studio Through an Interface VPC Endpoint]: https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html
func (c *Client) CreatePresignedDomainUrl(ctx context.Context, params *CreatePresignedDomainUrlInput, optFns ...func(*Options)) (*CreatePresignedDomainUrlOutput, error) {
	if params == nil {
		params = &CreatePresignedDomainUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePresignedDomainUrl", params, optFns, c.addOperationCreatePresignedDomainUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePresignedDomainUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePresignedDomainUrlInput struct {

	// The domain ID.
	//
	// This member is required.
	DomainId *string

	// The name of the UserProfile to sign-in as.
	//
	// This member is required.
	UserProfileName *string

	// The number of seconds until the pre-signed URL expires. This value defaults to
	// 300.
	ExpiresInSeconds *int32

	// The landing page that the user is directed to when accessing the presigned URL.
	// Using this value, users can access Studio or Studio Classic, even if it is not
	// the default experience for the domain. The supported values are:
	//
	//   - studio::relative/path : Directs users to the relative path in Studio.
	//
	//   - app:JupyterServer:relative/path : Directs users to the relative path in the
	//   Studio Classic application.
	//
	//   - app:JupyterLab:relative/path : Directs users to the relative path in the
	//   JupyterLab application.
	//
	//   - app:RStudioServerPro:relative/path : Directs users to the relative path in
	//   the RStudio application.
	//
	//   - app:CodeEditor:relative/path : Directs users to the relative path in the
	//   Code Editor, based on Code-OSS, Visual Studio Code - Open Source application.
	//
	//   - app:Canvas:relative/path : Directs users to the relative path in the Canvas
	//   application.
	LandingUri *string

	// The session expiration duration in seconds. This value defaults to 43200.
	SessionExpirationDurationInSeconds *int32

	// The name of the space.
	SpaceName *string

	noSmithyDocumentSerde
}

type CreatePresignedDomainUrlOutput struct {

	// The presigned URL.
	AuthorizedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePresignedDomainUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreatePresignedDomainUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreatePresignedDomainUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePresignedDomainUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePresignedDomainUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePresignedDomainUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreatePresignedDomainUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePresignedDomainUrl",
	}
}
