// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about an MLflow Tracking Server.
func (c *Client) DescribeMlflowTrackingServer(ctx context.Context, params *DescribeMlflowTrackingServerInput, optFns ...func(*Options)) (*DescribeMlflowTrackingServerOutput, error) {
	if params == nil {
		params = &DescribeMlflowTrackingServerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMlflowTrackingServer", params, optFns, c.addOperationDescribeMlflowTrackingServerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMlflowTrackingServerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMlflowTrackingServerInput struct {

	// The name of the MLflow Tracking Server to describe.
	//
	// This member is required.
	TrackingServerName *string

	noSmithyDocumentSerde
}

type DescribeMlflowTrackingServerOutput struct {

	// The S3 URI of the general purpose bucket used as the MLflow Tracking Server
	// artifact store.
	ArtifactStoreUri *string

	// Whether automatic registration of new MLflow models to the SageMaker Model
	// Registry is enabled.
	AutomaticModelRegistration *bool

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *types.UserContext

	// The timestamp of when the described MLflow Tracking Server was created.
	CreationTime *time.Time

	// Whether the described MLflow Tracking Server is currently active.
	IsActive types.IsTrackingServerActive

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *types.UserContext

	// The timestamp of when the described MLflow Tracking Server was last modified.
	LastModifiedTime *time.Time

	// The MLflow version used for the described tracking server.
	MlflowVersion *string

	// The Amazon Resource Name (ARN) for an IAM role in your account that the
	// described MLflow Tracking Server uses to access the artifact store in Amazon S3.
	RoleArn *string

	// The ARN of the described tracking server.
	TrackingServerArn *string

	// The name of the described tracking server.
	TrackingServerName *string

	// The size of the described tracking server.
	TrackingServerSize types.TrackingServerSize

	// The current creation status of the described MLflow Tracking Server.
	TrackingServerStatus types.TrackingServerStatus

	// The URL to connect to the MLflow user interface for the described tracking
	// server.
	TrackingServerUrl *string

	// The day and time of the week when weekly maintenance occurs on the described
	// tracking server.
	WeeklyMaintenanceWindowStart *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMlflowTrackingServerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeMlflowTrackingServer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeMlflowTrackingServer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMlflowTrackingServer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeMlflowTrackingServerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMlflowTrackingServer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeMlflowTrackingServer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMlflowTrackingServer",
	}
}
