// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about a SageMaker Partner AI App.
func (c *Client) DescribePartnerApp(ctx context.Context, params *DescribePartnerAppInput, optFns ...func(*Options)) (*DescribePartnerAppOutput, error) {
	if params == nil {
		params = &DescribePartnerAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribePartnerApp", params, optFns, c.addOperationDescribePartnerAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribePartnerAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribePartnerAppInput struct {

	// The ARN of the SageMaker Partner AI App to describe.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type DescribePartnerAppOutput struct {

	// Configuration settings for the SageMaker Partner AI App.
	ApplicationConfig *types.PartnerAppConfig

	// The ARN of the SageMaker Partner AI App that was described.
	Arn *string

	// The authorization type that users use to access the SageMaker Partner AI App.
	AuthType types.PartnerAppAuthType

	// The URL of the SageMaker Partner AI App that the Application SDK uses to
	// support in-app calls for the user.
	BaseUrl *string

	// The time that the SageMaker Partner AI App was created.
	CreationTime *time.Time

	// When set to TRUE , the SageMaker Partner AI App sets the Amazon Web Services IAM
	// session name or the authenticated IAM user as the identity of the SageMaker
	// Partner AI App user.
	EnableIamSessionBasedIdentity *bool

	// This is an error field object that contains the error code and the reason for
	// an operation failure.
	Error *types.ErrorInfo

	// The ARN of the IAM role associated with the SageMaker Partner AI App.
	ExecutionRoleArn *string

	// Maintenance configuration settings for the SageMaker Partner AI App.
	MaintenanceConfig *types.PartnerAppMaintenanceConfig

	// The name of the SageMaker Partner AI App.
	Name *string

	// The status of the SageMaker Partner AI App.
	Status types.PartnerAppStatus

	// The instance type and size of the cluster attached to the SageMaker Partner AI
	// App.
	Tier *string

	// The type of SageMaker Partner AI App. Must be one of the following: lakera-guard
	// , comet , deepchecks-llm-evaluation , or fiddler .
	Type types.PartnerAppType

	// The version of the SageMaker Partner AI App.
	Version *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribePartnerAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribePartnerApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribePartnerApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribePartnerApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribePartnerAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribePartnerApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribePartnerApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribePartnerApp",
	}
}
