// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific training plan.
func (c *Client) DescribeTrainingPlan(ctx context.Context, params *DescribeTrainingPlanInput, optFns ...func(*Options)) (*DescribeTrainingPlanOutput, error) {
	if params == nil {
		params = &DescribeTrainingPlanInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTrainingPlan", params, optFns, c.addOperationDescribeTrainingPlanMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrainingPlanOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrainingPlanInput struct {

	// The name of the training plan to describe.
	//
	// This member is required.
	TrainingPlanName *string

	noSmithyDocumentSerde
}

type DescribeTrainingPlanOutput struct {

	// The current status of the training plan (e.g., Pending, Active, Expired). To
	// see the complete list of status values available for a training plan, refer to
	// the Status attribute within the [TrainingPlanSummary] object.
	//
	// [TrainingPlanSummary]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingPlanSummary.html
	//
	// This member is required.
	Status types.TrainingPlanStatus

	// The Amazon Resource Name (ARN); of the training plan.
	//
	// This member is required.
	TrainingPlanArn *string

	// The name of the training plan.
	//
	// This member is required.
	TrainingPlanName *string

	// The number of instances currently available for use in this training plan.
	AvailableInstanceCount *int32

	// The currency code for the upfront fee (e.g., USD).
	CurrencyCode *string

	// The number of whole hours in the total duration for this training plan.
	DurationHours *int64

	// The additional minutes beyond whole hours in the total duration for this
	// training plan.
	DurationMinutes *int64

	// The end time of the training plan.
	EndTime *time.Time

	// The number of instances currently in use from this training plan.
	InUseInstanceCount *int32

	// The list of Reserved Capacity providing the underlying compute resources of the
	// plan.
	ReservedCapacitySummaries []types.ReservedCapacitySummary

	// The start time of the training plan.
	StartTime *time.Time

	// A message providing additional information about the current status of the
	// training plan.
	StatusMessage *string

	// The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod) that
	// can use this training plan.
	//
	// Training plans are specific to their target resource.
	//
	//   - A training plan designed for SageMaker training jobs can only be used to
	//   schedule and run training jobs.
	//
	//   - A training plan for HyperPod clusters can be used exclusively to provide
	//   compute resources to a cluster's instance group.
	TargetResources []types.SageMakerResourceName

	// The total number of instances reserved in this training plan.
	TotalInstanceCount *int32

	// The upfront fee for the training plan.
	UpfrontFee *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrainingPlanMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeTrainingPlan{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeTrainingPlan{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTrainingPlan"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeTrainingPlanValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTrainingPlan(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeTrainingPlan(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTrainingPlan",
	}
}
