// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets a list of the Git repositories in your account.
func (c *Client) ListCodeRepositories(ctx context.Context, params *ListCodeRepositoriesInput, optFns ...func(*Options)) (*ListCodeRepositoriesOutput, error) {
	if params == nil {
		params = &ListCodeRepositoriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCodeRepositories", params, optFns, c.addOperationListCodeRepositoriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCodeRepositoriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCodeRepositoriesInput struct {

	// A filter that returns only Git repositories that were created after the
	// specified time.
	CreationTimeAfter *time.Time

	// A filter that returns only Git repositories that were created before the
	// specified time.
	CreationTimeBefore *time.Time

	// A filter that returns only Git repositories that were last modified after the
	// specified time.
	LastModifiedTimeAfter *time.Time

	// A filter that returns only Git repositories that were last modified before the
	// specified time.
	LastModifiedTimeBefore *time.Time

	// The maximum number of Git repositories to return in the response.
	MaxResults *int32

	// A string in the Git repositories name. This filter returns only repositories
	// whose name contains the specified string.
	NameContains *string

	// If the result of a ListCodeRepositoriesOutput request was truncated, the
	// response includes a NextToken . To get the next set of Git repositories, use the
	// token in the next request.
	NextToken *string

	// The field to sort results by. The default is Name .
	SortBy types.CodeRepositorySortBy

	// The sort order for results. The default is Ascending .
	SortOrder types.CodeRepositorySortOrder

	noSmithyDocumentSerde
}

type ListCodeRepositoriesOutput struct {

	// Gets a list of summaries of the Git repositories. Each summary specifies the
	// following values for the repository:
	//
	//   - Name
	//
	//   - Amazon Resource Name (ARN)
	//
	//   - Creation time
	//
	//   - Last modified time
	//
	//   - Configuration information, including the URL location of the repository and
	//   the ARN of the Amazon Web Services Secrets Manager secret that contains the
	//   credentials used to access the repository.
	//
	// This member is required.
	CodeRepositorySummaryList []types.CodeRepositorySummary

	// If the result of a ListCodeRepositoriesOutput request was truncated, the
	// response includes a NextToken . To get the next set of Git repositories, use the
	// token in the next request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCodeRepositoriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListCodeRepositories{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListCodeRepositories{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCodeRepositories"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCodeRepositories(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListCodeRepositoriesPaginatorOptions is the paginator options for
// ListCodeRepositories
type ListCodeRepositoriesPaginatorOptions struct {
	// The maximum number of Git repositories to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCodeRepositoriesPaginator is a paginator for ListCodeRepositories
type ListCodeRepositoriesPaginator struct {
	options   ListCodeRepositoriesPaginatorOptions
	client    ListCodeRepositoriesAPIClient
	params    *ListCodeRepositoriesInput
	nextToken *string
	firstPage bool
}

// NewListCodeRepositoriesPaginator returns a new ListCodeRepositoriesPaginator
func NewListCodeRepositoriesPaginator(client ListCodeRepositoriesAPIClient, params *ListCodeRepositoriesInput, optFns ...func(*ListCodeRepositoriesPaginatorOptions)) *ListCodeRepositoriesPaginator {
	if params == nil {
		params = &ListCodeRepositoriesInput{}
	}

	options := ListCodeRepositoriesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCodeRepositoriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCodeRepositoriesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCodeRepositories page.
func (p *ListCodeRepositoriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCodeRepositoriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCodeRepositories(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCodeRepositoriesAPIClient is a client that implements the
// ListCodeRepositories operation.
type ListCodeRepositoriesAPIClient interface {
	ListCodeRepositories(context.Context, *ListCodeRepositoriesInput, ...func(*Options)) (*ListCodeRepositoriesOutput, error)
}

var _ ListCodeRepositoriesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCodeRepositories(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCodeRepositories",
	}
}
