// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the inference components in your account and their properties.
func (c *Client) ListInferenceComponents(ctx context.Context, params *ListInferenceComponentsInput, optFns ...func(*Options)) (*ListInferenceComponentsOutput, error) {
	if params == nil {
		params = &ListInferenceComponentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInferenceComponents", params, optFns, c.addOperationListInferenceComponentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInferenceComponentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInferenceComponentsInput struct {

	// Filters the results to only those inference components that were created after
	// the specified time.
	CreationTimeAfter *time.Time

	// Filters the results to only those inference components that were created before
	// the specified time.
	CreationTimeBefore *time.Time

	// An endpoint name to filter the listed inference components. The response
	// includes only those inference components that are hosted at the specified
	// endpoint.
	EndpointNameEquals *string

	// Filters the results to only those inference components that were updated after
	// the specified time.
	LastModifiedTimeAfter *time.Time

	// Filters the results to only those inference components that were updated before
	// the specified time.
	LastModifiedTimeBefore *time.Time

	// The maximum number of inference components to return in the response. This
	// value defaults to 10.
	MaxResults *int32

	// Filters the results to only those inference components with a name that
	// contains the specified string.
	NameContains *string

	// A token that you use to get the next set of results following a truncated
	// response. If the response to the previous request was truncated, that response
	// provides the value for this token.
	NextToken *string

	// The field by which to sort the inference components in the response. The
	// default is CreationTime .
	SortBy types.InferenceComponentSortKey

	// The sort order for results. The default is Descending .
	SortOrder types.OrderKey

	// Filters the results to only those inference components with the specified
	// status.
	StatusEquals types.InferenceComponentStatus

	// A production variant name to filter the listed inference components. The
	// response includes only those inference components that are hosted at the
	// specified variant.
	VariantNameEquals *string

	noSmithyDocumentSerde
}

type ListInferenceComponentsOutput struct {

	// A list of inference components and their properties that matches any of the
	// filters you specified in the request.
	//
	// This member is required.
	InferenceComponents []types.InferenceComponentSummary

	// The token to use in a subsequent request to get the next set of results
	// following a truncated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInferenceComponentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListInferenceComponents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListInferenceComponents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInferenceComponents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInferenceComponents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListInferenceComponentsPaginatorOptions is the paginator options for
// ListInferenceComponents
type ListInferenceComponentsPaginatorOptions struct {
	// The maximum number of inference components to return in the response. This
	// value defaults to 10.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInferenceComponentsPaginator is a paginator for ListInferenceComponents
type ListInferenceComponentsPaginator struct {
	options   ListInferenceComponentsPaginatorOptions
	client    ListInferenceComponentsAPIClient
	params    *ListInferenceComponentsInput
	nextToken *string
	firstPage bool
}

// NewListInferenceComponentsPaginator returns a new
// ListInferenceComponentsPaginator
func NewListInferenceComponentsPaginator(client ListInferenceComponentsAPIClient, params *ListInferenceComponentsInput, optFns ...func(*ListInferenceComponentsPaginatorOptions)) *ListInferenceComponentsPaginator {
	if params == nil {
		params = &ListInferenceComponentsInput{}
	}

	options := ListInferenceComponentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInferenceComponentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInferenceComponentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInferenceComponents page.
func (p *ListInferenceComponentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInferenceComponentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInferenceComponents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInferenceComponentsAPIClient is a client that implements the
// ListInferenceComponents operation.
type ListInferenceComponentsAPIClient interface {
	ListInferenceComponents(context.Context, *ListInferenceComponentsInput, ...func(*Options)) (*ListInferenceComponentsOutput, error)
}

var _ ListInferenceComponentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInferenceComponents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInferenceComponents",
	}
}
