// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Creates a configuration policy with the defined configuration. Only the
//
// Security Hub delegated administrator can invoke this operation from the home
// Region.
func (c *Client) CreateConfigurationPolicy(ctx context.Context, params *CreateConfigurationPolicyInput, optFns ...func(*Options)) (*CreateConfigurationPolicyOutput, error) {
	if params == nil {
		params = &CreateConfigurationPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateConfigurationPolicy", params, optFns, c.addOperationCreateConfigurationPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateConfigurationPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateConfigurationPolicyInput struct {

	//  An object that defines how Security Hub is configured. It includes whether
	// Security Hub is enabled or disabled, a list of enabled security standards, a
	// list of enabled or disabled security controls, and a list of custom parameter
	// values for specified controls. If you provide a list of security controls that
	// are enabled in the configuration policy, Security Hub disables all other
	// controls (including newly released controls). If you provide a list of security
	// controls that are disabled in the configuration policy, Security Hub enables all
	// other controls (including newly released controls).
	//
	// This member is required.
	ConfigurationPolicy types.Policy

	//  The name of the configuration policy. Alphanumeric characters and the
	// following ASCII characters are permitted: -, ., !, *, / .
	//
	// This member is required.
	Name *string

	//  The description of the configuration policy.
	Description *string

	//  User-defined tags associated with a configuration policy. For more
	// information, see [Tagging Security Hub resources]in the Security Hub user guide.
	//
	// [Tagging Security Hub resources]: https://docs.aws.amazon.com/securityhub/latest/userguide/tagging-resources.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateConfigurationPolicyOutput struct {

	//  The Amazon Resource Name (ARN) of the configuration policy.
	Arn *string

	//  An object that defines how Security Hub is configured. It includes whether
	// Security Hub is enabled or disabled, a list of enabled security standards, a
	// list of enabled or disabled security controls, and a list of custom parameter
	// values for specified controls. If the request included a list of security
	// controls that are enabled in the configuration policy, Security Hub disables all
	// other controls (including newly released controls). If the request included a
	// list of security controls that are disabled in the configuration policy,
	// Security Hub enables all other controls (including newly released controls).
	ConfigurationPolicy types.Policy

	//  The date and time, in UTC and ISO 8601 format, that the configuration policy
	// was created.
	CreatedAt *time.Time

	//  The description of the configuration policy.
	Description *string

	//  The universally unique identifier (UUID) of the configuration policy.
	Id *string

	//  The name of the configuration policy.
	Name *string

	//  The date and time, in UTC and ISO 8601 format, that the configuration policy
	// was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateConfigurationPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateConfigurationPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateConfigurationPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateConfigurationPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateConfigurationPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateConfigurationPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateConfigurationPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateConfigurationPolicy",
	}
}
