// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Disassociates a target account, organizational unit, or the root from a
//
// specified configuration. When you disassociate a configuration from its target,
// the target inherits the configuration of the closest parent. If there’s no
// configuration to inherit, the target retains its settings but becomes a
// self-managed account. A target can be disassociated from a configuration policy
// or self-managed behavior. Only the Security Hub delegated administrator can
// invoke this operation from the home Region.
func (c *Client) StartConfigurationPolicyDisassociation(ctx context.Context, params *StartConfigurationPolicyDisassociationInput, optFns ...func(*Options)) (*StartConfigurationPolicyDisassociationOutput, error) {
	if params == nil {
		params = &StartConfigurationPolicyDisassociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartConfigurationPolicyDisassociation", params, optFns, c.addOperationStartConfigurationPolicyDisassociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartConfigurationPolicyDisassociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartConfigurationPolicyDisassociationInput struct {

	//  The Amazon Resource Name (ARN) of a configuration policy, the universally
	// unique identifier (UUID) of a configuration policy, or a value of
	// SELF_MANAGED_SECURITY_HUB for a self-managed configuration.
	//
	// This member is required.
	ConfigurationPolicyIdentifier *string

	//  The identifier of the target account, organizational unit, or the root to
	// disassociate from the specified configuration.
	Target types.Target

	noSmithyDocumentSerde
}

type StartConfigurationPolicyDisassociationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartConfigurationPolicyDisassociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartConfigurationPolicyDisassociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartConfigurationPolicyDisassociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartConfigurationPolicyDisassociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpStartConfigurationPolicyDisassociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartConfigurationPolicyDisassociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartConfigurationPolicyDisassociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartConfigurationPolicyDisassociation",
	}
}
