// Code generated by smithy-go-codegen DO NOT EDIT.

package securityir

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Grants permission to obtain an Amazon S3 presigned URL to download an
// attachment.
func (c *Client) GetCaseAttachmentDownloadUrl(ctx context.Context, params *GetCaseAttachmentDownloadUrlInput, optFns ...func(*Options)) (*GetCaseAttachmentDownloadUrlOutput, error) {
	if params == nil {
		params = &GetCaseAttachmentDownloadUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCaseAttachmentDownloadUrl", params, optFns, c.addOperationGetCaseAttachmentDownloadUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCaseAttachmentDownloadUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCaseAttachmentDownloadUrlInput struct {

	// Required element for GetCaseAttachmentDownloadUrl to identify the attachment ID
	// for downloading an attachment.
	//
	// This member is required.
	AttachmentId *string

	// Required element for GetCaseAttachmentDownloadUrl to identify the case ID for
	// downloading an attachment from.
	//
	// This member is required.
	CaseId *string

	noSmithyDocumentSerde
}

type GetCaseAttachmentDownloadUrlOutput struct {

	// Response element providing the Amazon S3 presigned URL to download an
	// attachment.
	//
	// This member is required.
	AttachmentPresignedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCaseAttachmentDownloadUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCaseAttachmentDownloadUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCaseAttachmentDownloadUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCaseAttachmentDownloadUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetCaseAttachmentDownloadUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCaseAttachmentDownloadUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCaseAttachmentDownloadUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCaseAttachmentDownloadUrl",
	}
}
