// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a multi-region endpoint (global-endpoint).
//
// The primary region is going to be the AWS-Region where the operation is
// executed. The secondary region has to be provided in request's parameters. From
// the data flow standpoint there is no difference between primary and secondary
// regions - sending traffic will be split equally between the two. The primary
// region is the region where the resource has been created and where it can be
// managed.
func (c *Client) CreateMultiRegionEndpoint(ctx context.Context, params *CreateMultiRegionEndpointInput, optFns ...func(*Options)) (*CreateMultiRegionEndpointOutput, error) {
	if params == nil {
		params = &CreateMultiRegionEndpointInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMultiRegionEndpoint", params, optFns, c.addOperationCreateMultiRegionEndpointMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMultiRegionEndpointOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to create a multi-region endpoint (global-endpoint).
type CreateMultiRegionEndpointInput struct {

	// Contains details of a multi-region endpoint (global-endpoint) being created.
	//
	// This member is required.
	Details *types.Details

	// The name of the multi-region endpoint (global-endpoint).
	//
	// This member is required.
	EndpointName *string

	// An array of objects that define the tags (keys and values) to associate with
	// the multi-region endpoint (global-endpoint).
	Tags []types.Tag

	noSmithyDocumentSerde
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateMultiRegionEndpointOutput struct {

	// The ID of the multi-region endpoint (global-endpoint).
	EndpointId *string

	// A status of the multi-region endpoint (global-endpoint) right after the create
	// request.
	//
	//   - CREATING – The resource is being provisioned.
	//
	//   - READY – The resource is ready to use.
	//
	//   - FAILED – The resource failed to be provisioned.
	//
	//   - DELETING – The resource is being deleted as requested.
	Status types.Status

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMultiRegionEndpointMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMultiRegionEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMultiRegionEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMultiRegionEndpoint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMultiRegionEndpointValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMultiRegionEndpoint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMultiRegionEndpoint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMultiRegionEndpoint",
	}
}
