// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An object that contains information about your account details.
type AccountDetails struct {

	// Additional email addresses where updates are sent about your account review
	// process.
	AdditionalContactEmailAddresses []string

	// The language you would prefer for the case. The contact language can be one of
	// ENGLISH or JAPANESE .
	ContactLanguage ContactLanguage

	// The type of email your account is sending. The mail type can be one of the
	// following:
	//
	//   - MARKETING – Most of your sending traffic is to keep your customers informed
	//   of your latest offering.
	//
	//   - TRANSACTIONAL – Most of your sending traffic is to communicate during a
	//   transaction with a customer.
	MailType MailType

	// Information about the review of the latest details you submitted.
	ReviewDetails *ReviewDetails

	// A description of the types of email that you plan to send.
	//
	// Deprecated: Use case description is optional and deprecated
	UseCaseDescription *string

	// The URL of your website. This information helps us better understand the type
	// of content that you plan to send.
	WebsiteURL *string

	noSmithyDocumentSerde
}

// Used to associate a configuration set with a MailManager archive.
type ArchivingOptions struct {

	// The Amazon Resource Name (ARN) of the MailManager archive where the Amazon SES
	// API v2 will archive sent emails.
	ArchiveArn *string

	noSmithyDocumentSerde
}

// Represents a single metric data query to include in a batch.
type BatchGetMetricDataQuery struct {

	// Represents the end date for the query interval.
	//
	// This member is required.
	EndDate *time.Time

	// The query identifier.
	//
	// This member is required.
	Id *string

	// The queried metric. This can be one of the following:
	//
	//   - SEND – Emails sent eligible for tracking in the VDM dashboard. This excludes
	//   emails sent to the mailbox simulator and emails addressed to more than one
	//   recipient.
	//
	//   - COMPLAINT – Complaints received for your account. This excludes complaints
	//   from the mailbox simulator, those originating from your account-level
	//   suppression list (if enabled), and those for emails addressed to more than one
	//   recipient
	//
	//   - PERMANENT_BOUNCE – Permanent bounces - i.e. feedback received for emails
	//   sent to non-existent mailboxes. Excludes bounces from the mailbox simulator,
	//   those originating from your account-level suppression list (if enabled), and
	//   those for emails addressed to more than one recipient.
	//
	//   - TRANSIENT_BOUNCE – Transient bounces - i.e. feedback received for delivery
	//   failures excluding issues with non-existent mailboxes. Excludes bounces from the
	//   mailbox simulator, and those for emails addressed to more than one recipient.
	//
	//   - OPEN – Unique open events for emails including open trackers. Excludes opens
	//   for emails addressed to more than one recipient.
	//
	//   - CLICK – Unique click events for emails including wrapped links. Excludes
	//   clicks for emails addressed to more than one recipient.
	//
	//   - DELIVERY – Successful deliveries for email sending attempts. Excludes
	//   deliveries to the mailbox simulator and for emails addressed to more than one
	//   recipient.
	//
	//   - DELIVERY_OPEN – Successful deliveries for email sending attempts. Excludes
	//   deliveries to the mailbox simulator, for emails addressed to more than one
	//   recipient, and emails without open trackers.
	//
	//   - DELIVERY_CLICK – Successful deliveries for email sending attempts. Excludes
	//   deliveries to the mailbox simulator, for emails addressed to more than one
	//   recipient, and emails without click trackers.
	//
	//   - DELIVERY_COMPLAINT – Successful deliveries for email sending attempts.
	//   Excludes deliveries to the mailbox simulator, for emails addressed to more than
	//   one recipient, and emails addressed to recipients hosted by ISPs with which
	//   Amazon SES does not have a feedback loop agreement.
	//
	// This member is required.
	Metric Metric

	// The query namespace - e.g. VDM
	//
	// This member is required.
	Namespace MetricNamespace

	// Represents the start date for the query interval.
	//
	// This member is required.
	StartDate *time.Time

	// An object that contains mapping between MetricDimensionName and
	// MetricDimensionValue to filter metrics by.
	Dimensions map[string]string

	noSmithyDocumentSerde
}

// An object that contains information about a blacklisting event that impacts one
// of the dedicated IP addresses that is associated with your account.
type BlacklistEntry struct {

	// Additional information about the blacklisting event, as provided by the
	// blacklist maintainer.
	Description *string

	// The time when the blacklisting event occurred.
	ListingTime *time.Time

	// The name of the blacklist that the IP address appears on.
	RblName *string

	noSmithyDocumentSerde
}

// Represents the body of the email message.
type Body struct {

	// An object that represents the version of the message that is displayed in email
	// clients that support HTML. HTML messages can include formatted text, hyperlinks,
	// images, and more.
	Html *Content

	// An object that represents the version of the message that is displayed in email
	// clients that don't support HTML, or clients where the recipient has disabled
	// HTML rendering.
	Text *Content

	noSmithyDocumentSerde
}

// Information about a Bounce event.
type Bounce struct {

	// The subtype of the bounce, as determined by SES.
	BounceSubType *string

	// The type of the bounce, as determined by SES. Can be one of UNDETERMINED ,
	// TRANSIENT , or PERMANENT
	BounceType BounceType

	// The status code issued by the reporting Message Transfer Authority (MTA). This
	// field only appears if a delivery status notification (DSN) was attached to the
	// bounce and the Diagnostic-Code was provided in the DSN.
	DiagnosticCode *string

	noSmithyDocumentSerde
}

// An object that contains the body of the message. You can specify a template
// message.
type BulkEmailContent struct {

	// The template to use for the bulk email message.
	Template *Template

	noSmithyDocumentSerde
}

type BulkEmailEntry struct {

	// Represents the destination of the message, consisting of To:, CC:, and BCC:
	// fields.
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531]. For this
	// reason, the local part of a destination email address (the part of the email
	// address that precedes the @ sign) may only contain [7-bit ASCII characters]. If the domain part of an
	// address (the part after the @ sign) contains non-ASCII characters, they must be
	// encoded using Punycode, as described in [RFC3492].
	//
	// [RFC3492]: https://tools.ietf.org/html/rfc3492.html
	// [RFC6531]: https://tools.ietf.org/html/rfc6531
	// [7-bit ASCII characters]: https://en.wikipedia.org/wiki/Email_address#Local-part
	//
	// This member is required.
	Destination *Destination

	// The ReplacementEmailContent associated with a BulkEmailEntry .
	ReplacementEmailContent *ReplacementEmailContent

	// The list of message headers associated with the BulkEmailEntry data type.
	//
	//   - Headers Not Present in BulkEmailEntry : If a header is specified in [Template]Template
	//   but not in BulkEmailEntry , the header from Template will be added to the
	//   outgoing email.
	//
	//   - Headers Present in BulkEmailEntry : If a header is specified in
	//   BulkEmailEntry , it takes precedence over any header of the same name
	//   specified in [Template]Template :
	//
	//   - If the header is also defined within Template , the value from
	//   BulkEmailEntry will replace the header's value in the email.
	//
	//   - If the header is not defined within Template , it will simply be added to
	//   the email as specified in BulkEmailEntry .
	//
	// [Template]: https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_Template.html
	ReplacementHeaders []MessageHeader

	// A list of tags, in the form of name/value pairs, to apply to an email that you
	// send using the SendBulkTemplatedEmail operation. Tags correspond to
	// characteristics of the email that you define, so that you can publish email
	// sending events.
	ReplacementTags []MessageTag

	noSmithyDocumentSerde
}

// The result of the SendBulkEmail operation of each specified BulkEmailEntry .
type BulkEmailEntryResult struct {

	// A description of an error that prevented a message being sent using the
	// SendBulkTemplatedEmail operation.
	Error *string

	// The unique message identifier returned from the SendBulkTemplatedEmail
	// operation.
	MessageId *string

	// The status of a message sent using the SendBulkTemplatedEmail operation.
	//
	// Possible values for this parameter include:
	//
	//   - SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to
	//   the recipients.
	//
	//   - MESSAGE_REJECTED: The message was rejected because it contained a virus.
	//
	//   - MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain was not
	//   verified.
	//
	//   - CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does
	//   not exist.
	//
	//   - TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
	//
	//   - ACCOUNT_SUSPENDED: Your account has been shut down because of issues
	//   related to your email sending practices.
	//
	//   - ACCOUNT_THROTTLED: The number of emails you can send has been reduced
	//   because your account has exceeded its allocated sending limit.
	//
	//   - ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum
	//   number of emails you can send from your account in a 24-hour period.
	//
	//   - INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an
	//   IP pool that does not exist.
	//
	//   - ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was
	//   disabled using the [UpdateAccountSendingEnabled]operation.
	//
	//   - CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set
	//   was disabled using the [UpdateConfigurationSetSendingEnabled]operation.
	//
	//   - INVALID_PARAMETER_VALUE: One or more of the parameters you specified when
	//   calling this operation was invalid. See the error message for additional
	//   information.
	//
	//   - TRANSIENT_FAILURE: Amazon SES was unable to process your request because of
	//   a temporary issue.
	//
	//   - FAILED: Amazon SES was unable to process your request. See the error
	//   message for additional information.
	//
	// [UpdateAccountSendingEnabled]: https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html
	// [UpdateConfigurationSetSendingEnabled]: https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html
	Status BulkEmailStatus

	noSmithyDocumentSerde
}

// An object that defines an Amazon CloudWatch destination for email events. You
// can use Amazon CloudWatch to monitor and gain insights on your email sending
// metrics.
type CloudWatchDestination struct {

	// An array of objects that define the dimensions to use when you send email
	// events to Amazon CloudWatch.
	//
	// This member is required.
	DimensionConfigurations []CloudWatchDimensionConfiguration

	noSmithyDocumentSerde
}

// An object that defines the dimension configuration to use when you send email
// events to Amazon CloudWatch.
type CloudWatchDimensionConfiguration struct {

	// The default value of the dimension that is published to Amazon CloudWatch if
	// you don't provide the value of the dimension when you send an email. This value
	// has to meet the following criteria:
	//
	//   - Can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_),
	//   or dashes (-), at signs (@), and periods (.).
	//
	//   - It can contain no more than 256 characters.
	//
	// This member is required.
	DefaultDimensionValue *string

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name has to meet the following criteria:
	//
	//   - It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//   (_), or dashes (-).
	//
	//   - It can contain no more than 256 characters.
	//
	// This member is required.
	DimensionName *string

	// The location where the Amazon SES API v2 finds the value of a dimension to
	// publish to Amazon CloudWatch. To use the message tags that you specify using an
	// X-SES-MESSAGE-TAGS header or a parameter to the SendEmail or SendRawEmail API,
	// choose messageTag . To use your own email headers, choose emailHeader . To use
	// link tags, choose linkTags .
	//
	// This member is required.
	DimensionValueSource DimensionValueSource

	noSmithyDocumentSerde
}

// Information about a Complaint event.
type Complaint struct {

	//  The value of the Feedback-Type field from the feedback report received from
	// the ISP.
	ComplaintFeedbackType *string

	//  Can either be null or OnAccountSuppressionList . If the value is
	// OnAccountSuppressionList , SES accepted the message, but didn't attempt to send
	// it because it was on the account-level suppression list.
	ComplaintSubType *string

	noSmithyDocumentSerde
}

// A contact is the end-user who is receiving the email.
type Contact struct {

	// The contact's email address.
	EmailAddress *string

	// A timestamp noting the last time the contact's information was updated.
	LastUpdatedTimestamp *time.Time

	// The default topic preferences applied to the contact.
	TopicDefaultPreferences []TopicPreference

	// The contact's preference for being opted-in to or opted-out of a topic.
	TopicPreferences []TopicPreference

	// A boolean value status noting if the contact is unsubscribed from all contact
	// list topics.
	UnsubscribeAll bool

	noSmithyDocumentSerde
}

// A list that contains contacts that have subscribed to a particular topic or
// topics.
type ContactList struct {

	// The name of the contact list.
	ContactListName *string

	// A timestamp noting the last time the contact list was updated.
	LastUpdatedTimestamp *time.Time

	noSmithyDocumentSerde
}

// An object that contains details about the action of a contact list.
type ContactListDestination struct {

	// >The type of action to perform on the addresses. The following are the possible
	// values:
	//
	//   - PUT: add the addresses to the contact list. If the record already exists,
	//   it will override it with the new value.
	//
	//   - DELETE: remove the addresses from the contact list.
	//
	// This member is required.
	ContactListImportAction ContactListImportAction

	// The name of the contact list.
	//
	// This member is required.
	ContactListName *string

	noSmithyDocumentSerde
}

// An object that represents the content of the email, and optionally a character
// set specification.
type Content struct {

	// The content of the message itself.
	//
	// This member is required.
	Data *string

	// The character set for the content. Because of the constraints of the SMTP
	// protocol, Amazon SES uses 7-bit ASCII by default. If the text includes
	// characters outside of the ASCII range, you have to specify a character set. For
	// example, you could specify UTF-8 , ISO-8859-1 , or Shift_JIS .
	Charset *string

	noSmithyDocumentSerde
}

// Contains information about a custom verification email template.
type CustomVerificationEmailTemplateMetadata struct {

	// The URL that the recipient of the verification email is sent to if his or her
	// address is not successfully verified.
	FailureRedirectionURL *string

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string

	// The URL that the recipient of the verification email is sent to if his or her
	// address is successfully verified.
	SuccessRedirectionURL *string

	// The name of the custom verification email template.
	TemplateName *string

	// The subject line of the custom verification email.
	TemplateSubject *string

	noSmithyDocumentSerde
}

// An object that contains information about the volume of email sent on each day
// of the analysis period.
type DailyVolume struct {

	// An object that contains inbox placement metrics for a specified day in the
	// analysis period, broken out by the recipient's email provider.
	DomainIspPlacements []DomainIspPlacement

	// The date that the DailyVolume metrics apply to, in Unix time.
	StartDate *time.Time

	// An object that contains inbox placement metrics for a specific day in the
	// analysis period.
	VolumeStatistics *VolumeStatistics

	noSmithyDocumentSerde
}

// An object containing additional settings for your VDM configuration as
// applicable to the Dashboard.
type DashboardAttributes struct {

	// Specifies the status of your VDM engagement metrics collection. Can be one of
	// the following:
	//
	//   - ENABLED – Amazon SES enables engagement metrics for your account.
	//
	//   - DISABLED – Amazon SES disables engagement metrics for your account.
	EngagementMetrics FeatureStatus

	noSmithyDocumentSerde
}

// An object containing additional settings for your VDM configuration as
// applicable to the Dashboard.
type DashboardOptions struct {

	// Specifies the status of your VDM engagement metrics collection. Can be one of
	// the following:
	//
	//   - ENABLED – Amazon SES enables engagement metrics for the configuration set.
	//
	//   - DISABLED – Amazon SES disables engagement metrics for the configuration set.
	EngagementMetrics FeatureStatus

	noSmithyDocumentSerde
}

// Contains information about a dedicated IP address that is associated with your
// Amazon SES account.
//
// To learn more about requesting dedicated IP addresses, see [Requesting and Relinquishing Dedicated IP Addresses] in the Amazon SES
// Developer Guide.
//
// [Requesting and Relinquishing Dedicated IP Addresses]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/dedicated-ip-case.html
type DedicatedIp struct {

	// An IPv4 address.
	//
	// This member is required.
	Ip *string

	// Indicates how complete the dedicated IP warm-up process is. When this value
	// equals 1, the address has completed the warm-up process and is ready for use.
	//
	// This member is required.
	WarmupPercentage *int32

	// The warm-up status of a dedicated IP address. The status can have one of the
	// following values:
	//
	//   - IN_PROGRESS – The IP address isn't ready to use because the dedicated IP
	//   warm-up process is ongoing.
	//
	//   - DONE – The dedicated IP warm-up process is complete, and the IP address is
	//   ready to use.
	//
	// This member is required.
	WarmupStatus WarmupStatus

	// The name of the dedicated IP pool that the IP address is associated with.
	PoolName *string

	noSmithyDocumentSerde
}

// Contains information about a dedicated IP pool.
type DedicatedIpPool struct {

	// The name of the dedicated IP pool.
	//
	// This member is required.
	PoolName *string

	// The type of the dedicated IP pool.
	//
	//   - STANDARD – A dedicated IP pool where you can control which IPs are part of
	//   the pool.
	//
	//   - MANAGED – A dedicated IP pool where the reputation and number of IPs are
	//   automatically managed by Amazon SES.
	//
	// This member is required.
	ScalingMode ScalingMode

	noSmithyDocumentSerde
}

// An object that contains metadata related to a predictive inbox placement test.
type DeliverabilityTestReport struct {

	// The date and time when the predictive inbox placement test was created.
	CreateDate *time.Time

	// The status of the predictive inbox placement test. If the status is IN_PROGRESS
	// , then the predictive inbox placement test is currently running. Predictive
	// inbox placement tests are usually complete within 24 hours of creating the test.
	// If the status is COMPLETE , then the test is finished, and you can use the
	// GetDeliverabilityTestReport to view the results of the test.
	DeliverabilityTestStatus DeliverabilityTestStatus

	// The sender address that you specified for the predictive inbox placement test.
	FromEmailAddress *string

	// A unique string that identifies the predictive inbox placement test.
	ReportId *string

	// A name that helps you identify a predictive inbox placement test report.
	ReportName *string

	// The subject line for an email that you submitted in a predictive inbox
	// placement test.
	Subject *string

	noSmithyDocumentSerde
}

// Used to associate a configuration set with a dedicated IP pool.
type DeliveryOptions struct {

	// The maximum amount of time, in seconds, that Amazon SES API v2 will attempt
	// delivery of email. If specified, the value must greater than or equal to 300
	// seconds (5 minutes) and less than or equal to 50400 seconds (840 minutes).
	MaxDeliverySeconds *int64

	// The name of the dedicated IP pool to associate with the configuration set.
	SendingPoolName *string

	// Specifies whether messages that use the configuration set are required to use
	// Transport Layer Security (TLS). If the value is Require , messages are only
	// delivered if a TLS connection can be established. If the value is Optional ,
	// messages can be delivered in plain text if a TLS connection can't be
	// established.
	TlsPolicy TlsPolicy

	noSmithyDocumentSerde
}

// An object that describes the recipients for an email.
//
// Amazon SES does not support the SMTPUTF8 extension, as described in [RFC6531]. For this
// reason, the local part of a destination email address (the part of the email
// address that precedes the @ sign) may only contain [7-bit ASCII characters]. If the domain part of an
// address (the part after the @ sign) contains non-ASCII characters, they must be
// encoded using Punycode, as described in [RFC3492].
//
// [RFC3492]: https://tools.ietf.org/html/rfc3492.html
// [RFC6531]: https://tools.ietf.org/html/rfc6531
// [7-bit ASCII characters]: https://en.wikipedia.org/wiki/Email_address#Local-part
type Destination struct {

	// An array that contains the email addresses of the "BCC" (blind carbon copy)
	// recipients for the email.
	BccAddresses []string

	// An array that contains the email addresses of the "CC" (carbon copy) recipients
	// for the email.
	CcAddresses []string

	// An array that contains the email addresses of the "To" recipients for the email.
	ToAddresses []string

	noSmithyDocumentSerde
}

// An object that contains configuration details of multi-region endpoint
// (global-endpoint).
type Details struct {

	// A list of route configuration details. Must contain exactly one route
	// configuration.
	//
	// This member is required.
	RoutesDetails []RouteDetails

	noSmithyDocumentSerde
}

// An object that contains information about the DKIM authentication status for an
// email identity.
//
// Amazon SES determines the authentication status by searching for specific
// records in the DNS configuration for the domain. If you used [Easy DKIM]to set up DKIM
// authentication, Amazon SES tries to find three unique CNAME records in the DNS
// configuration for your domain. If you provided a public key to perform DKIM
// authentication, Amazon SES tries to find a TXT record that uses the selector
// that you specified. The value of the TXT record must be a public key that's
// paired with the private key that you specified in the process of creating the
// identity
//
// [Easy DKIM]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html
type DkimAttributes struct {

	// [Easy DKIM] The key length of the DKIM key pair in use.
	CurrentSigningKeyLength DkimSigningKeyLength

	// [Easy DKIM] The last time a key pair was generated for this identity.
	LastKeyGenerationTimestamp *time.Time

	// [Easy DKIM] The key length of the future DKIM key pair to be generated. This
	// can be changed at most once per day.
	NextSigningKeyLength DkimSigningKeyLength

	// A string that indicates how DKIM was configured for the identity. These are the
	// possible values:
	//
	//   - AWS_SES – Indicates that DKIM was configured for the identity by using [Easy DKIM].
	//
	//   - EXTERNAL – Indicates that DKIM was configured for the identity by using
	//   Bring Your Own DKIM (BYODKIM).
	//
	//   - AWS_SES_AF_SOUTH_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Africa (Cape Town)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_NORTH_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Europe (Stockholm)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_SOUTH_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Asia Pacific (Mumbai)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_WEST_3 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Europe (Paris) region
	//   using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_WEST_2 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Europe (London) region
	//   using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_SOUTH_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Europe (Milan) region
	//   using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_WEST_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Europe (Ireland) region
	//   using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_NORTHEAST_3 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Asia Pacific (Osaka)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_NORTHEAST_2 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Asia Pacific (Seoul)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_ME_SOUTH_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in Middle East (Bahrain)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_NORTHEAST_1 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Asia Pacific (Tokyo)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_IL_CENTRAL_1 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Israel (Tel Aviv)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_SA_EAST_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in South America (São
	//   Paulo) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_CA_CENTRAL_1 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Canada (Central)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_SOUTHEAST_1 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Asia Pacific
	//   (Singapore) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_SOUTHEAST_2 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Asia Pacific
	//   (Sydney) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_SOUTHEAST_3 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Asia Pacific
	//   (Jakarta) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_CENTRAL_1 – Indicates that DKIM was configured for the identity
	//   by replicating signing attributes from a parent identity in Europe (Frankfurt)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_US_EAST_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in US East (N. Virginia)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_US_EAST_2 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in US East (Ohio) region
	//   using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_US_WEST_1 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in US West (N. California)
	//   region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_US_WEST_2 – Indicates that DKIM was configured for the identity by
	//   replicating signing attributes from a parent identity in US West (Oregon) region
	//   using Deterministic Easy-DKIM (DEED).
	//
	// [Easy DKIM]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html
	SigningAttributesOrigin DkimSigningAttributesOrigin

	// If the value is true , then the messages that you send from the identity are
	// signed using DKIM. If the value is false , then the messages that you send from
	// the identity aren't DKIM-signed.
	SigningEnabled bool

	// Describes whether or not Amazon SES has successfully located the DKIM records
	// in the DNS records for the domain. The status can be one of the following:
	//
	//   - PENDING – The verification process was initiated, but Amazon SES hasn't yet
	//   detected the DKIM records in the DNS configuration for the domain.
	//
	//   - SUCCESS – The verification process completed successfully.
	//
	//   - FAILED – The verification process failed. This typically occurs when Amazon
	//   SES fails to find the DKIM records in the DNS configuration of the domain.
	//
	//   - TEMPORARY_FAILURE – A temporary issue is preventing Amazon SES from
	//   determining the DKIM authentication status of the domain.
	//
	//   - NOT_STARTED – The DKIM verification process hasn't been initiated for the
	//   domain.
	Status DkimStatus

	// If you used [Easy DKIM] to configure DKIM authentication for the domain, then this object
	// contains a set of unique strings that you use to create a set of CNAME records
	// that you add to the DNS configuration for your domain. When Amazon SES detects
	// these records in the DNS configuration for your domain, the DKIM authentication
	// process is complete.
	//
	// If you configured DKIM authentication for the domain by providing your own
	// public-private key pair, then this object contains the selector for the public
	// key.
	//
	// Regardless of the DKIM authentication method you use, Amazon SES searches for
	// the appropriate records in the DNS configuration of the domain for up to 72
	// hours.
	//
	// [Easy DKIM]: https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html
	Tokens []string

	noSmithyDocumentSerde
}

// An object that contains configuration for Bring Your Own DKIM (BYODKIM), or,
// for Easy DKIM
type DkimSigningAttributes struct {

	// The attribute to use for configuring DKIM for the identity depends on the
	// operation:
	//
	//   - For PutEmailIdentityDkimSigningAttributes :
	//
	//   - None of the values are allowed - use the [SigningAttributesOrigin]SigningAttributesOrigin parameter
	//   instead
	//
	//   - For CreateEmailIdentity when replicating a parent identity's DKIM
	//   configuration:
	//
	//   - Allowed values: All values except AWS_SES and EXTERNAL
	//
	//   - AWS_SES – Configure DKIM for the identity by using Easy DKIM.
	//
	//   - EXTERNAL – Configure DKIM for the identity by using Bring Your Own DKIM
	//   (BYODKIM).
	//
	//   - AWS_SES_AF_SOUTH_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Africa (Cape Town) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_EU_NORTH_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Europe (Stockholm) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_AP_SOUTH_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Asia Pacific (Mumbai) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_EU_WEST_3 – Configure DKIM for the identity by replicating from a
	//   parent identity in Europe (Paris) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_WEST_2 – Configure DKIM for the identity by replicating from a
	//   parent identity in Europe (London) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_SOUTH_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Europe (Milan) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_EU_WEST_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Europe (Ireland) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_NORTHEAST_3 – Configure DKIM for the identity by replicating from
	//   a parent identity in Asia Pacific (Osaka) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_AP_NORTHEAST_2 – Configure DKIM for the identity by replicating from
	//   a parent identity in Asia Pacific (Seoul) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_ME_SOUTH_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Middle East (Bahrain) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_AP_NORTHEAST_1 – Configure DKIM for the identity by replicating from
	//   a parent identity in Asia Pacific (Tokyo) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_IL_CENTRAL_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Israel (Tel Aviv) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_SA_EAST_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in South America (São Paulo) region using Deterministic
	//   Easy-DKIM (DEED).
	//
	//   - AWS_SES_CA_CENTRAL_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Canada (Central) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_SOUTHEAST_1 – Configure DKIM for the identity by replicating from
	//   a parent identity in Asia Pacific (Singapore) region using Deterministic
	//   Easy-DKIM (DEED).
	//
	//   - AWS_SES_AP_SOUTHEAST_2 – Configure DKIM for the identity by replicating from
	//   a parent identity in Asia Pacific (Sydney) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_AP_SOUTHEAST_3 – Configure DKIM for the identity by replicating from
	//   a parent identity in Asia Pacific (Jakarta) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_EU_CENTRAL_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in Europe (Frankfurt) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_US_EAST_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in US East (N. Virginia) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_US_EAST_2 – Configure DKIM for the identity by replicating from a
	//   parent identity in US East (Ohio) region using Deterministic Easy-DKIM (DEED).
	//
	//   - AWS_SES_US_WEST_1 – Configure DKIM for the identity by replicating from a
	//   parent identity in US West (N. California) region using Deterministic Easy-DKIM
	//   (DEED).
	//
	//   - AWS_SES_US_WEST_2 – Configure DKIM for the identity by replicating from a
	//   parent identity in US West (Oregon) region using Deterministic Easy-DKIM (DEED).
	//
	//
	// [SigningAttributesOrigin]: https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_PutEmailIdentityDkimSigningAttributes.html#SES-PutEmailIdentityDkimSigningAttributes-request-SigningAttributesOrigin
	DomainSigningAttributesOrigin DkimSigningAttributesOrigin

	// [Bring Your Own DKIM] A private key that's used to generate a DKIM signature.
	//
	// The private key must use 1024 or 2048-bit RSA encryption, and must be encoded
	// using base64 encoding.
	DomainSigningPrivateKey *string

	// [Bring Your Own DKIM] A string that's used to identify a public key in the DNS
	// configuration for a domain.
	DomainSigningSelector *string

	// [Easy DKIM] The key length of the future DKIM key pair to be generated. This
	// can be changed at most once per day.
	NextSigningKeyLength DkimSigningKeyLength

	noSmithyDocumentSerde
}

// An object that contains the deliverability data for a specific campaign. This
// data is available for a campaign only if the campaign sent email by using a
// domain that the Deliverability dashboard is enabled for (
// PutDeliverabilityDashboardOption operation).
type DomainDeliverabilityCampaign struct {

	// The unique identifier for the campaign. The Deliverability dashboard
	// automatically generates and assigns this identifier to a campaign.
	CampaignId *string

	// The percentage of email messages that were deleted by recipients, without being
	// opened first. Due to technical limitations, this value only includes recipients
	// who opened the message by using an email client that supports images.
	DeleteRate *float64

	// The major email providers who handled the email message.
	Esps []string

	// The first time when the email message was delivered to any recipient's inbox.
	// This value can help you determine how long it took for a campaign to deliver an
	// email message.
	FirstSeenDateTime *time.Time

	// The verified email address that the email message was sent from.
	FromAddress *string

	// The URL of an image that contains a snapshot of the email message that was sent.
	ImageUrl *string

	// The number of email messages that were delivered to recipients’ inboxes.
	InboxCount *int64

	// The last time when the email message was delivered to any recipient's inbox.
	// This value can help you determine how long it took for a campaign to deliver an
	// email message.
	LastSeenDateTime *time.Time

	// The projected number of recipients that the email message was sent to.
	ProjectedVolume *int64

	// The percentage of email messages that were opened and then deleted by
	// recipients. Due to technical limitations, this value only includes recipients
	// who opened the message by using an email client that supports images.
	ReadDeleteRate *float64

	// The percentage of email messages that were opened by recipients. Due to
	// technical limitations, this value only includes recipients who opened the
	// message by using an email client that supports images.
	ReadRate *float64

	// The IP addresses that were used to send the email message.
	SendingIps []string

	// The number of email messages that were delivered to recipients' spam or junk
	// mail folders.
	SpamCount *int64

	// The subject line, or title, of the email message.
	Subject *string

	noSmithyDocumentSerde
}

// An object that contains information about the Deliverability dashboard
// subscription for a verified domain that you use to send email and currently has
// an active Deliverability dashboard subscription. If a Deliverability dashboard
// subscription is active for a domain, you gain access to reputation, inbox
// placement, and other metrics for the domain.
type DomainDeliverabilityTrackingOption struct {

	// A verified domain that’s associated with your Amazon Web Services account and
	// currently has an active Deliverability dashboard subscription.
	Domain *string

	// An object that contains information about the inbox placement data settings for
	// the domain.
	InboxPlacementTrackingOption *InboxPlacementTrackingOption

	// The date when you enabled the Deliverability dashboard for the domain.
	SubscriptionStartDate *time.Time

	noSmithyDocumentSerde
}

// An object that contains inbox placement data for email sent from one of your
// email domains to a specific email provider.
type DomainIspPlacement struct {

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxPercentage *float64

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxRawCount *int64

	// The name of the email provider that the inbox placement data applies to.
	IspName *string

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamPercentage *float64

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamRawCount *int64

	noSmithyDocumentSerde
}

// An object that defines the entire content of the email, including the message
// headers and the body content. You can create a simple email message, in which
// you specify the subject and the text and HTML versions of the message body. You
// can also create raw messages, in which you specify a complete MIME-formatted
// message. Raw messages can include attachments and custom headers.
type EmailContent struct {

	// The raw email message. The message has to meet the following criteria:
	//
	//   - The message has to contain a header and a body, separated by one blank line.
	//
	//   - All of the required header fields must be present in the message.
	//
	//   - Each part of a multipart MIME message must be formatted properly.
	//
	//   - If you include attachments, they must be in a file format that the Amazon
	//   SES API v2 supports.
	//
	//   - The raw data of the message needs to base64-encoded if you are accessing
	//   Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES
	//   using an Amazon Web Services SDK, the SDK takes care of the base 64-encoding for
	//   you.
	//
	//   - If any of the MIME parts in your message contain content that is outside of
	//   the 7-bit ASCII character range, you should encode that content to ensure that
	//   recipients' email clients render the message properly.
	//
	//   - The length of any single line of text in the message can't exceed 1,000
	//   characters. This restriction is defined in [RFC 5321].
	//
	// [RFC 5321]: https://tools.ietf.org/html/rfc5321
	Raw *RawMessage

	// The simple email message. The message consists of a subject and a message body.
	Simple *Message

	// The template to use for the email message.
	Template *Template

	noSmithyDocumentSerde
}

// An email's insights contain metadata and delivery information about a specific
// email.
type EmailInsights struct {

	// The recipient of the email.
	Destination *string

	// A list of events associated with the sent email.
	Events []InsightsEvent

	// The recipient's ISP (e.g., Gmail , Yahoo , etc.).
	Isp *string

	noSmithyDocumentSerde
}

// The content of the email, composed of a subject line, an HTML part, and a
// text-only part.
type EmailTemplateContent struct {

	// The HTML body of the email.
	Html *string

	// The subject line of the email.
	Subject *string

	// The email body that will be visible to recipients whose email clients do not
	// display HTML.
	Text *string

	noSmithyDocumentSerde
}

// Contains information about an email template.
type EmailTemplateMetadata struct {

	// The time and date the template was created.
	CreatedTimestamp *time.Time

	// The name of the template.
	TemplateName *string

	noSmithyDocumentSerde
}

// An object that defines an Amazon EventBridge destination for email events. You
// can use Amazon EventBridge to send notifications when certain email events
// occur.
type EventBridgeDestination struct {

	// The Amazon Resource Name (ARN) of the Amazon EventBridge bus to publish email
	// events to. Only the default bus is supported.
	//
	// This member is required.
	EventBusArn *string

	noSmithyDocumentSerde
}

// In the Amazon SES API v2, events include message sends, deliveries, opens,
// clicks, bounces, complaints and delivery delays. Event destinations are places
// that you can send information about these events to. For example, you can send
// event data to Amazon SNS to receive notifications when you receive bounces or
// complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon
// S3 for long-term storage.
type EventDestination struct {

	// The types of events that Amazon SES sends to the specified event destinations.
	//
	//   - SEND - The send request was successful and SES will attempt to deliver the
	//   message to the recipient’s mail server. (If account-level or global suppression
	//   is being used, SES will still count it as a send, but delivery is suppressed.)
	//
	//   - REJECT - SES accepted the email, but determined that it contained a virus
	//   and didn’t attempt to deliver it to the recipient’s mail server.
	//
	//   - BOUNCE - (Hard bounce) The recipient's mail server permanently rejected the
	//   email. (Soft bounces are only included when SES fails to deliver the email after
	//   retrying for a period of time.)
	//
	//   - COMPLAINT - The email was successfully delivered to the recipient’s mail
	//   server, but the recipient marked it as spam.
	//
	//   - DELIVERY - SES successfully delivered the email to the recipient's mail
	//   server.
	//
	//   - OPEN - The recipient received the message and opened it in their email
	//   client.
	//
	//   - CLICK - The recipient clicked one or more links in the email.
	//
	//   - RENDERING_FAILURE - The email wasn't sent because of a template rendering
	//   issue. This event type can occur when template data is missing, or when there is
	//   a mismatch between template parameters and data. (This event type only occurs
	//   when you send email using the [SendTemplatedEmail]SendTemplatedEmail or [SendBulkTemplatedEmail]SendBulkTemplatedEmail API
	//   operations.)
	//
	//   - DELIVERY_DELAY - The email couldn't be delivered to the recipient’s mail
	//   server because a temporary issue occurred. Delivery delays can occur, for
	//   example, when the recipient's inbox is full, or when the receiving email server
	//   experiences a transient issue.
	//
	//   - SUBSCRIPTION - The email was successfully delivered, but the recipient
	//   updated their subscription preferences by clicking on an unsubscribe link as
	//   part of your [subscription management].
	//
	// [SendTemplatedEmail]: https://docs.aws.amazon.com/ses/latest/APIReference/API_SendTemplatedEmail.html
	// [subscription management]: https://docs.aws.amazon.com/ses/latest/dg/sending-email-subscription-management.html
	// [SendBulkTemplatedEmail]: https://docs.aws.amazon.com/ses/latest/APIReference/API_SendBulkTemplatedEmail.html
	//
	// This member is required.
	MatchingEventTypes []EventType

	// A name that identifies the event destination.
	//
	// This member is required.
	Name *string

	// An object that defines an Amazon CloudWatch destination for email events. You
	// can use Amazon CloudWatch to monitor and gain insights on your email sending
	// metrics.
	CloudWatchDestination *CloudWatchDestination

	// If true , the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this
	// EventDestinationDefinition .
	//
	// If false , the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled bool

	// An object that defines an Amazon EventBridge destination for email events. You
	// can use Amazon EventBridge to send notifications when certain email events
	// occur.
	EventBridgeDestination *EventBridgeDestination

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination

	// An object that defines an Amazon Pinpoint project destination for email events.
	// You can send email event data to a Amazon Pinpoint project to view metrics using
	// the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For
	// more information, see [Transactional Messaging Charts]in the Amazon Pinpoint User Guide.
	//
	// [Transactional Messaging Charts]: https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html
	PinpointDestination *PinpointDestination

	// An object that defines an Amazon SNS destination for email events. You can use
	// Amazon SNS to send notifications when certain email events occur.
	SnsDestination *SnsDestination

	noSmithyDocumentSerde
}

// An object that defines the event destination. Specifically, it defines which
// services receive events from emails sent using the configuration set that the
// event destination is associated with. Also defines the types of events that are
// sent to the event destination.
type EventDestinationDefinition struct {

	// An object that defines an Amazon CloudWatch destination for email events. You
	// can use Amazon CloudWatch to monitor and gain insights on your email sending
	// metrics.
	CloudWatchDestination *CloudWatchDestination

	// If true , the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this
	// EventDestinationDefinition .
	//
	// If false , the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled bool

	// An object that defines an Amazon EventBridge destination for email events. You
	// can use Amazon EventBridge to send notifications when certain email events
	// occur.
	EventBridgeDestination *EventBridgeDestination

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination

	// An array that specifies which events the Amazon SES API v2 should send to the
	// destinations in this EventDestinationDefinition .
	MatchingEventTypes []EventType

	// An object that defines an Amazon Pinpoint project destination for email events.
	// You can send email event data to a Amazon Pinpoint project to view metrics using
	// the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For
	// more information, see [Transactional Messaging Charts]in the Amazon Pinpoint User Guide.
	//
	// [Transactional Messaging Charts]: https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html
	PinpointDestination *PinpointDestination

	// An object that defines an Amazon SNS destination for email events. You can use
	// Amazon SNS to send notifications when certain email events occur.
	SnsDestination *SnsDestination

	noSmithyDocumentSerde
}

//	Contains a Bounce object if the event type is BOUNCE . Contains a Complaint
//
// object if the event type is COMPLAINT .
type EventDetails struct {

	// Information about a Bounce event.
	Bounce *Bounce

	// Information about a Complaint event.
	Complaint *Complaint

	noSmithyDocumentSerde
}

// An object that contains details about the data source of the export job. It can
// only contain one of MetricsDataSource or MessageInsightsDataSource object.
type ExportDataSource struct {

	// An object that contains filters applied when performing the Message Insights
	// export.
	MessageInsightsDataSource *MessageInsightsDataSource

	// An object that contains details about the data source for the metrics export.
	MetricsDataSource *MetricsDataSource

	noSmithyDocumentSerde
}

// An object that contains details about the destination of the export job.
type ExportDestination struct {

	// The data format of the final export job file, can be one of the following:
	//
	//   - CSV - A comma-separated values file.
	//
	//   - JSON - A Json file.
	//
	// This member is required.
	DataFormat DataFormat

	// An Amazon S3 pre-signed URL that points to the generated export file.
	S3Url *string

	noSmithyDocumentSerde
}

// A summary of the export job.
type ExportJobSummary struct {

	// The timestamp of when the export job was completed.
	CompletedTimestamp *time.Time

	// The timestamp of when the export job was created.
	CreatedTimestamp *time.Time

	// The source type of the export job.
	ExportSourceType ExportSourceType

	// The export job ID.
	JobId *string

	// The status of the export job.
	JobStatus JobStatus

	noSmithyDocumentSerde
}

// An object that contains a mapping between a Metric and MetricAggregation .
type ExportMetric struct {

	// The aggregation to apply to a metric, can be one of the following:
	//
	//   - VOLUME - The volume of events for this metric.
	//
	//   - RATE - The rate for this metric relative to the SEND metric volume.
	Aggregation MetricAggregation

	// The metric to export, can be one of the following:
	//
	//   - SEND - Emails sent eligible for tracking in the VDM dashboard. This excludes
	//   emails sent to the mailbox simulator and emails addressed to more than one
	//   recipient.
	//
	//   - COMPLAINT - Complaints received for your account. This excludes complaints
	//   from the mailbox simulator, those originating from your account-level
	//   suppression list (if enabled), and those for emails addressed to more than one
	//   recipient
	//
	//   - PERMANENT_BOUNCE - Permanent bounces - i.e., feedback received for emails
	//   sent to non-existent mailboxes. Excludes bounces from the mailbox simulator,
	//   those originating from your account-level suppression list (if enabled), and
	//   those for emails addressed to more than one recipient.
	//
	//   - TRANSIENT_BOUNCE - Transient bounces - i.e., feedback received for delivery
	//   failures excluding issues with non-existent mailboxes. Excludes bounces from the
	//   mailbox simulator, and those for emails addressed to more than one recipient.
	//
	//   - OPEN - Unique open events for emails including open trackers. Excludes opens
	//   for emails addressed to more than one recipient.
	//
	//   - CLICK - Unique click events for emails including wrapped links. Excludes
	//   clicks for emails addressed to more than one recipient.
	//
	//   - DELIVERY - Successful deliveries for email sending attempts. Excludes
	//   deliveries to the mailbox simulator and for emails addressed to more than one
	//   recipient.
	//
	//   - DELIVERY_OPEN - Successful deliveries for email sending attempts. Excludes
	//   deliveries to the mailbox simulator, for emails addressed to more than one
	//   recipient, and emails without open trackers.
	//
	//   - DELIVERY_CLICK - Successful deliveries for email sending attempts. Excludes
	//   deliveries to the mailbox simulator, for emails addressed to more than one
	//   recipient, and emails without click trackers.
	//
	//   - DELIVERY_COMPLAINT - Successful deliveries for email sending attempts.
	//   Excludes deliveries to the mailbox simulator, for emails addressed to more than
	//   one recipient, and emails addressed to recipients hosted by ISPs with which
	//   Amazon SES does not have a feedback loop agreement.
	Name Metric

	noSmithyDocumentSerde
}

// Statistics about the execution of an export job.
type ExportStatistics struct {

	// The number of records that were exported to the final export file.
	//
	// This value might not be available for all export source types
	ExportedRecordsCount *int32

	// The number of records that were processed to generate the final export file.
	ProcessedRecordsCount *int32

	noSmithyDocumentSerde
}

// An object that contains the failure details about a job.
type FailureInfo struct {

	// A message about why the job failed.
	ErrorMessage *string

	// An Amazon S3 pre-signed URL that contains all the failed records and related
	// information.
	FailedRecordsS3Url *string

	noSmithyDocumentSerde
}

// An object containing additional settings for your VDM configuration as
// applicable to the Guardian.
type GuardianAttributes struct {

	// Specifies the status of your VDM optimized shared delivery. Can be one of the
	// following:
	//
	//   - ENABLED – Amazon SES enables optimized shared delivery for your account.
	//
	//   - DISABLED – Amazon SES disables optimized shared delivery for your account.
	OptimizedSharedDelivery FeatureStatus

	noSmithyDocumentSerde
}

// An object containing additional settings for your VDM configuration as
// applicable to the Guardian.
type GuardianOptions struct {

	// Specifies the status of your VDM optimized shared delivery. Can be one of the
	// following:
	//
	//   - ENABLED – Amazon SES enables optimized shared delivery for the configuration
	//   set.
	//
	//   - DISABLED – Amazon SES disables optimized shared delivery for the
	//   configuration set.
	OptimizedSharedDelivery FeatureStatus

	noSmithyDocumentSerde
}

// Information about an email identity.
type IdentityInfo struct {

	// The address or domain of the identity.
	IdentityName *string

	// The email identity type. Note: the MANAGED_DOMAIN type is not supported for
	// email identity types.
	IdentityType IdentityType

	// Indicates whether or not you can send email from the identity.
	//
	// An identity is an email address or domain that you send email from. Before you
	// can send email from an identity, you have to demostrate that you own the
	// identity, and that you authorize Amazon SES to send email from that identity.
	SendingEnabled bool

	// The verification status of the identity. The status can be one of the following:
	//
	//   - PENDING – The verification process was initiated, but Amazon SES hasn't yet
	//   been able to verify the identity.
	//
	//   - SUCCESS – The verification process completed successfully.
	//
	//   - FAILED – The verification process failed.
	//
	//   - TEMPORARY_FAILURE – A temporary issue is preventing Amazon SES from
	//   determining the verification status of the identity.
	//
	//   - NOT_STARTED – The verification process hasn't been initiated for the
	//   identity.
	VerificationStatus VerificationStatus

	noSmithyDocumentSerde
}

// An object that contains details about the data source of the import job.
type ImportDataSource struct {

	// The data format of the import job's data source.
	//
	// This member is required.
	DataFormat DataFormat

	// An Amazon S3 URL in the format s3:///.
	//
	// This member is required.
	S3Url *string

	noSmithyDocumentSerde
}

// An object that contains details about the resource destination the import job
// is going to target.
type ImportDestination struct {

	// An object that contains the action of the import job towards a contact list.
	ContactListDestination *ContactListDestination

	// An object that contains the action of the import job towards suppression list.
	SuppressionListDestination *SuppressionListDestination

	noSmithyDocumentSerde
}

// A summary of the import job.
type ImportJobSummary struct {

	// The date and time when the import job was created.
	CreatedTimestamp *time.Time

	// The number of records that failed processing because of invalid input or other
	// reasons.
	FailedRecordsCount *int32

	// An object that contains details about the resource destination the import job
	// is going to target.
	ImportDestination *ImportDestination

	// A string that represents a job ID.
	JobId *string

	// The status of a job.
	//
	//   - CREATED – Job has just been created.
	//
	//   - PROCESSING – Job is processing.
	//
	//   - ERROR – An error occurred during processing.
	//
	//   - COMPLETED – Job has completed processing successfully.
	JobStatus JobStatus

	// The current number of records processed.
	ProcessedRecordsCount *int32

	noSmithyDocumentSerde
}

// An object that contains information about the inbox placement data settings for
// a verified domain that’s associated with your Amazon Web Services account. This
// data is available only if you enabled the Deliverability dashboard for the
// domain.
type InboxPlacementTrackingOption struct {

	// Specifies whether inbox placement data is being tracked for the domain.
	Global bool

	// An array of strings, one for each major email provider that the inbox placement
	// data applies to.
	TrackedIsps []string

	noSmithyDocumentSerde
}

// An object containing details about a specific event.
type InsightsEvent struct {

	// Details about bounce or complaint events.
	Details *EventDetails

	// The timestamp of the event.
	Timestamp *time.Time

	// The type of event:
	//
	//   - SEND - The send request was successful and SES will attempt to deliver the
	//   message to the recipient’s mail server. (If account-level or global suppression
	//   is being used, SES will still count it as a send, but delivery is suppressed.)
	//
	//   - DELIVERY - SES successfully delivered the email to the recipient's mail
	//   server. Excludes deliveries to the mailbox simulator, and those from emails
	//   addressed to more than one recipient.
	//
	//   - BOUNCE - Feedback received for delivery failures. Additional details about
	//   the bounce are provided in the Details object. Excludes bounces from the
	//   mailbox simulator, and those from emails addressed to more than one recipient.
	//
	//   - COMPLAINT - Complaint received for the email. Additional details about the
	//   complaint are provided in the Details object. This excludes complaints from
	//   the mailbox simulator, those originating from your account-level suppression
	//   list (if enabled), and those from emails addressed to more than one recipient.
	//
	//   - OPEN - Open event for emails including open trackers. Excludes opens for
	//   emails addressed to more than one recipient.
	//
	//   - CLICK - Click event for emails including wrapped links. Excludes clicks for
	//   emails addressed to more than one recipient.
	Type EventType

	noSmithyDocumentSerde
}

// An object that describes how email sent during the predictive inbox placement
// test was handled by a certain email provider.
type IspPlacement struct {

	// The name of the email provider that the inbox placement data applies to.
	IspName *string

	// An object that contains inbox placement metrics for a specific email provider.
	PlacementStatistics *PlacementStatistics

	noSmithyDocumentSerde
}

// An object that defines an Amazon Kinesis Data Firehose destination for email
// events. You can use Amazon Kinesis Data Firehose to stream data to other
// services, such as Amazon S3 and Amazon Redshift.
type KinesisFirehoseDestination struct {

	// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that
	// the Amazon SES API v2 sends email events to.
	//
	// This member is required.
	DeliveryStreamArn *string

	// The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses
	// to send email events to the Amazon Kinesis Data Firehose stream.
	//
	// This member is required.
	IamRoleArn *string

	noSmithyDocumentSerde
}

// A filter that can be applied to a list of contacts.
type ListContactsFilter struct {

	// The status by which you are filtering: OPT_IN or OPT_OUT .
	FilteredStatus SubscriptionStatus

	// Used for filtering by a specific topic preference.
	TopicFilter *TopicFilter

	noSmithyDocumentSerde
}

// An object used to specify a list or topic to which an email belongs, which will
// be used when a contact chooses to unsubscribe.
type ListManagementOptions struct {

	// The name of the contact list.
	//
	// This member is required.
	ContactListName *string

	// The name of the topic.
	TopicName *string

	noSmithyDocumentSerde
}

// A list of attributes that are associated with a MAIL FROM domain.
type MailFromAttributes struct {

	// The action to take if the required MX record can't be found when you send an
	// email. When you set this value to USE_DEFAULT_VALUE , the mail is sent using
	// amazonses.com as the MAIL FROM domain. When you set this value to REJECT_MESSAGE
	// , the Amazon SES API v2 returns a MailFromDomainNotVerified error, and doesn't
	// attempt to deliver the email.
	//
	// These behaviors are taken when the custom MAIL FROM domain configuration is in
	// the Pending , Failed , and TemporaryFailure states.
	//
	// This member is required.
	BehaviorOnMxFailure BehaviorOnMxFailure

	// The name of a domain that an email identity uses as a custom MAIL FROM domain.
	//
	// This member is required.
	MailFromDomain *string

	// The status of the MAIL FROM domain. This status can have the following values:
	//
	//   - PENDING – Amazon SES hasn't started searching for the MX record yet.
	//
	//   - SUCCESS – Amazon SES detected the required MX record for the MAIL FROM
	//   domain.
	//
	//   - FAILED – Amazon SES can't find the required MX record, or the record no
	//   longer exists.
	//
	//   - TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon SES
	//   from determining the status of the MAIL FROM domain.
	//
	// This member is required.
	MailFromDomainStatus MailFromDomainStatus

	noSmithyDocumentSerde
}

// Represents the email message that you're sending. The Message object consists
// of a subject line and a message body.
type Message struct {

	// The body of the message. You can specify an HTML version of the message, a
	// text-only version of the message, or both.
	//
	// This member is required.
	Body *Body

	// The subject line of the email. The subject line can only contain 7-bit ASCII
	// characters. However, you can specify non-ASCII characters in the subject line by
	// using encoded-word syntax, as described in [RFC 2047].
	//
	// [RFC 2047]: https://tools.ietf.org/html/rfc2047
	//
	// This member is required.
	Subject *Content

	// The list of message headers that will be added to the email message.
	Headers []MessageHeader

	noSmithyDocumentSerde
}

// Contains the name and value of a message header that you add to an email.
type MessageHeader struct {

	// The name of the message header. The message header name has to meet the
	// following criteria:
	//
	//   - Can contain any printable ASCII character (33 - 126) except for colon (:).
	//
	//   - Can contain no more than 126 characters.
	//
	// This member is required.
	Name *string

	// The value of the message header. The message header value has to meet the
	// following criteria:
	//
	//   - Can contain any printable ASCII character.
	//
	//   - Can contain no more than 870 characters.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that contains filters applied when performing the Message Insights
// export.
type MessageInsightsDataSource struct {

	// Represents the end date for the export interval as a timestamp. The end date is
	// inclusive.
	//
	// This member is required.
	EndDate *time.Time

	// Represents the start date for the export interval as a timestamp. The start
	// date is inclusive.
	//
	// This member is required.
	StartDate *time.Time

	// Filters for results to be excluded from the export file.
	Exclude *MessageInsightsFilters

	// Filters for results to be included in the export file.
	Include *MessageInsightsFilters

	// The maximum number of results.
	MaxResults *int32

	noSmithyDocumentSerde
}

// An object containing Message Insights filters.
//
// If you specify multiple filters, the filters are joined by AND.
//
// If you specify multiple values for a filter, the values are joined by OR.
// Filter values are case-sensitive.
//
// FromEmailAddress , Destination , and Subject filters support partial match. A
// partial match is performed by using the * wildcard character placed at the
// beginning (suffix match), the end (prefix match) or both ends of the string
// (contains match). In order to match the literal characters * or \ , they must be
// escaped using the \ character. If no wildcard character is present, an exact
// match is performed.
type MessageInsightsFilters struct {

	// The recipient's email address.
	Destination []string

	// The from address used to send the message.
	FromEmailAddress []string

	// The recipient's ISP (e.g., Gmail , Yahoo , etc.).
	Isp []string

	//  The last delivery-related event for the email, where the ordering is as
	// follows: SEND < BOUNCE < DELIVERY < COMPLAINT .
	LastDeliveryEvent []DeliveryEventType

	//  The last engagement-related event for the email, where the ordering is as
	// follows: OPEN < CLICK .
	//
	// Engagement events are only available if [Engagement tracking] is enabled.
	//
	// [Engagement tracking]: https://docs.aws.amazon.com/ses/latest/dg/vdm-settings.html
	LastEngagementEvent []EngagementEventType

	// The subject line of the message.
	Subject []string

	noSmithyDocumentSerde
}

// Contains the name and value of a tag that you apply to an email. You can use
// message tags when you publish email sending events.
type MessageTag struct {

	// The name of the message tag. The message tag name has to meet the following
	// criteria:
	//
	//   - It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//   (_), or dashes (-).
	//
	//   - It can contain no more than 256 characters.
	//
	// This member is required.
	Name *string

	// The value of the message tag. The message tag value has to meet the following
	// criteria:
	//
	//   - It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//   (_), or dashes (-).
	//
	//   - It can contain no more than 256 characters.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An error corresponding to the unsuccessful processing of a single metric data
// query.
type MetricDataError struct {

	// The query error code. Can be one of:
	//
	//   - INTERNAL_FAILURE – Amazon SES has failed to process one of the queries.
	//
	//   - ACCESS_DENIED – You have insufficient access to retrieve metrics based on
	//   the given query.
	Code QueryErrorCode

	// The query identifier.
	Id *string

	// The error message associated with the current query error.
	Message *string

	noSmithyDocumentSerde
}

// The result of a single metric data query.
type MetricDataResult struct {

	// The query identifier.
	Id *string

	// A list of timestamps for the metric data results.
	Timestamps []time.Time

	// A list of values (cumulative / sum) for the metric data results.
	Values []int64

	noSmithyDocumentSerde
}

// An object that contains details about the data source for the metrics export.
type MetricsDataSource struct {

	// An object that contains a mapping between a MetricDimensionName and
	// MetricDimensionValue to filter metrics by. Must contain a least 1 dimension but
	// no more than 3 unique ones.
	//
	// This member is required.
	Dimensions map[string][]string

	// Represents the end date for the export interval as a timestamp.
	//
	// This member is required.
	EndDate *time.Time

	// A list of ExportMetric objects to export.
	//
	// This member is required.
	Metrics []ExportMetric

	// The metrics namespace - e.g., VDM .
	//
	// This member is required.
	Namespace MetricNamespace

	// Represents the start date for the export interval as a timestamp.
	//
	// This member is required.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// An object that contains multi-region endpoint (global-endpoint) properties.
type MultiRegionEndpoint struct {

	// The time stamp of when the multi-region endpoint (global-endpoint) was created.
	CreatedTimestamp *time.Time

	// The ID of the multi-region endpoint (global-endpoint).
	EndpointId *string

	// The name of the multi-region endpoint (global-endpoint).
	EndpointName *string

	// The time stamp of when the multi-region endpoint (global-endpoint) was last
	// updated.
	LastUpdatedTimestamp *time.Time

	// Primary and secondary regions between which multi-region endpoint splits
	// sending traffic.
	Regions []string

	// The status of the multi-region endpoint (global-endpoint).
	//
	//   - CREATING – The resource is being provisioned.
	//
	//   - READY – The resource is ready to use.
	//
	//   - FAILED – The resource failed to be provisioned.
	//
	//   - DELETING – The resource is being deleted as requested.
	Status Status

	noSmithyDocumentSerde
}

// An object that contains information about email that was sent from the selected
// domain.
type OverallVolume struct {

	// An object that contains inbox and junk mail placement metrics for individual
	// email providers.
	DomainIspPlacements []DomainIspPlacement

	// The percentage of emails that were sent from the domain that were read by their
	// recipients.
	ReadRatePercent *float64

	// An object that contains information about the numbers of messages that arrived
	// in recipients' inboxes and junk mail folders.
	VolumeStatistics *VolumeStatistics

	noSmithyDocumentSerde
}

// An object that defines an Amazon Pinpoint project destination for email events.
// You can send email event data to a Amazon Pinpoint project to view metrics using
// the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For
// more information, see [Transactional Messaging Charts]in the Amazon Pinpoint User Guide.
//
// [Transactional Messaging Charts]: https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html
type PinpointDestination struct {

	// The Amazon Resource Name (ARN) of the Amazon Pinpoint project to send email
	// events to.
	ApplicationArn *string

	noSmithyDocumentSerde
}

// An object that contains inbox placement data for an email provider.
type PlacementStatistics struct {

	// The percentage of emails that were authenticated by using DomainKeys Identified
	// Mail (DKIM) during the predictive inbox placement test.
	DkimPercentage *float64

	// The percentage of emails that arrived in recipients' inboxes during the
	// predictive inbox placement test.
	InboxPercentage *float64

	// The percentage of emails that didn't arrive in recipients' inboxes at all
	// during the predictive inbox placement test.
	MissingPercentage *float64

	// The percentage of emails that arrived in recipients' spam or junk mail folders
	// during the predictive inbox placement test.
	SpamPercentage *float64

	// The percentage of emails that were authenticated by using Sender Policy
	// Framework (SPF) during the predictive inbox placement test.
	SpfPercentage *float64

	noSmithyDocumentSerde
}

// Represents the raw content of an email message.
type RawMessage struct {

	// The raw email message. The message has to meet the following criteria:
	//
	//   - The message has to contain a header and a body, separated by one blank line.
	//
	//   - All of the required header fields must be present in the message.
	//
	//   - Each part of a multipart MIME message must be formatted properly.
	//
	//   - Attachments must be in a file format that the Amazon SES supports.
	//
	//   - The raw data of the message needs to base64-encoded if you are accessing
	//   Amazon SES directly through the HTTPS interface. If you are accessing Amazon SES
	//   using an Amazon Web Services SDK, the SDK takes care of the base 64-encoding for
	//   you.
	//
	//   - If any of the MIME parts in your message contain content that is outside of
	//   the 7-bit ASCII character range, you should encode that content to ensure that
	//   recipients' email clients render the message properly.
	//
	//   - The length of any single line of text in the message can't exceed 1,000
	//   characters. This restriction is defined in [RFC 5321].
	//
	// [RFC 5321]: https://tools.ietf.org/html/rfc5321
	//
	// This member is required.
	Data []byte

	noSmithyDocumentSerde
}

// A recommendation generated for your account.
type Recommendation struct {

	// The first time this issue was encountered and the recommendation was generated.
	CreatedTimestamp *time.Time

	// The recommendation description / disambiguator - e.g. DKIM1 and DKIM2 are
	// different recommendations about your DKIM setup.
	Description *string

	// The recommendation impact, with values like HIGH or LOW .
	Impact RecommendationImpact

	// The last time the recommendation was updated.
	LastUpdatedTimestamp *time.Time

	// The resource affected by the recommendation, with values like
	// arn:aws:ses:us-east-1:123456789012:identity/example.com .
	ResourceArn *string

	// The recommendation status, with values like OPEN or FIXED .
	Status RecommendationStatus

	// The recommendation type, with values like DKIM , SPF , DMARC , BIMI , or
	// COMPLAINT .
	Type RecommendationType

	noSmithyDocumentSerde
}

// The ReplaceEmailContent object to be used for a specific BulkEmailEntry . The
// ReplacementTemplate can be specified within this object.
type ReplacementEmailContent struct {

	// The ReplacementTemplate associated with ReplacementEmailContent .
	ReplacementTemplate *ReplacementTemplate

	noSmithyDocumentSerde
}

// An object which contains ReplacementTemplateData to be used for a specific
// BulkEmailEntry .
type ReplacementTemplate struct {

	// A list of replacement values to apply to the template. This parameter is a JSON
	// object, typically consisting of key-value pairs in which the keys correspond to
	// replacement tags in the email template.
	ReplacementTemplateData *string

	noSmithyDocumentSerde
}

// Enable or disable collection of reputation metrics for emails that you send
// using this configuration set in the current Amazon Web Services Region.
type ReputationOptions struct {

	// The date and time (in Unix time) when the reputation metrics were last given a
	// fresh start. When your account is given a fresh start, your reputation metrics
	// are calculated starting from the date of the fresh start.
	LastFreshStart *time.Time

	// If true , tracking of reputation metrics is enabled for the configuration set.
	// If false , tracking of reputation metrics is disabled for the configuration set.
	ReputationMetricsEnabled bool

	noSmithyDocumentSerde
}

// An object that contains information about your account details review.
type ReviewDetails struct {

	// The associated support center case ID (if any).
	CaseId *string

	// The status of the latest review of your account. The status can be one of the
	// following:
	//
	//   - PENDING – We have received your appeal and are in the process of reviewing
	//   it.
	//
	//   - GRANTED – Your appeal has been reviewed and your production access has been
	//   granted.
	//
	//   - DENIED – Your appeal has been reviewed and your production access has been
	//   denied.
	//
	//   - FAILED – An internal error occurred and we didn't receive your appeal. You
	//   can submit your appeal again.
	Status ReviewStatus

	noSmithyDocumentSerde
}

// An object which contains an AWS-Region and routing status.
type Route struct {

	// The name of an AWS-Region.
	//
	// This member is required.
	Region *string

	noSmithyDocumentSerde
}

// An object that contains route configuration. Includes secondary region name.
type RouteDetails struct {

	// The name of an AWS-Region to be a secondary region for the multi-region
	// endpoint (global-endpoint).
	//
	// This member is required.
	Region *string

	noSmithyDocumentSerde
}

// Used to enable or disable email sending for messages that use this
// configuration set in the current Amazon Web Services Region.
type SendingOptions struct {

	// If true , email sending is enabled for the configuration set. If false , email
	// sending is disabled for the configuration set.
	SendingEnabled bool

	noSmithyDocumentSerde
}

// An object that contains information about the per-day and per-second sending
// limits for your Amazon SES account in the current Amazon Web Services Region.
type SendQuota struct {

	// The maximum number of emails that you can send in the current Amazon Web
	// Services Region over a 24-hour period. A value of -1 signifies an unlimited
	// quota. (This value is also referred to as your sending quota.)
	Max24HourSend float64

	// The maximum number of emails that you can send per second in the current Amazon
	// Web Services Region. This value is also called your maximum sending rate or your
	// maximum TPS (transactions per second) rate.
	MaxSendRate float64

	// The number of emails sent from your Amazon SES account in the current Amazon
	// Web Services Region over the past 24 hours.
	SentLast24Hours float64

	noSmithyDocumentSerde
}

// An object that defines an Amazon SNS destination for email events. You can use
// Amazon SNS to send notifications when certain email events occur.
type SnsDestination struct {

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events
	// to. For more information about Amazon SNS topics, see the [Amazon SNS Developer Guide].
	//
	// [Amazon SNS Developer Guide]: https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html
	//
	// This member is required.
	TopicArn *string

	noSmithyDocumentSerde
}

// An object that contains information about the start of authority (SOA) record
// associated with the identity.
type SOARecord struct {

	// Administrative contact email from the SOA record.
	AdminEmail *string

	// Primary name server specified in the SOA record.
	PrimaryNameServer *string

	// Serial number from the SOA record.
	SerialNumber int64

	noSmithyDocumentSerde
}

// An object that contains information about an email address that is on the
// suppression list for your account.
type SuppressedDestination struct {

	// The email address that is on the suppression list for your account.
	//
	// This member is required.
	EmailAddress *string

	// The date and time when the suppressed destination was last updated, shown in
	// Unix time format.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The reason that the address was added to the suppression list for your account.
	//
	// This member is required.
	Reason SuppressionListReason

	// An optional value that can contain additional information about the reasons
	// that the address was added to the suppression list for your account.
	Attributes *SuppressedDestinationAttributes

	noSmithyDocumentSerde
}

// An object that contains additional attributes that are related an email address
// that is on the suppression list for your account.
type SuppressedDestinationAttributes struct {

	// A unique identifier that's generated when an email address is added to the
	// suppression list for your account.
	FeedbackId *string

	// The unique identifier of the email message that caused the email address to be
	// added to the suppression list for your account.
	MessageId *string

	noSmithyDocumentSerde
}

// A summary that describes the suppressed email address.
type SuppressedDestinationSummary struct {

	// The email address that's on the suppression list for your account.
	//
	// This member is required.
	EmailAddress *string

	// The date and time when the suppressed destination was last updated, shown in
	// Unix time format.
	//
	// This member is required.
	LastUpdateTime *time.Time

	// The reason that the address was added to the suppression list for your account.
	//
	// This member is required.
	Reason SuppressionListReason

	noSmithyDocumentSerde
}

// An object that contains information about the email address suppression
// preferences for your account in the current Amazon Web Services Region.
type SuppressionAttributes struct {

	// A list that contains the reasons that email addresses will be automatically
	// added to the suppression list for your account. This list can contain any or all
	// of the following:
	//
	//   - COMPLAINT – Amazon SES adds an email address to the suppression list for
	//   your account when a message sent to that address results in a complaint.
	//
	//   - BOUNCE – Amazon SES adds an email address to the suppression list for your
	//   account when a message sent to that address results in a hard bounce.
	SuppressedReasons []SuppressionListReason

	noSmithyDocumentSerde
}

// An object that contains details about the action of suppression list.
type SuppressionListDestination struct {

	// The type of action to perform on the address. The following are possible values:
	//
	//   - PUT: add the addresses to the suppression list. If the record already
	//   exists, it will override it with the new value.
	//
	//   - DELETE: remove the addresses from the suppression list.
	//
	// This member is required.
	SuppressionListImportAction SuppressionListImportAction

	noSmithyDocumentSerde
}

// An object that contains information about the suppression list preferences for
// your account.
type SuppressionOptions struct {

	// A list that contains the reasons that email addresses are automatically added
	// to the suppression list for your account. This list can contain any or all of
	// the following:
	//
	//   - COMPLAINT – Amazon SES adds an email address to the suppression list for
	//   your account when a message sent to that address results in a complaint.
	//
	//   - BOUNCE – Amazon SES adds an email address to the suppression list for your
	//   account when a message sent to that address results in a hard bounce.
	SuppressedReasons []SuppressionListReason

	noSmithyDocumentSerde
}

// An object that defines the tags that are associated with a resource. A tag is a
// label that you optionally define and associate with a resource. Tags can help
// you categorize and manage resources in different ways, such as by purpose,
// owner, environment, or other criteria. A resource can have as many as 50 tags.
//
// Each tag consists of a required tag key and an associated tag value, both of
// which you define. A tag key is a general label that acts as a category for a
// more specific tag value. A tag value acts as a descriptor within a tag key. A
// tag key can contain as many as 128 characters. A tag value can contain as many
// as 256 characters. The characters can be Unicode letters, digits, white space,
// or one of the following symbols: _ . : / = + -. The following additional
// restrictions apply to tags:
//
//   - Tag keys and values are case sensitive.
//
//   - For each associated resource, each tag key must be unique and it can have
//     only one value.
//
//   - The aws: prefix is reserved for use by Amazon Web Services; you can’t use it
//     in any tag keys or values that you define. In addition, you can't edit or remove
//     tag keys or values that use this prefix. Tags that use this prefix don’t count
//     against the limit of 50 tags per resource.
//
//   - You can associate tags with public or shared resources, but the tags are
//     available only for your Amazon Web Services account, not any other accounts that
//     share the resource. In addition, the tags are available only for resources that
//     are located in the specified Amazon Web Services Region for your Amazon Web
//     Services account.
type Tag struct {

	// One part of a key-value pair that defines a tag. The maximum length of a tag
	// key is 128 characters. The minimum length is 1 character.
	//
	// This member is required.
	Key *string

	// The optional part of a key-value pair that defines a tag. The maximum length of
	// a tag value is 256 characters. The minimum length is 0 characters. If you don't
	// want a resource to have a specific tag value, don't specify a value for this
	// parameter. If you don't specify a value, Amazon SES sets the value to an empty
	// string.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that defines the email template to use for an email message, and the
// values to use for any message variables in that template. An email template is a
// type of message template that contains content that you want to reuse in email
// messages that you send. You can specifiy the email template by providing the
// name or ARN of an email template previously saved in your Amazon SES account or
// by providing the full template content.
type Template struct {

	// The list of message headers that will be added to the email message.
	Headers []MessageHeader

	// The Amazon Resource Name (ARN) of the template.
	TemplateArn *string

	// The content of the template.
	//
	// Amazon SES supports only simple substitions when you send email using the
	// SendEmail or SendBulkEmail operations and you provide the full template content
	// in the request.
	TemplateContent *EmailTemplateContent

	// An object that defines the values to use for message variables in the template.
	// This object is a set of key-value pairs. Each key defines a message variable in
	// the template. The corresponding value defines the value to use for that
	// variable.
	TemplateData *string

	// The name of the template. You will refer to this name when you send email using
	// the SendTemplatedEmail or SendBulkTemplatedEmail operations.
	TemplateName *string

	noSmithyDocumentSerde
}

// An interest group, theme, or label within a list. Lists can have multiple
// topics.
type Topic struct {

	// The default subscription status to be applied to a contact if the contact has
	// not noted their preference for subscribing to a topic.
	//
	// This member is required.
	DefaultSubscriptionStatus SubscriptionStatus

	// The name of the topic the contact will see.
	//
	// This member is required.
	DisplayName *string

	// The name of the topic.
	//
	// This member is required.
	TopicName *string

	// A description of what the topic is about, which the contact will see.
	Description *string

	noSmithyDocumentSerde
}

// Used for filtering by a specific topic preference.
type TopicFilter struct {

	// The name of a topic on which you wish to apply the filter.
	TopicName *string

	// Notes that the default subscription status should be applied to a contact
	// because the contact has not noted their preference for subscribing to a topic.
	UseDefaultIfPreferenceUnavailable bool

	noSmithyDocumentSerde
}

// The contact's preference for being opted-in to or opted-out of a topic.
type TopicPreference struct {

	// The contact's subscription status to a topic which is either OPT_IN or OPT_OUT .
	//
	// This member is required.
	SubscriptionStatus SubscriptionStatus

	// The name of the topic.
	//
	// This member is required.
	TopicName *string

	noSmithyDocumentSerde
}

// An object that defines the tracking options for a configuration set. When you
// use the Amazon SES API v2 to send an email, it contains an invisible image
// that's used to track when recipients open your email. If your email contains
// links, those links are changed slightly in order to track when recipients click
// them.
//
// These images and links include references to a domain operated by Amazon Web
// Services. You can optionally configure the Amazon SES to use a domain that you
// operate for these images and links.
type TrackingOptions struct {

	// The domain to use for tracking open and click events.
	//
	// This member is required.
	CustomRedirectDomain *string

	// The https policy to use for tracking open and click events.
	HttpsPolicy HttpsPolicy

	noSmithyDocumentSerde
}

// The VDM attributes that apply to your Amazon SES account.
type VdmAttributes struct {

	// Specifies the status of your VDM configuration. Can be one of the following:
	//
	//   - ENABLED – Amazon SES enables VDM for your account.
	//
	//   - DISABLED – Amazon SES disables VDM for your account.
	//
	// This member is required.
	VdmEnabled FeatureStatus

	// Specifies additional settings for your VDM configuration as applicable to the
	// Dashboard.
	DashboardAttributes *DashboardAttributes

	// Specifies additional settings for your VDM configuration as applicable to the
	// Guardian.
	GuardianAttributes *GuardianAttributes

	noSmithyDocumentSerde
}

// An object that defines the VDM settings that apply to emails that you send
// using the configuration set.
type VdmOptions struct {

	// Specifies additional settings for your VDM configuration as applicable to the
	// Dashboard.
	DashboardOptions *DashboardOptions

	// Specifies additional settings for your VDM configuration as applicable to the
	// Guardian.
	GuardianOptions *GuardianOptions

	noSmithyDocumentSerde
}

// An object that contains additional information about the verification status
// for the identity.
type VerificationInfo struct {

	// Provides the reason for the failure describing why Amazon SES was not able to
	// successfully verify the identity. Below are the possible values:
	//
	//   - INVALID_VALUE – Amazon SES was able to find the record, but the value
	//   contained within the record was invalid. Ensure you have published the correct
	//   values for the record.
	//
	//   - TYPE_NOT_FOUND – The queried hostname exists but does not have the requested
	//   type of DNS record. Ensure that you have published the correct type of DNS
	//   record.
	//
	//   - HOST_NOT_FOUND – The queried hostname does not exist or was not reachable at
	//   the time of the request. Ensure that you have published the required DNS
	//   record(s).
	//
	//   - SERVICE_ERROR – A temporary issue is preventing Amazon SES from determining
	//   the verification status of the domain.
	//
	//   - DNS_SERVER_ERROR – The DNS server encountered an issue and was unable to
	//   complete the request.
	//
	//   - REPLICATION_ACCESS_DENIED – The verification failed because the user does
	//   not have the required permissions to replicate the DKIM key from the primary
	//   region. Ensure you have the necessary permissions in both primary and replica
	//   regions.
	//
	//   - REPLICATION_PRIMARY_NOT_FOUND – The verification failed because no
	//   corresponding identity was found in the specified primary region. Ensure the
	//   identity exists in the primary region before attempting replication.
	//
	//   - REPLICATION_PRIMARY_BYO_DKIM_NOT_SUPPORTED – The verification failed because
	//   the identity in the primary region is configured with Bring Your Own DKIM
	//   (BYODKIM). DKIM key replication is only supported for identities using Easy
	//   DKIM.
	//
	//   - REPLICATION_REPLICA_AS_PRIMARY_NOT_SUPPORTED – The verification failed
	//   because the specified primary identity is a replica of another identity, and
	//   multi-level replication is not supported; the primary identity must be a
	//   non-replica identity.
	//
	//   - REPLICATION_PRIMARY_INVALID_REGION – The verification failed due to an
	//   invalid primary region specified. Ensure you provide a valid Amazon Web Services
	//   region where Amazon SES is available and different from the replica region.
	ErrorType VerificationError

	// The last time a verification attempt was made for this identity.
	LastCheckedTimestamp *time.Time

	// The last time a successful verification was made for this identity.
	LastSuccessTimestamp *time.Time

	// An object that contains information about the start of authority (SOA) record
	// associated with the identity.
	SOARecord *SOARecord

	noSmithyDocumentSerde
}

// An object that contains information about the amount of email that was
// delivered to recipients.
type VolumeStatistics struct {

	// The total number of emails that arrived in recipients' inboxes.
	InboxRawCount *int64

	// An estimate of the percentage of emails sent from the current domain that will
	// arrive in recipients' inboxes.
	ProjectedInbox *int64

	// An estimate of the percentage of emails sent from the current domain that will
	// arrive in recipients' spam or junk mail folders.
	ProjectedSpam *int64

	// The total number of emails that arrived in recipients' spam or junk mail
	// folders.
	SpamRawCount *int64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
