// Code generated by smithy-go-codegen DO NOT EDIT.

package socialmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/socialmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get the details of your linked WhatsApp Business Account.
func (c *Client) GetLinkedWhatsAppBusinessAccount(ctx context.Context, params *GetLinkedWhatsAppBusinessAccountInput, optFns ...func(*Options)) (*GetLinkedWhatsAppBusinessAccountOutput, error) {
	if params == nil {
		params = &GetLinkedWhatsAppBusinessAccountInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetLinkedWhatsAppBusinessAccount", params, optFns, c.addOperationGetLinkedWhatsAppBusinessAccountMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetLinkedWhatsAppBusinessAccountOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetLinkedWhatsAppBusinessAccountInput struct {

	// The unique identifier, from Amazon Web Services, of the linked WhatsApp
	// Business Account. WABA identifiers are formatted as
	// waba-01234567890123456789012345678901 . Use [ListLinkedWhatsAppBusinessAccounts] to list all WABAs and their
	// details.
	//
	// [ListLinkedWhatsAppBusinessAccounts]: https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_ListLinkedWhatsAppBusinessAccounts.html
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

type GetLinkedWhatsAppBusinessAccountOutput struct {

	// The details of the linked WhatsApp Business Account.
	Account *types.LinkedWhatsAppBusinessAccount

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetLinkedWhatsAppBusinessAccountMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetLinkedWhatsAppBusinessAccount{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetLinkedWhatsAppBusinessAccount{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetLinkedWhatsAppBusinessAccount"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetLinkedWhatsAppBusinessAccountValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetLinkedWhatsAppBusinessAccount(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetLinkedWhatsAppBusinessAccount(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetLinkedWhatsAppBusinessAccount",
	}
}
