// Code generated by smithy-go-codegen DO NOT EDIT.

package socialmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/socialmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use your WhatsApp phone number id to get the WABA account id and phone number
// details.
func (c *Client) GetLinkedWhatsAppBusinessAccountPhoneNumber(ctx context.Context, params *GetLinkedWhatsAppBusinessAccountPhoneNumberInput, optFns ...func(*Options)) (*GetLinkedWhatsAppBusinessAccountPhoneNumberOutput, error) {
	if params == nil {
		params = &GetLinkedWhatsAppBusinessAccountPhoneNumberInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetLinkedWhatsAppBusinessAccountPhoneNumber", params, optFns, c.addOperationGetLinkedWhatsAppBusinessAccountPhoneNumberMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetLinkedWhatsAppBusinessAccountPhoneNumberOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetLinkedWhatsAppBusinessAccountPhoneNumberInput struct {

	// The unique identifier of the phone number. Phone number identifiers are
	// formatted as phone-number-id-01234567890123456789012345678901 . Use [GetLinkedWhatsAppBusinessAccount] to find a
	// phone number's id.
	//
	// [GetLinkedWhatsAppBusinessAccount]: https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

type GetLinkedWhatsAppBusinessAccountPhoneNumberOutput struct {

	// The WABA identifier linked to the phone number, formatted as
	// waba-01234567890123456789012345678901 .
	LinkedWhatsAppBusinessAccountId *string

	// The details of your WhatsApp phone number.
	PhoneNumber *types.WhatsAppPhoneNumberDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetLinkedWhatsAppBusinessAccountPhoneNumberMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetLinkedWhatsAppBusinessAccountPhoneNumber{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetLinkedWhatsAppBusinessAccountPhoneNumber{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetLinkedWhatsAppBusinessAccountPhoneNumber"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetLinkedWhatsAppBusinessAccountPhoneNumberValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetLinkedWhatsAppBusinessAccountPhoneNumber(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetLinkedWhatsAppBusinessAccountPhoneNumber(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetLinkedWhatsAppBusinessAccountPhoneNumber",
	}
}
