// Code generated by smithy-go-codegen DO NOT EDIT.

package socialmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/socialmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all WhatsApp Business Accounts linked to your Amazon Web Services account.
func (c *Client) ListLinkedWhatsAppBusinessAccounts(ctx context.Context, params *ListLinkedWhatsAppBusinessAccountsInput, optFns ...func(*Options)) (*ListLinkedWhatsAppBusinessAccountsOutput, error) {
	if params == nil {
		params = &ListLinkedWhatsAppBusinessAccountsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLinkedWhatsAppBusinessAccounts", params, optFns, c.addOperationListLinkedWhatsAppBusinessAccountsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLinkedWhatsAppBusinessAccountsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLinkedWhatsAppBusinessAccountsInput struct {

	// The maximum number of results to return.
	MaxResults *int32

	// The next token for pagination.
	NextToken *string

	noSmithyDocumentSerde
}

type ListLinkedWhatsAppBusinessAccountsOutput struct {

	// A list of WhatsApp Business Accounts linked to your Amazon Web Services account.
	LinkedAccounts []types.LinkedWhatsAppBusinessAccountSummary

	// The next token for pagination.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLinkedWhatsAppBusinessAccountsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListLinkedWhatsAppBusinessAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListLinkedWhatsAppBusinessAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLinkedWhatsAppBusinessAccounts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLinkedWhatsAppBusinessAccounts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListLinkedWhatsAppBusinessAccountsPaginatorOptions is the paginator options for
// ListLinkedWhatsAppBusinessAccounts
type ListLinkedWhatsAppBusinessAccountsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLinkedWhatsAppBusinessAccountsPaginator is a paginator for
// ListLinkedWhatsAppBusinessAccounts
type ListLinkedWhatsAppBusinessAccountsPaginator struct {
	options   ListLinkedWhatsAppBusinessAccountsPaginatorOptions
	client    ListLinkedWhatsAppBusinessAccountsAPIClient
	params    *ListLinkedWhatsAppBusinessAccountsInput
	nextToken *string
	firstPage bool
}

// NewListLinkedWhatsAppBusinessAccountsPaginator returns a new
// ListLinkedWhatsAppBusinessAccountsPaginator
func NewListLinkedWhatsAppBusinessAccountsPaginator(client ListLinkedWhatsAppBusinessAccountsAPIClient, params *ListLinkedWhatsAppBusinessAccountsInput, optFns ...func(*ListLinkedWhatsAppBusinessAccountsPaginatorOptions)) *ListLinkedWhatsAppBusinessAccountsPaginator {
	if params == nil {
		params = &ListLinkedWhatsAppBusinessAccountsInput{}
	}

	options := ListLinkedWhatsAppBusinessAccountsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLinkedWhatsAppBusinessAccountsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLinkedWhatsAppBusinessAccountsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLinkedWhatsAppBusinessAccounts page.
func (p *ListLinkedWhatsAppBusinessAccountsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLinkedWhatsAppBusinessAccountsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLinkedWhatsAppBusinessAccounts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLinkedWhatsAppBusinessAccountsAPIClient is a client that implements the
// ListLinkedWhatsAppBusinessAccounts operation.
type ListLinkedWhatsAppBusinessAccountsAPIClient interface {
	ListLinkedWhatsAppBusinessAccounts(context.Context, *ListLinkedWhatsAppBusinessAccountsInput, ...func(*Options)) (*ListLinkedWhatsAppBusinessAccountsOutput, error)
}

var _ ListLinkedWhatsAppBusinessAccountsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLinkedWhatsAppBusinessAccounts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLinkedWhatsAppBusinessAccounts",
	}
}
