// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmcontacts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssmcontacts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the resolution path of an engagement. For example, the escalation plan
// engaged in an incident might target an on-call schedule that includes several
// contacts in a rotation, but just one contact on-call when the incident starts.
// The resolution path indicates the hierarchy of escalation plan > on-call
// schedule > contact.
func (c *Client) ListPageResolutions(ctx context.Context, params *ListPageResolutionsInput, optFns ...func(*Options)) (*ListPageResolutionsOutput, error) {
	if params == nil {
		params = &ListPageResolutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPageResolutions", params, optFns, c.addOperationListPageResolutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPageResolutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPageResolutionsInput struct {

	// The Amazon Resource Name (ARN) of the contact engaged for the incident.
	//
	// This member is required.
	PageId *string

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPageResolutionsOutput struct {

	// Information about the resolution for an engagement.
	//
	// This member is required.
	PageResolutions []types.ResolutionContact

	// The token for the next set of items to return. Use this token to get the next
	// set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPageResolutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListPageResolutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListPageResolutions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPageResolutions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListPageResolutionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPageResolutions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListPageResolutionsPaginatorOptions is the paginator options for
// ListPageResolutions
type ListPageResolutionsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPageResolutionsPaginator is a paginator for ListPageResolutions
type ListPageResolutionsPaginator struct {
	options   ListPageResolutionsPaginatorOptions
	client    ListPageResolutionsAPIClient
	params    *ListPageResolutionsInput
	nextToken *string
	firstPage bool
}

// NewListPageResolutionsPaginator returns a new ListPageResolutionsPaginator
func NewListPageResolutionsPaginator(client ListPageResolutionsAPIClient, params *ListPageResolutionsInput, optFns ...func(*ListPageResolutionsPaginatorOptions)) *ListPageResolutionsPaginator {
	if params == nil {
		params = &ListPageResolutionsInput{}
	}

	options := ListPageResolutionsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPageResolutionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPageResolutionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPageResolutions page.
func (p *ListPageResolutionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPageResolutionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPageResolutions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPageResolutionsAPIClient is a client that implements the
// ListPageResolutions operation.
type ListPageResolutionsAPIClient interface {
	ListPageResolutions(context.Context, *ListPageResolutionsInput, ...func(*Options)) (*ListPageResolutionsOutput, error)
}

var _ ListPageResolutionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPageResolutions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPageResolutions",
	}
}
