// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmsap

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssmsap/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Register an SAP application with AWS Systems Manager for SAP. You must meet the
// following requirements before registering.
//
// The SAP application you want to register with AWS Systems Manager for SAP is
// running on Amazon EC2.
//
// AWS Systems Manager Agent must be setup on an Amazon EC2 instance along with
// the required IAM permissions.
//
// Amazon EC2 instance(s) must have access to the secrets created in AWS Secrets
// Manager to manage SAP applications and components.
func (c *Client) RegisterApplication(ctx context.Context, params *RegisterApplicationInput, optFns ...func(*Options)) (*RegisterApplicationOutput, error) {
	if params == nil {
		params = &RegisterApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RegisterApplication", params, optFns, c.addOperationRegisterApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RegisterApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RegisterApplicationInput struct {

	// The ID of the application.
	//
	// This member is required.
	ApplicationId *string

	// The type of the application.
	//
	// This member is required.
	ApplicationType types.ApplicationType

	// The Amazon EC2 instances on which your SAP application is running.
	//
	// This member is required.
	Instances []string

	// This is an optional parameter for component details to which the SAP ABAP
	// application is attached, such as Web Dispatcher.
	//
	// This is an array of ApplicationComponent objects. You may input 0 to 5 items.
	ComponentsInfo []types.ComponentInfo

	// The credentials of the SAP application.
	Credentials []types.ApplicationCredential

	// The Amazon Resource Name of the SAP HANA database.
	DatabaseArn *string

	// The SAP instance number of the application.
	SapInstanceNumber *string

	// The System ID of the application.
	Sid *string

	// The tags to be attached to the SAP application.
	Tags map[string]string

	noSmithyDocumentSerde
}

type RegisterApplicationOutput struct {

	// The application registered with AWS Systems Manager for SAP.
	Application *types.Application

	// The ID of the operation.
	OperationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRegisterApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRegisterApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRegisterApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RegisterApplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpRegisterApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRegisterApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRegisterApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RegisterApplication",
	}
}
