// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts generating a report of the file metadata currently cached by an S3 File
// Gateway for a specific file share. You can use this report to identify and
// resolve issues if you have files failing upload from your gateway to Amazon S3.
// The report is a CSV file containing a list of files which match the set of
// filter parameters you specify in the request.
//
// The Files Failing Upload flag is reset every 24 hours and during gateway
// reboot. If this report captures the files after the reset, but before they
// become flagged again, they will not be reported as Files Failing Upload.
//
// The following requirements must be met to successfully generate a cache report:
//
//   - You must have permissions to list the entire Amazon S3 bucket associated
//     with the specified file share.
//
//   - No other cache reports can currently be in-progress for the specified file
//     share.
//
//   - There must be fewer than 10 existing cache reports for the specified file
//     share.
//
//   - The gateway must be online and connected to Amazon Web Services.
//
//   - The root disk must have at least 20GB of free space when report generation
//     starts.
//
//   - You must specify at least one value for InclusionFilters or ExclusionFilters
//     in the request.
func (c *Client) StartCacheReport(ctx context.Context, params *StartCacheReportInput, optFns ...func(*Options)) (*StartCacheReportOutput, error) {
	if params == nil {
		params = &StartCacheReportInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartCacheReport", params, optFns, c.addOperationStartCacheReportMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartCacheReportOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartCacheReportInput struct {

	// The Amazon Web Services Region of the Amazon S3 bucket associated with the file
	// share for which you want to generate the cache report.
	//
	// This member is required.
	BucketRegion *string

	// A unique identifier that you use to ensure idempotent report generation if you
	// need to retry an unsuccessful StartCacheReport request. If you retry a request,
	// use the same ClientToken you specified in the initial request.
	//
	// This member is required.
	ClientToken *string

	// The Amazon Resource Name (ARN) of the file share.
	//
	// This member is required.
	FileShareARN *string

	// The ARN of the Amazon S3 bucket where the cache report will be saved.
	//
	// We do not recommend saving the cache report to the same Amazon S3 bucket for
	// which you are generating the report.
	//
	// This field does not accept access point ARNs.
	//
	// This member is required.
	LocationARN *string

	// The ARN of the IAM role used when saving the cache report to Amazon S3.
	//
	// This member is required.
	Role *string

	// The list of filters and parameters that determine which files are excluded from
	// the report. You must specify at least one value for InclusionFilters or
	// ExclusionFilters in a StartCacheReport request.
	ExclusionFilters []types.CacheReportFilter

	// The list of filters and parameters that determine which files are included in
	// the report. You must specify at least one value for InclusionFilters or
	// ExclusionFilters in a StartCacheReport request.
	InclusionFilters []types.CacheReportFilter

	// A list of up to 50 key/value tags that you can assign to the cache report.
	// Using tags can help you categorize your reports and more easily locate them in
	// search results.
	Tags []types.Tag

	// The DNS name of the VPC endpoint associated with the Amazon S3 where you want
	// to save the cache report. Optional.
	VPCEndpointDNSName *string

	noSmithyDocumentSerde
}

type StartCacheReportOutput struct {

	// The Amazon Resource Name (ARN) of the cache report generated by the
	// StartCacheReport request.
	CacheReportARN *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartCacheReportMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartCacheReport{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartCacheReport{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartCacheReport"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpStartCacheReportValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartCacheReport(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartCacheReport(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartCacheReport",
	}
}
