// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An object with your accountId and TRN information.
type AccountDetails struct {

	// List of unique account identifiers.
	AccountId *string

	//  The meta data information associated with the account.
	AccountMetaData *AccountMetaData

	//  Tax inheritance information associated with the account.
	TaxInheritanceDetails *TaxInheritanceDetails

	// Your TRN information. Instead of having full legal address, here TRN
	// information will have jurisdiction details (for example, country code and
	// state/region/province if applicable).
	TaxRegistration *TaxRegistrationWithJurisdiction

	noSmithyDocumentSerde
}

// The meta data information associated with the account.
type AccountMetaData struct {

	//  The Amazon Web Services accounts name.
	AccountName *string

	//  The details of the address associated with the TRN information.
	Address *Address

	//  Address roles associated with the account containing country code information.
	AddressRoleMap map[string]Jurisdiction

	//  The type of address associated with the legal profile.
	AddressType AddressRoleType

	//  Seller information associated with the account.
	Seller *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your tax registration number (TRN).
// Depending on the TRN for a specific country, you might need to specify this
// information when you set your TRN.
//
// You can only specify one of the following parameters and the value can't be
// empty.
//
// The parameter that you specify must match the country for the TRN, if
// available. For example, if you set a TRN in Canada for specific provinces, you
// must also specify the canadaAdditionalInfo parameter.
type AdditionalInfoRequest struct {

	//  Additional tax information associated with your TRN in Canada.
	CanadaAdditionalInfo *CanadaAdditionalInfo

	//  Additional tax information to specify for a TRN in Estonia.
	EstoniaAdditionalInfo *EstoniaAdditionalInfo

	//  Additional tax information to specify for a TRN in Georgia.
	GeorgiaAdditionalInfo *GeorgiaAdditionalInfo

	//  Additional tax information to specify for a TRN in Israel.
	IsraelAdditionalInfo *IsraelAdditionalInfo

	//  Additional tax information to specify for a TRN in Italy.
	ItalyAdditionalInfo *ItalyAdditionalInfo

	// Additional tax information to specify for a TRN in Kenya.
	KenyaAdditionalInfo *KenyaAdditionalInfo

	//  Additional tax information to specify for a TRN in Malaysia.
	MalaysiaAdditionalInfo *MalaysiaAdditionalInfo

	//  Additional tax information associated with your TRN in Poland.
	PolandAdditionalInfo *PolandAdditionalInfo

	// Additional tax information to specify for a TRN in Romania.
	RomaniaAdditionalInfo *RomaniaAdditionalInfo

	//  Additional tax information associated with your TRN in Saudi Arabia.
	SaudiArabiaAdditionalInfo *SaudiArabiaAdditionalInfo

	// Additional tax information to specify for a TRN in South Korea.
	SouthKoreaAdditionalInfo *SouthKoreaAdditionalInfo

	// Additional tax information to specify for a TRN in Spain.
	SpainAdditionalInfo *SpainAdditionalInfo

	// Additional tax information to specify for a TRN in Turkey.
	TurkeyAdditionalInfo *TurkeyAdditionalInfo

	//  Additional tax information associated with your TRN in Ukraine.
	UkraineAdditionalInfo *UkraineAdditionalInfo

	noSmithyDocumentSerde
}

//	Additional tax information associated with your TRN. The Tax Settings API
//
// returns country-specific information in the response when any additional
// information is present with your TRN for the following countries.
type AdditionalInfoResponse struct {

	// Additional tax information associated with your TRN in Brazil. The Tax Settings
	// API returns this information in your response when any additional information is
	// present with your TRN in Brazil.
	BrazilAdditionalInfo *BrazilAdditionalInfo

	// Additional tax information associated with your TRN in Canada.
	CanadaAdditionalInfo *CanadaAdditionalInfo

	//  Additional tax information associated with your TRN in Estonia.
	EstoniaAdditionalInfo *EstoniaAdditionalInfo

	//  Additional tax information associated with your TRN in Georgia.
	GeorgiaAdditionalInfo *GeorgiaAdditionalInfo

	//  Additional tax information in India.
	IndiaAdditionalInfo *IndiaAdditionalInfo

	//  Additional tax information associated with your TRN in Israel.
	IsraelAdditionalInfo *IsraelAdditionalInfo

	//  Additional tax information associated with your TRN in Italy.
	ItalyAdditionalInfo *ItalyAdditionalInfo

	// Additional tax information associated with your TRN in Kenya.
	KenyaAdditionalInfo *KenyaAdditionalInfo

	//  Additional tax information associated with your TRN in Malaysia.
	MalaysiaAdditionalInfo *MalaysiaAdditionalInfo

	//  Additional tax information associated with your TRN in Poland.
	PolandAdditionalInfo *PolandAdditionalInfo

	// Additional tax information to specify for a TRN in Romania.
	RomaniaAdditionalInfo *RomaniaAdditionalInfo

	//  Additional tax information associated with your TRN in Saudi Arabia.
	SaudiArabiaAdditionalInfo *SaudiArabiaAdditionalInfo

	// Additional tax information associated with your TRN in South Korea.
	SouthKoreaAdditionalInfo *SouthKoreaAdditionalInfo

	// Additional tax information associated with your TRN in Spain.
	SpainAdditionalInfo *SpainAdditionalInfo

	// Additional tax information associated with your TRN in Turkey.
	TurkeyAdditionalInfo *TurkeyAdditionalInfo

	//  Additional tax information associated with your TRN in Ukraine.
	UkraineAdditionalInfo *UkraineAdditionalInfo

	noSmithyDocumentSerde
}

// The details of the address associated with the TRN information.
type Address struct {

	// The first line of the address.
	//
	// This member is required.
	AddressLine1 *string

	// The city that the address is in.
	//
	// This member is required.
	City *string

	// The country code for the country that the address is in.
	//
	// This member is required.
	CountryCode *string

	//  The postal code associated with the address.
	//
	// This member is required.
	PostalCode *string

	// The second line of the address, if applicable.
	AddressLine2 *string

	//  The third line of the address, if applicable. Currently, the Tax Settings API
	// accepts the addressLine3 parameter only for Saudi Arabia. When you specify a
	// TRN in Saudi Arabia, you must enter the addressLine3 and specify the building
	// number for the address. For example, you might enter 1234 .
	AddressLine3 *string

	// The district or county the address is located.
	//
	// For addresses in Brazil, this parameter uses the name of the neighborhood. When
	// you set a TRN in Brazil, use districtOrCounty for the neighborhood name.
	DistrictOrCounty *string

	// The state, region, or province that the address is located. This field is only
	// required for Canada, India, United Arab Emirates, Romania, and Brazil (CPF). It
	// is optional for all other countries.
	//
	// If this is required for tax settings, use the same name as shown on the Tax
	// Settings page.
	StateOrRegion *string

	noSmithyDocumentSerde
}

// The address domain associate with the tax information.
type Authority struct {

	//  The country code for the country that the address is in.
	//
	// This member is required.
	Country *string

	//  The state that the address is located.
	State *string

	noSmithyDocumentSerde
}

//	The error object for representing failures in the BatchDeleteTaxRegistration
//
// operation.
type BatchDeleteTaxRegistrationError struct {

	//  The unique account identifier for the account whose tax registration couldn't
	// be deleted during the BatchDeleteTaxRegistration operation.
	//
	// This member is required.
	AccountId *string

	//  The error message for an individual failure in the BatchDeleteTaxRegistration
	// operation.
	//
	// This member is required.
	Message *string

	//  The error code for an individual failure in BatchDeleteTaxRegistration
	// operation.
	Code *string

	noSmithyDocumentSerde
}

//	The error object for representing failures in the BatchPutTaxRegistration
//
// operation.
type BatchPutTaxRegistrationError struct {

	//  The unique account identifier for the account that the tax registration
	// couldn't be added, or updated during the BatchPutTaxRegistration operation.
	//
	// This member is required.
	AccountId *string

	//  The error message for an individual failure in the BatchPutTaxRegistration
	// operation.
	//
	// This member is required.
	Message *string

	//  The error code for an individual failure in the BatchPutTaxRegistration
	// operation.
	Code *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Brazil.
type BrazilAdditionalInfo struct {

	// The Cadastro de Contribuintes Mobiliários (CCM) code for your TRN in Brazil.
	// This only applies for a CNPJ tax type for the São Paulo municipality.
	CcmCode *string

	// Legal nature of business, based on your TRN in Brazil. This only applies for a
	// CNPJ tax type.
	LegalNatureCode *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Canada .
type CanadaAdditionalInfo struct {

	//  The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales
	// Tax ID number.
	CanadaQuebecSalesTaxNumber *string

	//  Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services
	// services for resale in Manitoba must provide a valid Retail Sales Tax ID number
	// for Manitoba. Leave this blank if you do not have a Retail Sales Tax ID number
	// in Manitoba or are not purchasing Amazon Web Services services for resale.
	CanadaRetailSalesTaxNumber *string

	//  The value for this parameter must be true if the provincialSalesTaxId value is
	// provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces.
	//
	// To claim a provincial sales tax (PST) and retail sales tax (RST) reseller
	// exemption, you must confirm that purchases from this account were made for
	// resale. Otherwise, remove the PST or RST number from the provincialSalesTaxId
	// parameter from your request.
	IsResellerAccount *bool

	//  The provincial sales tax ID for your TRN in Canada. This parameter can
	// represent the following:
	//
	//   - Provincial sales tax ID number for British Columbia and Saskatchewan
	//   provinces
	//
	//   - Manitoba retail sales tax ID number for Manitoba province
	//
	//   - Quebec sales tax ID number for Quebec province
	//
	// The Tax Setting API only accepts this parameter if the TRN is specified for the
	// previous provinces. For other provinces, the Tax Settings API doesn't accept
	// this parameter.
	ProvincialSalesTaxId *string

	noSmithyDocumentSerde
}

// The location of the Amazon S3 bucket that you specify to download your tax
// documents to.
type DestinationS3Location struct {

	// The name of your Amazon S3 bucket that you specify to download your tax
	// documents to.
	//
	// This member is required.
	Bucket *string

	// The Amazon S3 object prefix that you specify for your tax document file.
	Prefix *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Estonia.
type EstoniaAdditionalInfo struct {

	//  Registry commercial code (RCC) for your TRN in Estonia. This value is an
	// eight-numeric string, such as 12345678 .
	//
	// This member is required.
	RegistryCommercialCode *string

	noSmithyDocumentSerde
}

// The exemption certificate.
type ExemptionCertificate struct {

	// The exemption certificate file content.
	//
	// This member is required.
	DocumentFile []byte

	// The exemption certificate file name.
	//
	// This member is required.
	DocumentName *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Georgia.
type GeorgiaAdditionalInfo struct {

	//  The legal person or physical person assigned to this TRN in Georgia.
	//
	// This member is required.
	PersonType PersonType

	noSmithyDocumentSerde
}

// Additional tax information in India.
type IndiaAdditionalInfo struct {

	//  India pan information associated with the account.
	Pan *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Israel.
type IsraelAdditionalInfo struct {

	//  Customer type for your TRN in Israel. The value can be Business or Individual .
	// Use Business for entities such as not-for-profit and financial institutions.
	//
	// This member is required.
	CustomerType IsraelCustomerType

	//  Dealer type for your TRN in Israel. If you're not a local authorized dealer
	// with an Israeli VAT ID, specify your tax identification number so that Amazon
	// Web Services can send you a compliant tax invoice.
	//
	// This member is required.
	DealerType IsraelDealerType

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Italy.
type ItalyAdditionalInfo struct {

	//  The tender procedure identification code.
	CigNumber *string

	//  Additional tax information to specify for a TRN in Italy. This is managed by
	// the Interministerial Committee for Economic Planning (CIPE) which characterizes
	// every public investment project (Individual Project Code).
	CupNumber *string

	//  Additional tax information to specify for a TRN in Italy. Use
	// CodiceDestinatario to receive your invoices via web service (API) or FTP.
	SdiAccountId *string

	// List of service tax codes for your TRN in Italy. You can use your customer tax
	// code as part of a VAT Group.
	TaxCode *string

	noSmithyDocumentSerde
}

// The jurisdiction details of the TRN information of the customers. This doesn't
// contain full legal address, and contains only country code and
// state/region/province.
type Jurisdiction struct {

	//  The country code of the jurisdiction.
	//
	// This member is required.
	CountryCode *string

	//  The state, region, or province associated with the country of the
	// jurisdiction, if applicable.
	StateOrRegion *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Kenya.
type KenyaAdditionalInfo struct {

	// The legal person or physical person assigned to this TRN in Kenya.
	//
	// This member is required.
	PersonType PersonType

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Malaysia.
type MalaysiaAdditionalInfo struct {

	// The tax registration number (TRN) in Malaysia.
	//
	// For individual, you can specify the taxInformationNumber in
	// MalaysiaAdditionalInfo with NRIC type, and a valid MyKad or NRIC number. For
	// business, you must specify a businessRegistrationNumber in
	// MalaysiaAdditionalInfo with a TIN type and tax identification number. For
	// business resellers, you must specify a businessRegistrationNumber and
	// taxInformationNumber in MalaysiaAdditionalInfo with a sales and service tax
	// (SST) type and a valid SST number.
	//
	// For business resellers with service codes, you must specify
	// businessRegistrationNumber , taxInformationNumber , and distinct serviceTaxCodes
	// in MalaysiaAdditionalInfo with a SST type and valid sales and service tax (SST)
	// number. By using this API operation, Amazon Web Services registers your
	// self-declaration that you’re an authorized business reseller registered with the
	// Royal Malaysia Customs Department (RMCD), and have a valid SST number.
	BusinessRegistrationNumber *string

	// List of service tax codes for your TRN in Malaysia.
	ServiceTaxCodes []MalaysiaServiceTaxCode

	// The tax information number in Malaysia.
	//
	// For individual, you can specify the taxInformationNumber in
	// MalaysiaAdditionalInfo with NRIC type, and a valid MyKad or NRIC number. For
	// business resellers, you must specify a businessRegistrationNumber and
	// taxInformationNumber in MalaysiaAdditionalInfo with a sales and service tax
	// (SST) type and a valid SST number.
	//
	// For business resellers with service codes, you must specify
	// businessRegistrationNumber , taxInformationNumber , and distinct serviceTaxCodes
	// in MalaysiaAdditionalInfo with a SST type and valid sales and service tax (SST)
	// number. By using this API operation, Amazon Web Services registers your
	// self-declaration that you’re an authorized business reseller registered with the
	// Royal Malaysia Customs Department (RMCD), and have a valid SST number.
	TaxInformationNumber *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Poland.
type PolandAdditionalInfo struct {

	//  The individual tax registration number (NIP). Individual NIP is valid for
	// other taxes excluding VAT purposes.
	IndividualRegistrationNumber *string

	//  True if your business is a member of a VAT group with a NIP active for VAT
	// purposes. Otherwise, this is false.
	IsGroupVatEnabled *bool

	noSmithyDocumentSerde
}

// Additional tax information to specify for a TRN in Romania.
type RomaniaAdditionalInfo struct {

	//  The tax registration number type. The value can be TaxRegistrationNumber or
	// LocalRegistrationNumber .
	//
	// This member is required.
	TaxRegistrationNumberType TaxRegistrationNumberType

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Saudi Arabia.
type SaudiArabiaAdditionalInfo struct {

	//  The tax registration number type.
	TaxRegistrationNumberType SaudiArabiaTaxRegistrationNumberType

	noSmithyDocumentSerde
}

// The Amazon S3 bucket in your account where your tax document is located.
type SourceS3Location struct {

	// The name of your Amazon S3 bucket that your tax document is located.
	//
	// This member is required.
	Bucket *string

	// The object key of your tax document object in Amazon S3.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in South Korea.
type SouthKoreaAdditionalInfo struct {

	// The business legal name based on the most recently uploaded tax registration
	// certificate.
	//
	// This member is required.
	BusinessRepresentativeName *string

	// Item of business based on the most recently uploaded tax registration
	// certificate.
	//
	// This member is required.
	ItemOfBusiness *string

	// Line of business based on the most recently uploaded tax registration
	// certificate.
	//
	// This member is required.
	LineOfBusiness *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Spain.
type SpainAdditionalInfo struct {

	// The registration type in Spain.
	//
	// This member is required.
	RegistrationType RegistrationType

	noSmithyDocumentSerde
}

// Supplemental TRN details.
type SupplementalTaxRegistration struct {

	//  The details of the address associated with the TRN information.
	//
	// This member is required.
	Address *Address

	//  Unique authority ID for the supplemental TRN.
	//
	// This member is required.
	AuthorityId *string

	//  The legal name associated with your TRN registration.
	//
	// This member is required.
	LegalName *string

	//  The supplemental TRN unique identifier.
	//
	// This member is required.
	RegistrationId *string

	//  Type of supplemental TRN. Currently, this can only be VAT.
	//
	// This member is required.
	RegistrationType SupplementalTaxRegistrationType

	//  The status of your TRN.
	//
	// This member is required.
	Status TaxRegistrationStatus

	noSmithyDocumentSerde
}

//	The supplemental TRN information to provide when adding or updating a
//
// supplemental TRN.
type SupplementalTaxRegistrationEntry struct {

	//  The details of the address associated with the TRN information.
	//
	// This member is required.
	Address *Address

	//  The legal name associated with your TRN registration.
	//
	// This member is required.
	LegalName *string

	//  The supplemental TRN unique identifier.
	//
	// This member is required.
	RegistrationId *string

	//  Type of supplemental TRN. Currently, this can only be VAT.
	//
	// This member is required.
	RegistrationType SupplementalTaxRegistrationType

	noSmithyDocumentSerde
}

// The metadata for your tax document.
type TaxDocumentMetadata struct {

	// The tax document access token, which contains information that the Tax Settings
	// API uses to locate the tax document.
	//
	// If you update your tax registration, the existing taxDocumentAccessToken won't
	// be valid. To get the latest token, call the GetTaxRegistration or
	// ListTaxRegistrations API operation. This token is valid for 24 hours.
	//
	// This member is required.
	TaxDocumentAccessToken *string

	// The name of your tax document.
	//
	// This member is required.
	TaxDocumentName *string

	noSmithyDocumentSerde
}

// The tax exemption.
type TaxExemption struct {

	// The address domain associate with tax exemption.
	//
	// This member is required.
	Authority *Authority

	// The tax exemption type.
	//
	// This member is required.
	TaxExemptionType *TaxExemptionType

	// The tax exemption effective date.
	EffectiveDate *time.Time

	// The tax exemption expiration date.
	ExpirationDate *time.Time

	// The tax exemption status.
	Status EntityExemptionAccountStatus

	// The tax exemption recording time in the TaxSettings system.
	SystemEffectiveDate *time.Time

	noSmithyDocumentSerde
}

// The tax exemption details.
type TaxExemptionDetails struct {

	// The indicator if the tax exemption is inherited from the consolidated billing
	// family management account.
	HeritageObtainedDetails *bool

	// The consolidated billing family management account the tax exemption inherited
	// from.
	HeritageObtainedParentEntity *string

	// The reason of the heritage inheritance.
	HeritageObtainedReason *string

	// Tax exemptions.
	TaxExemptions []TaxExemption

	noSmithyDocumentSerde
}

// The tax exemption type.
type TaxExemptionType struct {

	// The tax exemption's applicable jurisdictions.
	ApplicableJurisdictions []Authority

	// The tax exemption's type description.
	Description *string

	// The tax exemption's type display name.
	DisplayName *string

	noSmithyDocumentSerde
}

// Tax inheritance information associated with the account.
type TaxInheritanceDetails struct {

	//  Tax inheritance reason information associated with the account.
	InheritanceObtainedReason *string

	//  Tax inheritance parent account information associated with the account.
	ParentEntityId *string

	noSmithyDocumentSerde
}

// Your TRN information.
type TaxRegistration struct {

	//  The legal address associated with your TRN registration.
	//
	// This member is required.
	LegalAddress *Address

	//  The legal name associated with your TRN registration.
	//
	// This member is required.
	LegalName *string

	//  Your tax registration unique identifier.
	//
	// This member is required.
	RegistrationId *string

	// Type of your tax registration. This can be either VAT or GST .
	//
	// This member is required.
	RegistrationType TaxRegistrationType

	//  The status of your TRN. This can be either Verified , Pending , Deleted , or
	// Rejected .
	//
	// This member is required.
	Status TaxRegistrationStatus

	//  Additional tax information associated with your TRN.
	AdditionalTaxInformation *AdditionalInfoResponse

	// The email address to receive VAT invoices.
	CertifiedEmailId *string

	// The industry that describes your business. For business-to-business (B2B)
	// customers, specify Business. For business-to-consumer (B2C) customers, specify
	// Individual. For business-to-government (B2G), specify Government. Note that
	// certain values may not applicable for the request country. Please refer to
	// country specific information in API document.
	Sector Sector

	// The metadata for your tax document.
	TaxDocumentMetadatas []TaxDocumentMetadata

	noSmithyDocumentSerde
}

// The tax registration document.
type TaxRegistrationDocFile struct {

	// The tax registration document content.
	//
	// This member is required.
	FileContent []byte

	// The tax registration document name.
	//
	// This member is required.
	FileName *string

	noSmithyDocumentSerde
}

// Tax registration document information.
type TaxRegistrationDocument struct {

	// The tax registration document.
	File *TaxRegistrationDocFile

	// The Amazon S3 location where your tax registration document is stored.
	S3Location *SourceS3Location

	noSmithyDocumentSerde
}

// The TRN information you provide when you add a new TRN, or update.
type TaxRegistrationEntry struct {

	// Your tax registration unique identifier.
	//
	// This member is required.
	RegistrationId *string

	//  Your tax registration type. This can be either VAT or GST .
	//
	// This member is required.
	RegistrationType TaxRegistrationType

	//  Additional tax information associated with your TRN. You only need to specify
	// this parameter if Amazon Web Services collects any additional information for
	// your country within AdditionalInfoRequest.
	AdditionalTaxInformation *AdditionalInfoRequest

	// The email address to receive VAT invoices.
	CertifiedEmailId *string

	// The legal address associated with your TRN.
	//
	// If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to
	// specify the legal address.
	//
	// For TRNs in other countries and for CPF tax types Brazil, you must specify the
	// legal address.
	LegalAddress *Address

	// The legal name associated with your TRN.
	//
	// If you're setting a TRN in Brazil, you don't need to specify the legal name.
	// For TRNs in other countries, you must specify the legal name.
	LegalName *string

	// The industry that describes your business. For business-to-business (B2B)
	// customers, specify Business. For business-to-consumer (B2C) customers, specify
	// Individual. For business-to-government (B2G), specify Government.Note that
	// certain values may not applicable for the request country. Please refer to
	// country specific information in API document.
	Sector Sector

	// Additional details needed to verify your TRN information in Brazil. You only
	// need to specify this parameter when you set a TRN in Brazil that is the CPF tax
	// type.
	//
	// Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to
	// set a TRN for another country.
	VerificationDetails *VerificationDetails

	noSmithyDocumentSerde
}

// Your TRN information with jurisdiction details. This doesn't contain the full
// legal address associated with the TRN information.
type TaxRegistrationWithJurisdiction struct {

	//  The jurisdiction associated with your TRN information.
	//
	// This member is required.
	Jurisdiction *Jurisdiction

	// The legal name associated with your TRN information.
	//
	// This member is required.
	LegalName *string

	// Your tax registration unique identifier.
	//
	// This member is required.
	RegistrationId *string

	//  The type of your tax registration. This can be either VAT or GST .
	//
	// This member is required.
	RegistrationType TaxRegistrationType

	// The status of your TRN. This can be either Verified , Pending , Deleted , or
	// Rejected .
	//
	// This member is required.
	Status TaxRegistrationStatus

	// Additional tax information associated with your TRN.
	AdditionalTaxInformation *AdditionalInfoResponse

	// The email address to receive VAT invoices.
	CertifiedEmailId *string

	// The industry that describes your business. For business-to-business (B2B)
	// customers, specify Business. For business-to-consumer (B2C) customers, specify
	// Individual. For business-to-government (B2G), specify Government.Note that
	// certain values may not applicable for the request country. Please refer to
	// country specific information in API document.
	Sector Sector

	// The metadata for your tax document.
	TaxDocumentMetadatas []TaxDocumentMetadata

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Turkey.
type TurkeyAdditionalInfo struct {

	// The industry information that tells the Tax Settings API if you're subject to
	// additional withholding taxes. This information required for business-to-business
	// (B2B) customers. This information is conditionally mandatory for B2B customers
	// who are subject to KDV tax.
	Industries Industries

	// The Registered Electronic Mail (REM) that is used to send notarized
	// communication. This parameter is optional for business-to-business (B2B) and
	// business-to-government (B2G) customers. It's not required for
	// business-to-consumer (B2C) customers.
	KepEmailId *string

	//  Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided, we will use
	// your VKN as the secondary ID.
	SecondaryTaxId *string

	// The tax office where you're registered. You can enter this information as a
	// string. The Tax Settings API will add this information to your invoice. This
	// parameter is required for business-to-business (B2B) and business-to-government
	// customers. It's not required for business-to-consumer (B2C) customers.
	TaxOffice *string

	noSmithyDocumentSerde
}

// Additional tax information associated with your TRN in Ukraine.
type UkraineAdditionalInfo struct {

	//  The tax registration type.
	//
	// This member is required.
	UkraineTrnType UkraineTrnType

	noSmithyDocumentSerde
}

// The information about the specified parameter in the request that caused an
// error.
type ValidationExceptionField struct {

	// The name of the parameter that caused a ValidationException error.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Required information to verify your TRN.
type VerificationDetails struct {

	// Date of birth to verify your submitted TRN. Use the YYYY-MM-DD format.
	DateOfBirth *string

	// The tax registration document, which is required for specific countries such as
	// Bangladesh, Kenya, South Korea and Spain.
	TaxRegistrationDocuments []TaxRegistrationDocument

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
