// Code generated by smithy-go-codegen DO NOT EDIT.

package textract

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/textract/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists all adapters that match the specified filtration criteria.
func (c *Client) ListAdapters(ctx context.Context, params *ListAdaptersInput, optFns ...func(*Options)) (*ListAdaptersOutput, error) {
	if params == nil {
		params = &ListAdaptersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAdapters", params, optFns, c.addOperationListAdaptersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAdaptersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAdaptersInput struct {

	// Specifies the lower bound for the ListAdapters operation. Ensures ListAdapters
	// returns only adapters created after the specified creation time.
	AfterCreationTime *time.Time

	// Specifies the upper bound for the ListAdapters operation. Ensures ListAdapters
	// returns only adapters created before the specified creation time.
	BeforeCreationTime *time.Time

	// The maximum number of results to return when listing adapters.
	MaxResults *int32

	// Identifies the next page of results to return when listing adapters.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAdaptersOutput struct {

	// A list of adapters that matches the filtering criteria specified when calling
	// ListAdapters.
	Adapters []types.AdapterOverview

	// Identifies the next page of results to return when listing adapters.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAdaptersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListAdapters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListAdapters{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAdapters"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAdapters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAdaptersPaginatorOptions is the paginator options for ListAdapters
type ListAdaptersPaginatorOptions struct {
	// The maximum number of results to return when listing adapters.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAdaptersPaginator is a paginator for ListAdapters
type ListAdaptersPaginator struct {
	options   ListAdaptersPaginatorOptions
	client    ListAdaptersAPIClient
	params    *ListAdaptersInput
	nextToken *string
	firstPage bool
}

// NewListAdaptersPaginator returns a new ListAdaptersPaginator
func NewListAdaptersPaginator(client ListAdaptersAPIClient, params *ListAdaptersInput, optFns ...func(*ListAdaptersPaginatorOptions)) *ListAdaptersPaginator {
	if params == nil {
		params = &ListAdaptersInput{}
	}

	options := ListAdaptersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAdaptersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAdaptersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAdapters page.
func (p *ListAdaptersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAdaptersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAdapters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAdaptersAPIClient is a client that implements the ListAdapters operation.
type ListAdaptersAPIClient interface {
	ListAdapters(context.Context, *ListAdaptersInput, ...func(*Options)) (*ListAdaptersOutput, error)
}

var _ ListAdaptersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAdapters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAdapters",
	}
}
